// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Data;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.BLogic
{
    /// <summary>
    /// XMLf[^̑MAt@C̎MsrWlXWbNNXłB
    /// </summary>
    /// <remarks>
    /// <see cref="BinaryFileDownloadCommunicator"/> gpăT[oƒʐMs܂B
    /// </remarks>
    public class BinaryFileDownloadBLogic : CommunicateBLogicBase<DataSet>
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BinaryFileDownloadBLogic));

        /// <summary>
        /// T[oM_E[ht@CCxgnh֑MۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "ContentFileName" łB</para></remarks>
        public static readonly string CONTENT_FILENAME = "ContentFileName";

        /// <summary>
        /// _E[ht@C̃pX <see cref="BLogicResult.Items"/> Ɋi[鎞̃L[łB
        /// </summary>
        /// <remarks><para>̒萔̒l "DownloadFilePath" łB</para></remarks>
        public static readonly string DOWNLOAD_FILEPATH = "DownloadFilePath";

        /// <summary>
        /// is󋵃Cxgnhփ_E[hʒmsۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "DownloadReady" łB</para></remarks>
        public static readonly string DOWNLOAD_READY = "DownloadReady";

        /// <summary>
        /// <see cref="BinaryFileDownloadBLogic"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public BinaryFileDownloadBLogic()
        {
        }

        /// <summary>
        /// XMLf[^̑MAt@C̎Ms <see cref="ICommunicator{DataSet}"/> 𐶐܂B
        /// </summary>
        /// <remarks>
        /// ł <see cref="BinaryFileDownloadCommunicator"/> 𐶐܂B
        /// </remarks>
        /// <returns>
        /// XMLf[^̑MAt@C̎Ms <see cref="ICommunicator{DataSet}"/>B
        /// </returns>
        protected override ICommunicator<DataSet> CreateCommunicator()
        {
            return new BinaryFileDownloadCommunicator();
        }

        /// <summary>
        /// XMLf[^̑MAt@C̎Ms܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="BinaryFileDownloadCommunicator"/>  <see cref="BinaryFileDownloadCommunicator.Download"/> s܂B
        /// <see cref="BinaryFileDownloadCommunicator.Download"/> ł͓̓f[^ <paramref name="communicateBLogicParam"/> 
        /// XMLɕϊăT[o֑MAMt@C[Jɕۑ܂Bt@C[Jɕۑꂽꍇ́A
        /// <see cref="DownloadResult"/>  <see cref="DownloadResult.DownloadFilePath"/> Ƀt@CpXݒ肳܂B
        /// t@C[JɕۑȂꍇ́A<see cref="DownloadResult.DownloadFilePath"/>  null QƂłB
        /// </para>
        /// <para>
        /// ʐMNXƂāAł <see cref="BinaryFileDownloadCommunicator"/> 𗘗p܂B
        /// </para>
        /// </remarks>
        /// <param name="communicateBLogicParam">
        /// T[oAvP[V֑M <see cref="BLogicParam"/>B
        /// </param>
        /// <param name="requestHeaders">
        /// NGXg̃wb_\閼Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B
        /// </param>
        /// <returns>
        /// ʐMʂi[ <see cref="DownloadResult"/>B
        /// </returns>
        /// <exception cref="ArgumentException">
        /// ʐMŕKvȃf[^słB
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oAvP[Vőz肵ȂO܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// f[^̑MɃG[܂B
        /// </exception>
        protected override CommunicationResult Communicate(BLogicParam communicateBLogicParam, 
                                                           IDictionary<string, string> requestHeaders)
        {
            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_BEGIN_COMMUNICATOR_FUNCTION, Communicator.GetType().FullName));
            }

            DownloadResult result =
                ((BinaryFileDownloadCommunicator)Communicator).Download(communicateBLogicParam.ParamData, requestHeaders);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_END_COMMUNICATOR_FUNCTION, Communicator.GetType().FullName));
            }

            return result;
        }

        /// <summary>
        /// ʐM̌㏈s܂B
        /// </summary>
        /// <remarks>
        /// <paramref name="communicationResult"/>  <see cref="DownloadResult"/> ^
        /// <see cref="DownloadResult.DownloadFilePath"/> Ƀ_E[ht@C̃pXݒ肳Ăꍇ́A
        /// <see cref="BLogicResult.Items"/>  <see cref="DOWNLOAD_FILEPATH"/> L[Ƃ
        /// t@CpX̕ݒ肷B
        /// </remarks>
        /// <param name="blogicResult">rWlXWbNʂi[ <see cref="BLogicResult"/> CX^XB</param>
        /// <param name="communicationResult">ʐM̌ʂێ <see cref="CommunicationResult"/> CX^XB</param>
        protected override void AfterCommunicate(CommunicationResult communicationResult, BLogicResult blogicResult)
        {
            base.AfterCommunicate(communicationResult, blogicResult);

            DownloadResult downloadResult = communicationResult as DownloadResult;
            if (string.IsNullOrEmpty(downloadResult.DownloadFilePath))
            {
                return;
            }

            blogicResult.Items[DOWNLOAD_FILEPATH] = downloadResult.DownloadFilePath;
        }
    }
}
