﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using TERASOLUNA.Fw.Common.Validation.Validators;
using System.Reflection;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.Configuration.NumberValidatorData のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.Configuration.NumberValidatorData 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class NumberValidatorDataTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest01()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));

            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsTrue(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 3);
            Assert.IsTrue(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, nval.MessageTemplate);
            Assert.IsTrue(nval.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest02()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = typeof(RequiredValidator);
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));

            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsTrue(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 3);
            Assert.IsTrue(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, nval.MessageTemplate);
            Assert.IsTrue(nval.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのIntegerLengthが-3の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest03()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = -3;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのIntegerLengthが0の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest04()
        {

            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 0;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのScaleが-3の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest05()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = -3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }


        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのScaleが-3の場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest06()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = 0;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));
            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsTrue(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 0);
            Assert.IsTrue(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, nval.MessageTemplate);
            Assert.IsTrue(nval.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのIsAccordedIntegerがfalseの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest07()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = false;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));
            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsFalse(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 3);
            Assert.IsTrue(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, nval.MessageTemplate);
            Assert.IsTrue(nval.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのIsAccordedScaleがfalseの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest08()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = false;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));

            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsTrue(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 3);
            Assert.IsFalse(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, nval.MessageTemplate);
            Assert.IsTrue(nval.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのMessageTemplateが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest09()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = "aaa";
            target.Negated = true;
            target.Tag = null;

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));
            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsTrue(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 3);
            Assert.IsTrue(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, null);
            Assert.AreEqual<string>(nval.MessageTemplate,
                                  "aaa");
            Assert.IsTrue(nval.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのNegatedがtrueの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest10()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = null;

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));
            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsTrue(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 3);
            Assert.IsTrue(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, nval.MessageTemplate);
            Assert.IsFalse(nval.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのTagが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、IntegerLength、Scale、IsAccordedIntegeris、IsAccordedScale、
        /// Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest11()
        {
            // 生成
            NumberValidatorData target = new NumberValidatorData();

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_NumberValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.IntegerLength = 3;
            target.IsAccordedInteger = true;
            target.Scale = 3;
            target.IsAccordedScale = true;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = "aaa";

            Validator val = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsInstanceOfType(val, typeof(NumberValidator));

            NumberValidator nval = (NumberValidator)val;
            Assert.AreEqual<int>(nval.IntegerLength, 3);
            Assert.IsTrue(nval.IsAccordedInteger);
            Assert.AreEqual<int>(nval.Scale, 3);
            Assert.IsTrue(nval.IsAccordedScale);
            Assert.AreEqual<string>(nval.Tag, "aaa");
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, nval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// IntegerLengthプロパティのテスト
        /// </summary>
        /// <remarks>
        /// プロパティに値が設定され、取得した値が適切であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void IntegerLengthTest()
        {
            NumberValidatorData target = new NumberValidatorData();

            Assert.AreEqual(0, target.IntegerLength);

            int val = 5;
            target.IntegerLength = val;

            Assert.AreEqual(val, target.IntegerLength);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// IsAccordedIntegerプロパティのテスト
        /// </summary>
        /// <remarks>
        /// プロパティに値が設定され、取得した値が適切であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void IsAccordedIntegerTest()
        {
            NumberValidatorData target = new NumberValidatorData();

            Assert.AreEqual(false, target.IsAccordedInteger);

            bool val = true;
            target.IsAccordedInteger = val;


            Assert.AreEqual(val, target.IsAccordedInteger);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// IsAccordedScaleプロパティのテスト
        /// </summary>
        /// <remarks>
        /// プロパティに値が設定され、取得した値が適切であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void IsAccordedScaleTest()
        {
            NumberValidatorData target = new NumberValidatorData();

            Assert.AreEqual(false, target.IsAccordedScale);

            bool val = true;
            target.IsAccordedScale = val;

            Assert.AreEqual(val, target.IsAccordedScale);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// Scaleプロパティのテスト
        /// </summary>
        /// <remarks>
        /// プロパティに値が設定され、取得した値が適切であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ScaleTest()
        {
            NumberValidatorData target = new NumberValidatorData();

            Assert.AreEqual(0, target.Scale);

            int val = 5;
            target.Scale = val;

            Assert.AreEqual(val, target.Scale);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidatorData), LogLevel.INFO));
        }
    }
}
