﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Configuration.Conversion;
using System.Xml;
using TERASOLUNA.Fw.Client.Configuration;
using System.Configuration;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.Xml.Schema;
using System.IO;

namespace TERASOLUNA.Fw.ClientUT.Configuration.Conversion
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Configuration.Conversion.ConversionConfigurationSection のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Configuration.Conversion.ConversionConfigurationSection 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ConversionConfigurationSectionTest
    {
        private TestContext testContextInstance;

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE01 = "ConversionConfigurationSection_Section01.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE02 = "ConversionConfigurationSection_Section02.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE03 = "ConversionConfigurationSection_Section03.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE04 = "ConversionConfigurationSection_Section04.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE05 = "ConversionConfigurationSection_Section05.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE06 = "ConversionConfigurationSection_Section06.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE07 = "ConversionConfigurationSection_Section07.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE08 = "ConversionConfigurationSection_Section08.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE09 = "ConversionConfigurationSection_Section09.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE10 = "ConversionConfigurationSection_Section10.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE11 = "ConversionConfigurationSection_Section11.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE12 = "ConversionConfigurationSection_Section12.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE13 = "ConversionConfigurationSection_Section13.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE14 = "ConversionConfigurationSection_Section14.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE15 = "ConversionConfigurationSection_Section15.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE16 = "ConversionConfigurationSection_Section16.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE17 = "ConversionConfigurationSection_Section17.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE18 = "ConversionConfigurationSection_Section18.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE19 = "ConversionConfigurationSection_Section19.config";

        ///<summary>
        /// 異常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE20 = "ConversionConfigurationSection_Section20.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE21 = "ConversionConfigurationSection_Section21.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE22 = "ConversionConfigurationSection_Section22.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE23 = "ConversionConfigurationSection_Section23.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE24 = "ConversionConfigurationSection_Section24.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE25 = "ConversionConfigurationSection_Section25.config";

        ///<summary>
        /// 正常系の変換設定ファイルです。
        ///</summary>
        private const string CONFIG_FILE26 = "ConversionConfigurationSection_Section26.config";


        ///<summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        ///<summary>
        /// ConversionConfigurationSection () のテスト
        ///</summary>
        ///<remarks>
        /// デフォルトコンストラクタを呼び出し、正しくインスタンス化されることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            ConversionConfigurationSection target = new ConversionConfigurationSection();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// ConvertCollection のテスト
        ///</summary>
        ///<remarks>
        /// 設定ファイルを読み込んでいない場合、空のコレクションが返却されることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConvertCollectionTest01()
        {
            ConversionConfigurationSection target = new ConversionConfigurationSection();
            ConvertCollection actual = target.ConvertCollection;
            Assert.IsNotNull(actual);
            Assert.AreEqual(0, actual.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// Files のテスト
        ///</summary>
        ///<remarks>
        /// 設定ファイルを読み込んでいない場合、空のコレクションが返却されることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void FilesTest01()
        {
            ConversionConfigurationSection target = new ConversionConfigurationSection();
            FilesCollection actual = target.Files;
            Assert.IsNotNull(actual);
            Assert.AreEqual(0, actual.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// スキーマに合致した外部設定ファイルを読み込んだ場合
        /// ConvertCollectionが取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section01.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External01.config")]
        public void CreateConvertElementsTest01()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE01);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].DestName);
            Assert.AreEqual("Info.DestName", target.ConvertCollection["getDest"].Result.Columns[1].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest"].Result.Columns[1].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// 値は異常だが、スキーマに合致した外部設定ファイルを読み込んだ場合
        /// ConvertCollectionが取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section02.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External02.config")]
        public void CreateConvertElementsTest02()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE02);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(2, target.ConvertCollection.Count);
            Assert.AreEqual(0, target.ConvertCollection["Unsafe1"].Param.Columns.Count);
            Assert.AreEqual(0, target.ConvertCollection["Unsafe1"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["Unsafe2"].Param.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["Unsafe2"].Result.Columns.Count);
            Assert.AreEqual("||||", target.ConvertCollection["Unsafe2"].Param.Columns[0].SrcName);
            Assert.AreEqual("....", target.ConvertCollection["Unsafe2"].Param.Columns[0].DestName);
            Assert.AreEqual("0123456789", target.ConvertCollection["Unsafe2"].Result.Columns[0].SrcName);
            Assert.AreEqual("     ", target.ConvertCollection["Unsafe2"].Result.Columns[0].DestName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// param要素が無い外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section03.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External03.config")]
        public void CreateConvertElementsTest03()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE03);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));              
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
           
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// results要素が無い外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section04.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External04.config")]
        public void CreateConvertElementsTest04()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE04);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// param要素が複数存在する外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section05.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External05.config")]
        public void CreateConvertElementsTest05()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE05);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;


            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// result要素が複数存在する外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section06.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External06.config")]
        public void CreateConvertElementsTest06()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE06);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// src属性がない外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section07.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External07.config")]
        public void CreateConvertElementsTest07()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE07);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// src属性の文字長が0の外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section08.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External08.config")]
        public void CreateConvertElementsTest08()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE08);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// clear-table要素にtable属性が無いの外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section09.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External09.config")]
        public void CreateConvertElementsTest09()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE09);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// 重複したconverter idを持つ外部設定ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section10.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External10.config")]
        public void CreateConvertElementsTest10()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE10);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// file要素がない構成ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section11.config")]
        public void CreateConvertElementsTest11()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE11);
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                //確認
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", sectionName);
                Assert.AreEqual(message, e.Message);
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// 存在しないファイルを指定した構成ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section12.config")]
        public void CreateConvertElementsTest12()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE12);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(IOException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// ファイルパスに使えない文字列を含んだ構成ファイルを読み込んだ場合
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section13.config")]
        public void CreateConvertElementsTest13()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE13);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;
            
            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string filePath = Environment.CurrentDirectory + @"\Nothing>config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }


        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// 256文字以上のパス名を含んだ構成ファイルを読み込んだ場合
        /// ConversionErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section14.config")]
        public void CreateConvertElementsTest14()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE14);
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string filePath = Environment.CurrentDirectory + @"\1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(PathTooLongException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));

        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// スキーマ指定が間違っており、かつsrc属性が無い場合に
        /// TerasolunaExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section15.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External11.config")]
        public void CreateConvertElementsTest15()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE15);
            string column = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.ELEMENT_NAME_COLUMN;
            string src = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.ATTRIBUTE_NAME_SRC_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                string message = MessageManager.GetMessage("E_CONVERSION_ATTRIBUTE_NOT_FOUND",column, src);
                Assert.AreEqual(message, e.Message);
      
            }
            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ConversionConfigurationSection), typeof(TerasolunaException), "E_CONVERSION_ATTRIBUTE_NOT_FOUND", column, src));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// スキーマ指定が間違っており、かつclear-view@table属性が無い場合に
        /// TerasolunaExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section16.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External12.config")]
        public void CreateConvertElementsTest16()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE16);
            string clear = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.ELEMENT_NAME_CLEAR_VIEW;
            string table = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.ATTRIBUTE_NAME_TABLE_NAME;
      
            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                string message = MessageManager.GetMessage("E_CONVERSION_ATTRIBUTE_NOT_FOUND",clear, table);
                Assert.AreEqual(message, e.Message);
            }
            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ConversionConfigurationSection), typeof(TerasolunaException), "E_CONVERSION_ATTRIBUTE_NOT_FOUND", clear, table));

        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// データセット変換ファイルが複数指定されている場合でも、
        /// ConvertCollectionが正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section17.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External13.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External14.config")]
        public void CreateConvertElementsTest17()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE17);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(2, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest2"].Param.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest2"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest2"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].DestName);
            Assert.AreEqual("Info.DestName", target.ConvertCollection["getDest"].Result.Columns[1].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest"].Result.Columns[1].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);

            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest2"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest2"].Param.Columns[0].DestName);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest2"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest2"].Result.Columns[0].DestName);
            Assert.AreEqual("Info.DestName", target.ConvertCollection["getDest2"].Result.Columns[1].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest2"].Result.Columns[1].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest2"].Result.ClearViews[0].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// データセット変換ファイルのルートノード名がconversionConfigurationでない場合
        /// 正常に読み込まれることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section18.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External15.config")]
        public void CreateConvertElementsTest18()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE18);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].DestName);
            Assert.AreEqual("Info.DestName", target.ConvertCollection["getDest"].Result.Columns[1].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest"].Result.Columns[1].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// データセット変換ファイルにconvertファイルが一つも存在しない場合、
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section19.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External23.config")]
        public void CreateConvertElementsTest19()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE19);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;
            
            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                //確認
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// convertノードにおいて、paramノード、resultノードがともに存在しない場合、
        /// ConfigurationErrorsExceptionがスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section20.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External16.config")]
        public void CreateConvertElementsTest20()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE20);
            FilesCollection files = target.Files;
            string sectionName = TERASOLUNA_Fw_Client_Configuration_Conversion_ConversionConfigurationSectionAccessor.SECTION_NAME;

            try
            {
                target.CreateConvertElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                //確認
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path));
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// paramノードにおいて、columnが1つも存在しない場合でも、
        /// ConvertCollectionが正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section21.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External17.config")]
        public void CreateConvertElementsTest21()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE21);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(0, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].DestName);
            Assert.AreEqual("Info.DestName", target.ConvertCollection["getDest"].Result.Columns[1].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest"].Result.Columns[1].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// resultノードにおいて、columnが1つも存在しない場合でも、
        /// ConvertCollectionが正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section22.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External18.config")]
        public void CreateConvertElementsTest22()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE22);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(0, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// resultノードにおいて、clear-tableが1つも存在しない場合でも、
        /// ConvertCollectionが正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section23.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External19.config")]
        public void CreateConvertElementsTest23()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE23);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(0, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].DestName);
            Assert.AreEqual("Info.DestName", target.ConvertCollection["getDest"].Result.Columns[1].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest"].Result.Columns[1].DestName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// resultノードに、clear-tableが複数存在し、table名が重複する場合、
        /// ConvertCollectionが正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section24.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External20.config")]
        public void CreateConvertElementsTest24()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE24);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].DestName);
            Assert.AreEqual("Info.DestName", target.ConvertCollection["getDest"].Result.Columns[1].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest"].Result.Columns[1].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// columnノードが複数存在し、src属性が重複する場合、
        /// ConvertCollectionが正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section25.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External21.config")]
        public void CreateConvertElementsTest25()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE25);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Result.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestName", target.ConvertCollection["getDest"].Result.Columns[0].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }

        ///<summary>
        /// CreateConvertElements () のテスト
        ///</summary>
        ///<remarks>
        /// resultノードに、clear-tableが複数存在する場合、
        /// ConvertCollectionが正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_Section26.config")]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationSectionTestData\ConversionConfigurationSection_External22.config")]
        public void CreateConvertElementsTest26()
        {
            ConversionConfigurationSection target =
                ConfigTestHelper.GetConversionConfigurationSectionFromCustomFile(CONFIG_FILE26);

            target.CreateConvertElements();

            Assert.IsNotNull(target.ConvertCollection);
            Assert.AreEqual(1, target.ConvertCollection.Count);
            Assert.AreEqual(1, target.ConvertCollection["getDest"].Param.Columns.Count);
            Assert.AreEqual(0, target.ConvertCollection["getDest"].Result.Columns.Count);
            Assert.AreEqual(2, target.ConvertCollection["getDest"].Result.ClearViews.Count);
            Assert.AreEqual("Info.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].SrcName);
            Assert.AreEqual("DtoDest.DestCode", target.ConvertCollection["getDest"].Param.Columns[0].DestName);
            Assert.AreEqual("Info", target.ConvertCollection["getDest"].Result.ClearViews[0].TableName);
            Assert.AreEqual("Info2", target.ConvertCollection["getDest"].Result.ClearViews[1].TableName);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionConfigurationSection), LogLevel.INFO));
        }
    }

}
