// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Utlib.Logging;
using System.Data;
using TERASOLUNA.Fw.Client.BLogic;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Client;
namespace TERASOLUNA.Fw.ClientUT.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.BLogic.CommunicateBLogicBase&lt;P, R&gt; のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.BLogic.CommunicateBLogicBase&lt;P, R&gt; 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class CommunicateBLogicBaseTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        ///<summary>
        /// Cancel01 のテスト
        ///</summary>
        ///<remarks>
        /// Cancelledプロパティにtrueが設定されていることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void CancelledTest01()
        {
            // 準備
            CommunicateBLogicBaseImpl01 target = new CommunicateBLogicBaseImpl01();
            target.Cancelled = false;
            target._communicator._calledFlag = false;

            // 実施
            target.Cancel();

            //検証
            Assert.IsTrue(target.Cancelled);
            Assert.IsTrue(target._communicator._calledFlag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
        }

        /// <summary>
        /// DoProgressChanged(ExecuteProgressChangedEventArgs) のテスト
        /// </summary>
        /// <remarks>
        /// 正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DoProgressChanged01()
        {
            // 準備
            CommunicateBLogicBaseImpl01 target = new CommunicateBLogicBaseImpl01();
            ExecuteProgressChangedEventArgs e = new ExecuteProgressChangedEventArgs(100);
            target._calledOnProgressChanged = false;

            // 実施
            target.CallDoProgressChanged(e);

            // 確認
            Assert.IsTrue(target._calledOnProgressChanged);
            Assert.AreSame(e, target._e);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
        }
    }
}
