// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Net;
using System.Text;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// XML M@\񋟂NXłB
    /// </summary>
    public class DataSetXmlSender : SenderBase<DataSet>
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(DataSetXmlSender));

        /// <summary>
        /// Mɗp Content-Typewb_̒lłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "text/xml;charset=utf-8" łB
        /// </remarks>
        protected static readonly string CONTENT_TYPE = "text/xml;charset=utf-8";

        /// <summary>
        /// M XML f[^ރ[hłB
        /// </summary>
        private XmlWriteMode _writeMode = XmlWriteMode.IgnoreSchema;

        /// <summary>
        /// M XML f[^ރ[h\ <see cref="XmlWriteMode"/> l擾܂͐ݒ肵܂B
        /// </summary>
        /// <remarks>
        /// ̃vpeB̃ftHgl "IgnoreSchema" łB
        /// </remarks>
        public XmlWriteMode WriteMode
        {
            get
            {
                return _writeMode;
            }
            set
            {
                _writeMode = value;
            }
        }

        /// <summary>
        /// Mɗp Content-Typewb_̒l擾܂B
        /// </summary>
        /// <remarks>
        ///  "text/xml;charset=utf-8" Ԃ܂B
        /// </remarks>
        public override string ContentType
        {
            get
            {
                return CONTENT_TYPE;
            }
        }

        /// <summary>
        /// <see cref="DataSetXmlSender"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public DataSetXmlSender()
        {
        }

        /// <summary>
        /// <paramref name="request"/> œnꂽ <see cref="HttpWebRequest"/> pāA
        /// <paramref name="paramData"/>  <paramref name="headerCollection"/> ̏
        /// M܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// MHTTP NGXg{fB <paramref name="paramData"/>  <see cref="DataSet.WriteXml(Stream)"/> 
        /// \bhŏoXMLf[^ł 
        /// </para>
        /// <para>
        /// HTTP NGXgwb_ɂ <paramref name="headerCollection"/> Ɋi[ꂽL[/l̏񂪑SĒǉ܂B
        /// <paramref name="headerCollection"/> Ɋi[L[/l͂ꂼ HTTP NGXgwb_̃L[/lƂėp
        /// \Ȍ`𖞑Kv܂B͋ḰARFC 2616 "request-header" Œ`Ă܂B
        /// </para>
        /// <para>
        /// XML f[^ <see cref="DataSet.WriteXml(Stream, XmlWriteMode)"/> \bhpď܂܂B̂ƂA
        /// XL[}𗘗p邩ǂ <see cref="WriteMode"/> vpeB̒lɂČ܂܂B
        /// </para>
        /// <para>
        /// <paramref name="reporter"/>  <c>null</c> QƂł͂ȂꍇA
        /// <see cref="SenderBase{TParam}.BufferSize"/> vpeBɐݒ肳ꂽobt@TCỸf[^iftHg8 KB jT[oɑM閈ɁA
        /// <see cref="IProgressChangeReporter.ReportProgressChanged"/> Cxg𔭐܂B
        /// </para>
        /// </remarks>
        /// <param name="request">MsNGXgIuWFNgB</param>
        /// <param name="paramData">Mf[^i[IuWFNgB</param>
        /// <param name="headerCollection">MHTTPwb_Ƃėpwb_̃RNVB</param>
        /// <param name="reporter">is󋵒ʒms <see cref="IProgressChangeReporter"/> CX^XB </param> 
        /// <exception cref="WebException">
        /// ʐMG[܂B܂́ANGXgLZ܂B
        /// </exception>
        protected override void SendRequest(HttpWebRequest request,
                                            DataSet paramData,
                                            IDictionary<string, string> headerCollection,
                                            IProgressChangeReporter reporter)
        {
            byte[] buffer = new byte[BufferSize];
            using (Stream stream = new MemoryStream())
            {
                // DataSet̃f[^XML`Streamɏ
                paramData.WriteXml(stream, WriteMode);

                stream.Position = 0;

                long sendSize = 0L;
                long totalSize = stream.Length;

                // ContentLength̐ݒ
                request.ContentLength = totalSize;
                int percentage = 0;
                using (Stream reqStream = request.GetRequestStream())
                {
                    // M̃Oo
                    if (_log.IsTraceEnabled)
                    {
                        // URL
                        _log.Trace(string.Format(
                            Properties.Resources.T_REQUEST_SEND_ADDRESS, request.Address));

                        // HTTPwb_
                        StringBuilder requestHeaders = new StringBuilder();
                        requestHeaders.AppendLine(Properties.Resources.T_REQUEST_SEND_HEADER);
                        foreach (string key in request.Headers.AllKeys)
                        {
                            requestHeaders.AppendLine(string.Format(
                            Properties.Resources.T_DICTIONARY_KEY_VALUE, key, request.Headers[key]));
                        }
                        _log.Trace(requestHeaders.ToString().Trim());

                        // HTTP{fB
                        StringBuilder requestBody = new StringBuilder();
                        requestBody.AppendLine(Properties.Resources.T_REQUEST_SEND_BODY);
                        requestBody.Append(paramData.GetXml());
                        _log.Trace(requestBody.ToString());
                    }

                    int readSize = 0;

                    // obt@TCYM閈ɃCxgʒms
                    readSize = stream.Read(buffer, 0, BufferSize);
                    while (readSize > 0)
                    {
                        reqStream.Write(buffer, 0, readSize);
                        sendSize += readSize;
                        if (reporter != null)
                        {
                            if (totalSize > 0)
                            {
                                percentage = CalcSendPercentage(sendSize, totalSize);
                            }
                            reporter.ReportProgressChanged(new ExecuteProgressChangedEventArgs(percentage));
                        }
                        readSize = stream.Read(buffer, 0, BufferSize);
                    }
                }
            }
        }
    }
}
