﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using System.Configuration;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Configuration
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.Configuration.TerasolunaConfiguration のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.Configuration.TerasolunaConfiguration 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class TerasolunaConfigurationTest
    {

        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor._blogicConfigSection = null;
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor.BLOGIC_CONFIGURATION_SECTION_NAME = "blogicConfiguration";
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor._blogicConfigSection = null;
        }
        
        #endregion

        /// <summary>
        /// BLogicConfigSection のテスト
        /// </summary>
        /// <TestTarget>BLogicConfigSection</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>BLogicConfigurationSectionのインスタンスが取得され、blogic要素が存在すること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestBLogicConfigSection01()
        {
            // 実施
            BLogicConfigurationSection target = TerasolunaConfiguration.BLogicConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaConfiguration), LogLevel.INFO));
            Assert.IsInstanceOfType(target, typeof(BLogicConfigurationSection));
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor._blogicConfigSection);
            Assert.IsTrue(target.BLogicCollection.Count > 0);
        }

        /// <summary>
        /// BLogicConfigSection のテスト
        /// </summary>
        /// <TestTarget>BLogicConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"blogicConfiguration"キーがあり、
        /// value 属性が BLogicConfigurationSection 型ではないこと
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void TestBLogicConfigSection02()
        {
            // 準備
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor.BLOGIC_CONFIGURATION_SECTION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                BLogicConfigurationSection target = TerasolunaConfiguration.BLogicConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "BLogicConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "BLogicConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// BLogicConfigSection のテスト
        /// </summary>
        /// <TestTarget>BLogicConfigSection</TestTarget>
        /// <TestCondition>構成ファイルのappSettings要素に"blogicConfiguration"キーがないこと</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestBLogicConfigSection03()
        {
            // 準備
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor.BLOGIC_CONFIGURATION_SECTION_NAME = "noConfiguration";

            // 実施
            BLogicConfigurationSection target = TerasolunaConfiguration.BLogicConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor._blogicConfigSection);
        }

    }


}
