// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.ComponentModel;
using TERASOLUNA.Fw.Common.BLogic;

namespace TERASOLUNA.Fw.Client
{
    /// <summary>
    /// <see cref="EventController.ExecuteCompleted"/> Cxg̃f[^񋟂܂B
    /// </summary>
    /// <remarks>
    /// Cxg@\񋟂銮Cxg (<see cref="EventController.ExecuteCompleted"/>) 
    /// ̃Cxgnh֓np^łB
    /// </remarks>
    public class BLogicCompletedEventArgs : AsyncCompletedEventArgs
    {
        /// <summary>
        /// <see cref="Coordinator"/> ł̏ʂi[܂B
        /// </summary>
        private ExecutionResult _executionResult = null;

        /// <summary>
        /// <see cref="IBLogic"/> ̎sʂi[ <see cref="BLogicResult"/> łB
        /// </summary>
        private BLogicResult _blogicResult = null;

        /// <summary>
        /// 񓯊̌ʂ\l擾܂B
        /// </summary>
        /// <value>
        /// 񓯊̌ʂ\ <see cref="ExecutionResult"/> B
        /// </value>
        public ExecutionResult ExecutionResult
        {
            get
            {
                return _executionResult;
            }
        }

        /// <summary>
        /// <see cref="IBLogic"/> ̎sʂi[ <see cref="BLogicResult"/> 擾܂B
        /// </summary>
        /// <value>
        /// <see cref="IBLogic"/> ̎sʂi[ <see cref="BLogicResult"/> B
        /// </value>
        public BLogicResult BLogicResult
        {
            get
            {
                return _blogicResult;
            }
        }

        /// <summary>
        /// <see cref="ExecuteCompletedEventArgs"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="executionResult">
        /// <see cref="Coordinator"/> ł̏ʁB
        /// </param>
        /// <param name="blogicResult">
        /// <see cref="IBLogic"/> ̎sʁB
        /// </param>
        /// <param name="error">
        /// <see cref="Coordinator"/>  catch OB
        /// </param>
        /// <param name="cancelled">
        /// rWlXWbNLZꂽǂlB
        /// </param>
        public BLogicCompletedEventArgs(ExecutionResult executionResult, BLogicResult blogicResult, Exception error, bool cancelled)
            : base(error, cancelled, null)
        {
            _executionResult = executionResult;
            _blogicResult = blogicResult;
        }
    }
}
