﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration;
using System.Reflection;
using System.Xml.Schema;
using System.Xml;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.IO;

namespace TERASOLUNA.Fw.CommonUT.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Configuration.XmlDocumentValidator のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Configuration.XmlDocumentValidator 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class XmlDocumentValidatorTest
    {
        private TestContext testContextInstance;
        private const string XML_SCHEMA_DLLNAME = "TestItem_XMLSchemaTest1.dll";
        private const string XML_SCHEMA_NAME = @"TestItem_XMLSchema1.xsd";
        private const string XML_SCHEMA_NAMESPACE = "http://www.terasoluna.jp/schema/TestItem_XMLSchema1.xsd";
        private const string XML_SCHEMA_FILEPATH = @"TestItem_XMLSchema1.xsd";
        private const string XML_SCHEMA_ASPPATH = @"TestItem_XMLSchemaTest1.TestXMLSchemaFile1.xsd";
        private const string XML_SCHEMA_NAMESPACE_2 = "http://www.terasoluna.jp/schema/TestItem_XMLSchema2.xsd";
        private const string XML_SCHEMA_FILEPATH_2 = @"TestItem_XMLSchema2.xsd";

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///XmlDocumentValidator () のテスト
        ///</summary>
        [TestMethod()]
        public void TestConstructor()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            Assert.IsNotNull(target, string.Format("{0}はNullであってはいけません。", "target"));

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, Assembly, string)</TestTarget>
        /// <TestCondition>すべての引数に正しい値を設定すること。</TestCondition>
        /// <TestAssertion>例外がスローされないこと。</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema01()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            Assembly objAsm = GetAssembly();
            string strSchema = XML_SCHEMA_ASPPATH;

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
            }
            catch (System.Exception ex)
            {
                Assert.Fail("予期せぬ例外が発生しました。", ex.GetType(), ex.Message);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, Assembly, string)</TestTarget>
        /// <TestCondition>名前空間を示す引数がnullであること。</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが返却されること</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema02()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = null;
            Assembly objAsm = GetAssembly();
            string strSchema = XML_SCHEMA_ASPPATH;

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("nameSpace", e.ParamName);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "nameSpace"));
        }
        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, Assembly, string)</TestTarget>
        /// <TestCondition>名前空間を示す引数が空文字であること。</TestCondition>
        /// <TestAssertion>ArgumentExceptionが返却されること。</TestAssertion>
        /// <TestAssertion>Messageプロパティに適切なメッセージが設定されていること。</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema03()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = "";
            Assembly objAsm = GetAssembly();
            string strSchema = XML_SCHEMA_ASPPATH;

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "nameSpace"), e.Message);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentException), "E_EMPTY_STRING", "nameSpace"));
        }

        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, Assembly, string)</TestTarget>
        /// <TestCondition>XMLスキーマが埋め込まれたアセンブリを示す引数がnullであること。</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが返却されること。</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema04()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            Assembly objAsm = null;
            string strSchema = XML_SCHEMA_NAME;

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("asm", e.ParamName);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "asm"));
        }
        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, Assembly, string)</TestTarget>
        /// <TestCondition>XMLスキーマの名を示す引数がnullであること。</TestCondition>
        /// <TestAssertion>ArgumentExceptionが返却されること。</TestAssertion>
        /// <TestAssertion>Messageプロパティに適切なメッセージが設定されていること。</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema05()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            Assembly objAsm = GetAssembly();
            string strSchema = null;

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("schema", e.ParamName);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "schema"));
        }

        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema (string, Assembly, string) </TestTarget>
        /// <TestCondition>XMLスキーマの名を示す引数が空文字であること。</TestCondition>
        /// <TestAssertion>ArgumentExceptionが返却されること。</TestAssertion>
        /// <TestAssertion>Messageプロパティに適切なメッセージが設定されていること。</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema06()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            Assembly objAsm = GetAssembly();
            string strSchema = "";

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "schema"), e.Message);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentException), "E_EMPTY_STRING", "schema"));
        }

        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema (string, Assembly, string) </TestTarget>
        /// <TestCondition>XMLスキーマの名を示す引数が空文字であること。</TestCondition>
        /// <TestAssertion>ArgumentExceptionが返却されること。</TestAssertion>
        /// <TestAssertion>Messageプロパティに適切なメッセージが設定されていること。</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema07()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            Assembly objAsm = GetAssembly();
            string strSchema = "test";

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (FileNotFoundException e)
            {
                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_SCHEMAFILE_NOT_FOUND", objAsm, strSchema), e.Message);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(FileNotFoundException), "E_CONFIGURATION_SCHEMAFILE_NOT_FOUND", objAsm.ToString(), strSchema));
        }

        /// <summary>
        ///AddSchema (string, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, string)</TestTarget>
        /// <TestCondition>すべての引数に正しい値を設定すること。</TestCondition>
        /// <TestAssertion>Nullでないインスタンスが返却されること</TestAssertion>
        /// <TestAssertion>XmlSchemaSet型のインスタンスが返却されること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestAddSchema08()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            string strSchemaFilePath = XML_SCHEMA_FILEPATH;

            try
            {
                target.AddSchema(strNameSpace, strSchemaFilePath);
            }
            catch (System.Exception ex)
            {
                Assert.Fail("予期せぬ例外が発生しました。", ex.GetType(), ex.Message);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
        /// <summary>
        ///AddSchema (string, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, string)</TestTarget>
        /// <TestCondition>名前空間を示す引数がnullであること。</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestAddSchema09()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = null;
            string strSchemaFilePath = XML_SCHEMA_FILEPATH;

            try
            {
                target.AddSchema(strNameSpace, strSchemaFilePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("nameSpace", e.ParamName);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "nameSpace"));
        }
        /// <summary>
        ///AddSchema (string, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, string)</TestTarget>
        /// <TestCondition>名前空間を示す引数が空文字であること。</TestCondition>
        /// <TestAssertion>ArgumentExceptionが返却されること。</TestAssertion>
        /// <TestAssertion>Messageプロパティに適切なメッセージが設定されていること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestAddSchema10()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = "";
            string strSchemaFilePath = XML_SCHEMA_FILEPATH;

            try
            {
                target.AddSchema(strNameSpace, strSchemaFilePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "nameSpace"), e.Message);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentException), "E_EMPTY_STRING", "nameSpace"));
        }
        /// <summary>
        ///AddSchema (string, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, string)</TestTarget>
        /// <TestCondition>XMLスキーマのファイルパスを示す引数がnullであること。</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが返却されること。</TestAssertion>
        /// <TestAssertion>XmlSchemaSet型のインスタンスが返却されること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestAddSchema11()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            string strSchemaFilePath = null;

            try
            {
                target.AddSchema(strNameSpace, strSchemaFilePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("schemaFilePath", e.ParamName);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "schemaFilePath"));
        }
        /// <summary>
        ///AddSchema (string, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, string)</TestTarget>
        /// <TestCondition>XMLスキーマのファイルパスを示す引数が空文字であること。</TestCondition>
        /// <TestAssertion>ArgumentExceptionが返却されること。</TestAssertion>
        /// <TestAssertion>Messageプロパティに適切なメッセージが設定されていること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestAddSchema12()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            string strSchemaFilePath = "";

            try
            {
                target.AddSchema(strNameSpace, strSchemaFilePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "schemaFilePath"), e.Message);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentException), "E_EMPTY_STRING", "schemaFilePath"));
        }
        /// <summary>
        ///AddSchema (string string) のテスト
        ///</summary>
        ///<testTarget>AddSchema (string string)</testTarget>
        ///<testPreCondition>すべての引数が正常であること。</testPreCondition>
        ///<testPreCondition>複数のスキーマを追加すること。</testPreCondition>
        ///<testAssertion>例外が発生すること。</testAssertion>
        ///<remarks></remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLFileF.xml")]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema2.xsd")]
        public void TestAddSchema13()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            XmlDocument objXmlDoc = new XmlDocument();
            objXmlDoc.Load("TestItem_XMLFileF.xml");

            try
            {
                target.AddSchema(XML_SCHEMA_NAMESPACE_2, XML_SCHEMA_FILEPATH_2);
                target.AddSchema(XML_SCHEMA_NAMESPACE, XML_SCHEMA_FILEPATH);
                target.Validate(objXmlDoc); //あくまでAssertと同じ位置づけ
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (XmlSchemaException)
            {
                // 成功
            }
            catch (System.Exception ex)
            {
                Assert.Fail("予期せぬ例外が発生しました。", ex.GetType(), ex.Message);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        /// <summary>
        ///Validate (XmlDocument) のテスト
        ///</summary>
        ///<testTarget>Validate (XmlDocument)</testTarget>
        ///<testPreCondition>すべての引数が正常であること。</testPreCondition>
        ///<testAssertion>例外が発生しないこと。</testAssertion>
        ///<remarks></remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLFileS.xml")]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestValidate01()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            XmlDocument objXmlDoc = new XmlDocument();
            objXmlDoc.Load("TestItem_XMLFileS.xml");

            target.AddSchema(XML_SCHEMA_NAMESPACE, XML_SCHEMA_FILEPATH);
            target.Validate(objXmlDoc);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
        /// <summary>
        ///Validate (XmlDocument) のテスト
        ///</summary>
        ///<testTarget>Validate (XmlDocument)</testTarget>
        ///<testPreCondition>XMLドキュメントを示す引数がnullであること。</testPreCondition>
        ///<testAssertion>ArgumentNullExceptionがスローされること。</testAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestValidate02()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            XmlDocument objXmlDoc = null;

            try
            {
                target.Validate(objXmlDoc);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("xmlDoc", e.ParamName);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "xmlDoc"));
        }
        /// <summary>
        ///Validate (XmlDocument) のテスト
        ///</summary>
        ///<testTarget>Validate (XmlDocument)</testTarget>
        ///<testPreCondition>XMLドキュメントがスキーマ定義に反していること。</testPreCondition>
        ///<testAssertion>XmlSchemaExceptionが発生すること。</testAssertion>
        ///<testAssertion>適切なエラーメッセージが設定されること。</testAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLFileF.xml")]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestValidate03()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            XmlDocument objXmlDoc = new XmlDocument();
            objXmlDoc.Load("TestItem_XMLFileF.xml");

            try
            {
                target.AddSchema(XML_SCHEMA_NAMESPACE, XML_SCHEMA_FILEPATH);
                target.Validate(objXmlDoc);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (XmlSchemaException)
            {
                // 成功
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
        /// <summary>
        ///Validate (XmlDocument) のテスト
        ///</summary>
        ///<testTarget>Validate (XmlDocument)</testTarget>
        ///<testPreCondition>XMLスキーマセットが空であること</testPreCondition>
        ///<testAssertion>InvalidOperationExceptionが発生すること。</testAssertion>
        ///<testAssertion>適切なエラーメッセージが設定されること。</testAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLFileF.xml")]
        public void TestValidate04()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            XmlDocument objXmlDoc = new XmlDocument();
            objXmlDoc.Load("TestItem_XMLFileF.xml");

            try
            {
                target.Validate(objXmlDoc);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidOperationException e)
            {
                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_XMLSCHEMASET_NOT_FOUND"), e.Message);
            }
            catch (System.Exception ex)
            {
                Assert.IsNotNull(ex);
                Assert.Fail("到達してはいけないコードです。");
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(XmlDocumentValidator), typeof(InvalidOperationException), "E_CONFIGURATION_XMLSCHEMASET_NOT_FOUND"));
        }

        /// <summary>
        ///GetMessage (XmlSeverityType, string) のテスト
        ///</summary>
        ///<testTarget>GetMessage</testTarget>
        ///<testCondition>検証エラーが発生すること。</testCondition>
        ///<testAssertion>適切なエラーメッセージが返却されること。</testAssertion>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void TestGetMessage01()
        {
            XmlSeverityType objSeverityType = XmlSeverityType.Error;
            string strMessage = "test!";

            string expected = @"XMLスキーマ検証エラー : test!";
            string actual;

            actual = TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_XmlDocumentValidatorAccessor.GetMessage(objSeverityType, strMessage);
            Assert.AreEqual(expected, actual, "TERASOLUNA.Fw.Common.XmlDocumentValidator.GetMessage は予期する値を返しませんでした。");

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
        /// <summary>
        ///GetMessage (XmlSeverityType, string) のテスト
        ///</summary>
        ///<testTarget>GetMessage</testTarget>
        ///<testCondition>検証警告が発生すること。</testCondition>
        ///<testAssertion>適切な警告ーメッセージが返却されること。</testAssertion>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void TestGetMessage02()
        {
            XmlSeverityType objSeverityType = XmlSeverityType.Warning;
            string strMessage = "test!";

            //string expected = @"XMLスキーマ検証警告 : "test!"\r\n";
            string expected = MessageManager.GetMessage("W_CONFIGURATION_XMLSEVERITYTYPE_WARNING", strMessage);
            string actual;

            actual = TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_XmlDocumentValidatorAccessor.GetMessage(objSeverityType, strMessage);
            Assert.AreEqual(expected, actual, "TERASOLUNA.Fw.Common.XmlDocumentValidator.GetMessage は予期する値を返しませんでした。");
            
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
        /// <summary>
        ///GetMessage (XmlSeverityType, string) のテスト
        ///</summary>
        ///<testTarget>GetMessage</testTarget>
        ///<testCondition>対応していない検証イベント重大度を設定すること。</testCondition>
        ///<testAssertion>適切なメッセージが返却されること。</testAssertion>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void TestGetMessage03()
        {
            XmlSeverityType objSeverityType = (XmlSeverityType)3;
            string strMessage = "test!";

            string expected = "サポートしていない重大度レベルの検証エラーが発生しました。";
            string actual;

            actual = TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_XmlDocumentValidatorAccessor.GetMessage(objSeverityType, strMessage);
            Assert.AreEqual(expected, actual, "TERASOLUNA.Fw.Common.XmlDocumentValidator.GetMessage は予期する値を返しませんでした。");

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        private Assembly GetAssembly()
        {
            Assembly objTestAsm = Assembly.GetExecutingAssembly();
            Assembly objAsm = Assembly.LoadFile(objTestAsm.Location.Replace("TERASOLUNA.Fw.CommonUT.dll", XML_SCHEMA_DLLNAME));
            return objAsm;
        }

        /// <summary>
        ///GetMessage (XmlSeverityType, string) のテスト
        ///</summary>
        ///<testTarget>GetMessage</testTarget>
        ///<testCondition>strMessageがnullであること。</testCondition>
        ///<testAssertion>例外がスローされないこと。</testAssertion>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void TestGetMessage04()
        {
            XmlSeverityType objSeverityType = XmlSeverityType.Error;
            string strMessage = null;

            string actual;

            actual = TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_XmlDocumentValidatorAccessor.GetMessage(objSeverityType, strMessage);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        /// <summary>
        ///GetMessage (XmlSeverityType, string) のテスト
        ///</summary>
        ///<testTarget>GetMessage</testTarget>
        ///<testCondition>strMessageが空文字であること。</testCondition>
        ///<testAssertion>例外がスローされないこと。</testAssertion>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void TestGetMessage05()
        {
            XmlSeverityType objSeverityType = XmlSeverityType.Error;
            string strMessage = "";

            string actual;

            actual = TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_XmlDocumentValidatorAccessor.GetMessage(objSeverityType, strMessage);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, Assembly, string)</TestTarget>
        /// <TestCondition>名前空間を示す引数が間違っている場合。</TestCondition>
        /// <TestAssertion>XmlSchemaExceptionがスローされること。</TestAssertion>
        ///<remarks>
        /// XMLSchemaTest1.dllはTestXMLSchemaFile1.xsdを埋め込んだDLLです。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchemaTest1.dll")]
        public void TestAddSchema14()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = "hoge.xsd";
            Assembly objAsm = GetAssembly();
            string strSchema = XML_SCHEMA_ASPPATH;

            try
            {
                target.AddSchema(strNameSpace, objAsm, strSchema);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (XmlSchemaException)
            {
                // 成功
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        /// <summary>
        ///AddSchema (string, Assembly, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, Assembly, string)</TestTarget>
        /// <TestCondition>アセンブリの指定が間違っている場合、スキーマ名を元にアセンブリを探す。</TestCondition>
        /// <TestAssertion>例外がスローされないこと。</TestAssertion>
        ///<remarks>
        /// 
        ///</remarks>
        [TestMethod()]
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        public void TestAddSchema15()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            Assembly objTestAsm = Assembly.GetExecutingAssembly();
            Assembly objAsm = Assembly.LoadFile(objTestAsm.Location.Replace("TERASOLUNA.Fw.WebUT.dll", "TERASOLUNA.Fw.Web.dll"));
            string strSchema = XML_SCHEMA_ASPPATH;

            target.AddSchema(strNameSpace, objAsm, strSchema);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        /// <summary>
        ///AddSchema (string, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, string)</TestTarget>
        /// <TestCondition>名前空間を示す引数が間違っている場合。</TestCondition>
        /// <TestAssertion>XmlSchemaExceptionがスローされること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestAddSchema16()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = "hoge.xsd";
            string strSchemaFilePath = XML_SCHEMA_FILEPATH;

            try
            {
                target.AddSchema(strNameSpace, strSchemaFilePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (XmlSchemaException)
            {
                // 成功
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        /// <summary>
        ///AddSchema (string, string) のテスト
        ///</summary>
        /// <TestTarget>AddSchema(string, string)</TestTarget>
        /// <TestCondition>すべての引数に正しい値を設定すること。</TestCondition>
        /// <TestCondition>スキーマファイルを示す引数が間違っている場合。</TestCondition>
        /// <TestAssertion>FileNotFoundExceptionがスローされること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_XMLSchema1.xsd")]
        public void TestAddSchema17()
        {
            XmlDocumentValidator target = new XmlDocumentValidator();

            string strNameSpace = XML_SCHEMA_NAMESPACE;
            string strSchemaFilePath = "hoge.xsd";

            try
            {
                target.AddSchema(strNameSpace, strSchemaFilePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (System.IO.FileNotFoundException)
            {
                // 成功
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }

        /// <summary>
        ///GetMessage (XmlSeverityType, string) のテスト
        ///</summary>
        ///<testTarget>GetMessage</testTarget>
        ///<testCondition> 引数severityTypeにNullを指定する場合</testCondition>
        ///<testAssertion>適例外がスローされないこと</testAssertion>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void TestGetMessage06()
        {
            XmlSeverityType objSeverityType = new XmlSeverityType();
            string strMessage = "test!";

            string actual;

            actual = TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_XmlDocumentValidatorAccessor.GetMessage(objSeverityType, strMessage);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(XmlDocumentValidator), LogLevel.INFO));
        }
    }
}
