// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

﻿using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Client;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    /// <summary>
    /// Coordinator 単体試験用の IBLogic 実装クラスです。
    /// </summary>
    /// <remarks>
    /// 正常系のテスト用。
    /// IProgressChangedEventInvoker を実装している。
    /// </remarks>
    public class Coordinator_IBLogicImpl02 : IBLogic, IProgressChangedEventInvoker
    {
        private bool _isCalledExecute = false;
        private BLogicParam _executeBLogicParam = null;

        public event ExecuteProgressChangedEventHandler ProgressChanged;

        public bool IsCalledExecute
        {
            get { return _isCalledExecute; }
        }

        public BLogicParam ExecuteBLogicParam
        {
            get { return _executeBLogicParam; }
        }

        public BLogicResult Execute(BLogicParam param)
        {
            _isCalledExecute = true;
            _executeBLogicParam = param;
            BLogicResult result = new BLogicResult();
            result.ResultString = BLogicResult.SUCCESS;
            result.ResultData = new Coordinator_DataSetStub04();

            return result;
        }

        public bool IsNotNullProgressChanged
        {
            get { return (ProgressChanged != null); }
        }
    }
}
