﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;
using System.Data;

namespace TERASOLUNA.Fw.Client.Configuration.Conversion
{
    /// <summary>
    /// データセット変換設定ファイル内の result 要素を表します。
    /// </summary>
    /// <remarks>
    /// <see cref="TERASOLUNA.Fw.Client.Conversion.IConverter.Reverse">IConverter.Reverse</see>
    /// で利用されるデータセット変換情報を定義する要素です。
    /// result 要素は、以下の子要素を含みます。
    /// <list type="table">
    /// <listheader>
    /// <description>子要素</description>
    /// <description>説明</description>
    /// </listheader>
    /// <item>
    /// <description>clear-view</description>
    /// <description>
    /// 省略可能な要素です。<see cref="DataRow"/> をクリアする <see cref="DataTable"/> を指定します。
    /// </description>
    /// </item>
    /// <item>
    /// <description>column</description>
    /// <description>
    /// 省略可能な要素です。値を持つ既存 <see cref="DataSet"/> への変換情報を指定します（<see cref="ColumnElement"/> を参照）。
    /// </description>
    /// </item>
    /// </list>
    /// </remarks>
    public sealed class ResultElement : ConfigurationElement
    {

        /// <summary>
        /// clear-view 要素コレクションを表す名前です。
        /// </summary>
        /// <remarks>
        /// この定数の値は "clear-views" です。
        /// </remarks>
        private const string ELEMENT_NAME_CLEAR_VIEWS = "clear-views";
        
        /// <summary>
        /// column 要素コレクションを表す名前です。
        /// </summary>
        /// <remarks>
        /// この定数の値は "columns" です。
        /// </remarks>
        private const string ELEMENT_NAME_COLUMNS = "columns";
        
        /// <summary>
        /// <see cref="ResultElement"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public ResultElement()
        {
        }

        /// <summary>
        /// <see cref="ResultElement"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// clear-view 要素と column 要素のコレクションを初期化します。
        /// </remarks>
        /// <param name="clearViews">clear-view 要素のコレクション。</param>
        /// <param name="columns">column 要素のコレクション。</param>
        public ResultElement(ClearViewCollection clearViews, ColumnCollection columns)
        {
            this[ELEMENT_NAME_CLEAR_VIEWS] = clearViews;
            this[ELEMENT_NAME_COLUMNS] = columns;
        }

        /// <summary>
        /// clear-view 要素のコレクションを取得します。
        /// </summary>
        /// <value>
        /// clear-view 要素のコレクション。
        /// </value>
        [ConfigurationProperty(ELEMENT_NAME_CLEAR_VIEWS)]
        public ClearViewCollection ClearViews
        {
            get
            {
                return (ClearViewCollection)this[ELEMENT_NAME_CLEAR_VIEWS];
            }
        }

        /// <summary>
        /// column 要素のコレクションを取得します。
        /// </summary>
        /// <value>
        /// column 要素のコレクション。
        /// </value>
        [ConfigurationProperty(ELEMENT_NAME_COLUMNS)]
        public ColumnCollection Columns
        {
            get
            {
                return (ColumnCollection)this[ELEMENT_NAME_COLUMNS];
            }
        }
    }
}