// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Net;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// f[^M@\񋟂C^[tFCXłB
    /// </summary>
    public interface IHttpReceiver
    {
        /// <summary>
        /// <paramref name="request"/> œnꂽ <see cref="HttpWebRequest"/> pĎM
        /// f[^͂Aʂ <see cref="CommunicationResult"/> Ɋi[ĕԂ܂B
        /// </summary>
        /// <remarks>
        /// <see cref="IHttpReceiver.Receive"/> ہAʐM̗O <see cref="WebException"/> 
        /// ăX[AȊO̗OɂĂ <see cref="CommunicationException"/> ƂăX[悤ɂ܂B
        /// </remarks>
        /// <param name="request">
        /// MsNGXgIuWFNgB
        /// </param>
        /// <param name="reporter">
        /// is󋵒ʒms <see cref="IProgressChangeReporter"/> NX̃CX^XB
        /// </param>
        /// <returns>Mʂi[ <see cref="CommunicationResult"/>B</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="request"/>  null QƂłB
        /// </exception>
        /// <exception cref="WebException">
        /// T[oƂ̒ʐMɃG[܂B܂͒ʐMLZ܂B
        /// </exception>
        /// <exception cref="ServerException">
        /// ʐM̃T[oŃG[܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// MɓŃG[܂B
        /// </exception>
        CommunicationResult Receive(HttpWebRequest request,
                                    IProgressChangeReporter reporter);
    }

}
