/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobRequestInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * WuNpNXB</p>
 * 
 * <p>̃NX <code>main()</code> \bhŃWuN邱ƂłB</p>
 * 
 * <p>̃NXŃWuNۂɂ́AȉŎw肷B</p>
 *
 * <ul>
 * <li>PFWu<code>ID</code>iK{j</li>
 *   <p>sΏۃWuӂɎʂWuIDw肷B</p>
 * <li>QFWuBean`t@C̑΃pXiK{j</li>
 *   <p>sΏۃWȕ񂪐ݒ肳ĂWu<code>Bean</code>
 *   `t@C̑΃pXB</p>
 *   <p>WuBean`t@C̓NX[_œǂݍ܂邽߁ANXpXƂ
 *   w肷B
 *   <p>Ƃ΁AubatchappsvƂtH_zɃWuBean`t@Cu
 *   ĂāAubatchappsv̑΃pXw肷B</p>
 *   <p>w̃WuBean`t@C݂Ȃꍇ̓G[ƂďIB</p>
 * <li>Rȍ~Fp[^l<td>iCӁj</li>
 *   <p>w肳ꂽl̓Wuݒ莞Ɏw肵WuReLXgɊi[B</p>
 *   <p>̑OɁu-pvw肷邱ƂŋNWũWuvZXIDw肷
 *   ƂłB</p>
 * </ul>
 * 
 * <p>N</p>
 * <code>java jp.terasoluna....JobStarter 
 * JOB0001 UD001/JOB0001.xml PARM01 PARM02 PARM03 PARM04 -p POS0001</code>
 *
 * <p>WuReLXg<p>
 * <pre><code>public class SampleJobParameter extends JobContext {
 *     private String company = null;
 *     private Date startDay = null;
 *     private Date endDay = null;
 *     private List&lt;String&gt; fileData = null;
 *     public void setParameter(String[] arg) {
 *         company = arg[0];
 *         startDay = DateFormat.getTimeInstance().parse(arg[1]);
 *         endDay = DateFormat.getTimeInstance().parse(arg[2]);
 *         Properties p = new Properties();
 *         FileInputStream fis = new FileInputStream(fileName);
 *         p.load(fis);
 *     }
 *     
 *     public String getCompany(){
 *         return company;
 *     }
 *     public Date getStartDay(){
 *            return startDay;
 *     }
 *     public Date getEndDay(){
 *         return endDay;
 *     }
 *     public List&lt;String&gt; getFileData(){
 *         return fileData;
 *     }
 *}</code></pre>
 * </ul>
 *
 */
public class JobStarter {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(JobStarter.class);
    
    /**
     * WuNpMain\bhB
     *
     * @param args 
     *            N̈<BR>
     *            PFWuID<BR>
     *            QFWuBean`t@C̑΃pX<BR>
     *            Rȍ~FWuReLXgi[p<BR>
     *            -pȍ~̈̓WuvZXID<BR>
     * @throws Throwable Throwable
     */
    public static void main(String[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("START Batch");
        }
        JobStarter jobStarter = new JobStarter();
        int exitCode = jobStarter.execute(args);

        if (log.isDebugEnabled()) {
            log.debug("END Batch");
        }
        System.exit(exitCode);
    }


    /**
     * Ŏw肳ꂽp[^ɃWusB
     *
     * @param args 
     *            N̈<BR>
     *            PFWuID<BR>
     *            QFWuBean`t@C̑΃pX<BR>
     *            Rȍ~FWuReLXgi[p<BR>
     *            -pȍ~̈̓WuvZXID<BR>
     * @return WuIR[h
     * @throws Throwable Throwable
     */
    protected int execute(String[] args) throws Throwable {
        int exitCode = 0;

        JobExecutor jobExecutor = new JobExecutor();

        JobStatus jobStatus = null;
        try {
            JobRequestInfo jobInfo = new JobRequestInfo(args);
            jobInfo.init();

            jobStatus = jobExecutor.execute(jobInfo);

            exitCode = jobStatus.getJobExitCode();
        } catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! ");
            logStr.append(throwable.getMessage());
            log.error(logStr.toString(), throwable);
            throw throwable;
        } finally {
            try {
                jobExecutor.destroy();
            } catch (Throwable throwable) {
                StringBuilder logStr = new StringBuilder();
                logStr.append("Critical Error!! ");
                logStr.append(throwable.getMessage());
                log.error(logStr.toString(), throwable);
                throw throwable;
            }
        }
        return exitCode;
    }
}
