/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.tutorial.uc0001.jb0002;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.batch.tutorial.uc0001.JB0002Data;
import jp.terasoluna.batch.tutorial.uc0001.JB0002JobContext;
import jp.terasoluna.fw.batch.messages.MessageAccessor;
import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.file.dao.FileLineWriter;

/**
 * rWlXWbNNXB
 */
public class FileBLogic implements BLogic<JB0002Data, JB0002JobContext> {


    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(FileBLogic.class);
    
    /**
     * bZ[W擾NXB
     * SpringɂCX^Xݒ肳B
     */
    private MessageAccessor messageAccessor = null;
 
  
    /**
     * t@Co͗psC^NXB
     * SpringɂCX^Xݒ肳B
     */
    private FileLineWriter<JB0002Data> fileLineWriter = null;
    
    /**
     * rWlXWbNsB
     * @param nyukinData ̓p[^
     * @param jobContext WuReLXg
     */
    public BLogicResult execute(JB0002Data nyukinData, JB0002JobContext jobContext) {

        //Ɖ^pt̔r
        Date torihikibi = nyukinData.getTorihikibi();
        Date unyohiduke = jobContext.getUnyohiduke();
    
        if (!torihikibi.before(unyohiduke)) {
            
            // >= ^pt Ȃ΃bZ[W擾Oɏo͂B
            String[] args = {nyukinData.getKokyakuid() };
            String message = messageAccessor.getMessage("msg.SampleMsg", args);
            
            log.warn(message);
        }
    
    
        //z10,000ȏ̃f[^t@Cɏo
        int nyukin = nyukinData.getNyukin();
        if (nyukin >= 10000) {
            //t@C֏
            fileLineWriter.printDataLine(nyukinData);
        
            //JEgAbv
            jobContext.incrementCount();
        }
        
        //rWlXWbNʃIuWFNgԋp
        BLogicResult result = new BLogicResult(ReturnCode.NORMAL_CONTINUE);
        return result;
    }
    
    /**
     * bZ[W擾NXݒ肷B
     * @param msgAcc bZ[W擾NX
     */
    public void setMessageAccessor(MessageAccessor msgAcc) {
        this.messageAccessor = msgAcc;
    }
    
    /**
     * t@Co͗psC^NXݒ肷B
     * @param fileLineWriter t@Co͗psC^NX
     */
    public void setFileLineWriter(FileLineWriter<JB0002Data> fileLineWriter){
        this.fileLineWriter = fileLineWriter;
    }
}
