/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * 
 * PropertyUtil ubN{bNXeXgB<br>
 *
 * (O)<br>
 *@EvpeBt@CɈȉ̂悤ȐݒĂ<br>
 *         property.test001.id.0 = test<br>
 *         property.test002.id.0 = test0<br>
 *         property.test002.id.1 = test1<br>
 *         property.test002.id.2 = test2<br>
 *         property.test003.id.0 =<br>
 *         property.test004.id.0 = testA<br>
 *         property.test004.id.0 = testB<br>
 *         property.test004.id.1 = testA<br>
 *         fileutiltest.dir.base = /tmp/test<br>
 *         codelist.gengo1.define.1 = ]<br>
 *         codelist.gengo1.define.2 = <br>
 *         codelist.gengo1.define.3 = 吳<br>
 *         codelist.gengo2.define.1 = a<br>
 *         codelist.gengo2.define.2 = <br>
 *         codelist.sql1.sql.0=select values01,values01,values01 from table_kamoTest where Key1 between ? and ?<br>
 *         @property.test0 = testtest<br>
 *         property.test100.id.0 = @property.test100.id.0<br>
 *         property.test005 = @property.test001.id.0<br>
 *         property.test007.id.0=@@test007<br>
 *         property.test008.id.0=@@<br>
 *         property.test009.id.0=@<br>
 * 
 */
@SuppressWarnings("unused")
public class PropertyUtilTest extends PropertyTestCase {

    /**
     * Constructor for PropertyUtilTest.
     * @param arg0
     */
    public PropertyUtilTest(String arg0) {
        super(arg0);
    }

    @Override
    protected void setUpData() throws Exception {
        addProperty("system.name", "SAMPLE1");
        addProperty("fileutiltest.dir.base", "/tmp/test");
        addProperty("property.test001.id.0", "test");
        addProperty("property.test002.id.0", "test0");
        addProperty("property.test002.id.1", "test1");
        addProperty("property.test002.id.2", "test2");
        addProperty("property.test003.id.0", "");
        addProperty("property.test004.id.0", "testA");
        addProperty("property.test004.id.0", "testB");
        addProperty("@property.test0", "testtest");
        addProperty("property.test100.id.0", "@property.test100.id.0");
        addProperty("property.test005", "@property.test001.id.0");
        addProperty("property.test006.id.0", "testA");
        addProperty("property.test007.id.0", "@@test007");
        addProperty("property.test008.id.0", "@@");
        addProperty("property.test009.id.0", "@");
        addProperty("codelist.gengo1.define.1", "]");
        addProperty("codelist.gengo1.define.2", "");
        addProperty("codelist.gengo1.define.3", "吳");
        addProperty("codelist.gengo2.define.1", "a");
        addProperty("codelist.gengo2.define.2", "");
        addProperty("codelist.sql1.sql.0", "select values01,values01,values01 from table_kamoTest where Key1 between ? and ?");
    }

    @Override
    protected void cleanUpData() throws Exception {
        clearProperty();
    }

    /**
     * testAddPropertyFile01()B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lF݂vpeBt@C(.propertiesȂ)<br>
     * ҒlFPropertyUtilNXfilestB[hɃt@C܂܂Ă邱<br>
     * @throws Exception O */
    public void testAddPropertyFile01() throws Exception {
        // ͒l̐ݒ
        String input = "system";

        // eXgΏۂ̎s
        PropertyUtil.addPropertyFile(input);

        // ʊmF
        // PropertyUtilNXfilestB[hɃt@C܂܂Ă邱
        Set st = (Set) UTUtil.getPrivateField(PropertyUtil.class, "files");
        assertTrue(st.contains("system.properties"));
    }

    /**
     * testAddPropertyFile02()B<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lF݂vpeBt@C(.properties)<br>
     * ҒlFPropertyUtilNXfilestB[hɃt@C܂܂Ă邱<br>
     * @throws Exception O */
    public void testAddPropertyFile02() throws Exception {
        // ͒l̐ݒ
        String input = "system.properties";

        // eXgΏۂ̎s
        PropertyUtil.addPropertyFile(input);

        // ʊmF
        // PropertyUtilNXfilestB[hɃt@C܂܂Ă邱
        Set st = (Set) UTUtil.getPrivateField(PropertyUtil.class, "files");
        assertTrue(st.contains("system.properties"));
    }

    /**
     * testAddPropertyFile03()B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lF݂ȂvpeBt@C<br>
     * ҒlFPropertyUtilNXfilestB[hɃt@C܂܂ĂȂ<br>
     * @throws Exception O */
    public void testAddPropertyFile03() throws Exception {
        // ͒l̐ݒ
        String input = "xxxxx";

        // eXgΏۂ̎s
        PropertyUtil.addPropertyFile(input);

        // ʂ̊mF
        // PropertyUtilNXfilestB[hɃt@C܂܂ĂȂ
        Set st = (Set) UTUtil.getPrivateField(PropertyUtil.class, "files");
        assertFalse(st.contains("xxxxx.properties"));
    }

    /**
     * testAddPropertyFile04()B<br>
     * 
     * (n)<br>
     * ϓ_FC,G<br>
     * 
     * ͒lFnull<br>
     * ҒlFNullPointerException<br>
     * @throws Exception O */
    public void testAddPropertyFile04() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgΏۂ̎s
        try {
            PropertyUtil.addPropertyFile(input);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * testAddPropertyFile05()B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lF""(󕶎)<br>
     * ҒlF<br>
     * @throws Exception O */
    public void testAddPropertyFile05() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgΏۂ̎s
        PropertyUtil.addPropertyFile(input);

        // ʂ̊mF
        // PropertyUtilNXfilestB[hɃt@C܂܂ĂȂ
        Set st = (Set) UTUtil.getPrivateField(PropertyUtil.class, "files");
        assertFalse(st.contains(".properties"));
    }

    /**
     * testAddPropertyFile06()B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lF݂vpeBt@CAǂݍ<br>
     * ҒlFxǂݍ܂ȂƂ<br>
     * @throws Exception O */
    public void testAddPropertyFile06() throws Exception {
        // ͒l̐ݒ
        String input = "system";

        // eXgΏۂ̎s
        PropertyUtil.addPropertyFile(input);
        PropertyUtil.addPropertyFile(input);
        // ʊmF
        // PropertyUtilNXfilestB[hɃt@C܂܂Ă邱
        Set st = (Set) UTUtil.getPrivateField(PropertyUtil.class, "files");
        assertTrue(st.contains("system.properties"));
        assertTrue(st.size() == 1);
    }

    /**
     * testGetProperty01(String)B<br> 
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lF݂L[<br>
     * ҒlFL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyString01() throws Exception {
        // ͒l̐ݒ
        String input = "property.test001.id.0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("test", str);
    }

    /**
     * testGetProperty02(String)B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lF݂ȂL[<br>
     * ҒlFNulll<br>
     * @throws Exception O */
    public void testGetPropertyString02() throws Exception {
        // ͒l̐ݒ
        String input = "property.test001.id.1";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertNull(str);
    }

    /**
     * testGetProperty03(String) B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒lFnull<br>
     * ҒlFNullPointerException<br>
     * @throws Exception O */
    public void testGetPropertyString03() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgΏۂ̎s
        try {
            String str = PropertyUtil.getProperty(input);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * testGetProperty04(String)B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lF""(󕶎)<br>
     * ҒlFNulll<br>
     * @throws Exception O */
    public void testGetPropertyString04() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertNull(str);
    }

    /**
     * testGetProperty05(String) B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFvpeBl󕶎̃L[<br>
     * ҒlF󕶎<br>
     * @throws Exception O */
    public void testGetPropertyString05() throws Exception {
        // ͒l̐ݒ
        String input = "property.test003.id.0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testGetProperty06(String)B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lF݂L[<br>
     * ҒlFɐݒ肳ꂽL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyString06() throws Exception {
        // ͒l̐ݒ
        String input = "property.test004.id.0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("testB", str);
    }

    /**
     * testGetProperty07(String) B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lF<code>@key</code><br>
     * ҒlFɐݒ肳ꂽL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyString07() throws Exception {
        // ͒l̐ݒ
        String input = "@property.test0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("testtest", str);
    }

    /**
     * testGetProperty08(String)B<br> 
     * 
     * (n)<br>
     * ϓ_FA,F<br>
     * 
     * ͒lF<code>key=@key</code><br>
     * ҒlFɐݒ肳ꂽL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyString08() throws Exception {
        // ͒l̐ݒ
        String input = "property.test100.id.0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("@property.test100.id.0", str);
    }

    /**
     * testGetProperty09(String)B<br> 
     * 
     * (n)<br>
     * ϓ_FA,F<br>
     * 
     * ͒lF<code>key=@value</code><br>
     * ҒlF<code>@</code>OvpeBl<br>
     * @throws Exception O */
    public void testGetPropertyString09() throws Exception {
        // ͒l̐ݒ
        String input = "property.test005";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("test", str);
    }

    /**
     * testGetProperty10(String)B<br> 
     * 
     * (n)<br>
     * ϓ_FA,F<br>
     * 
     * ͒lF<code>key=@@value</code><br>
     * ҒlF@value<br>
     * property.test007.id.0=@@test007ƃvpeBt@Cɐݒ肵A
     * @test007邱ƂmFB
     * @throws Exception O */
    public void testGetPropertyString10() throws Exception {
        // ͒l̐ݒ
        String input = "property.test007.id.0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("@test007", str);
    }
    
    /**
     * testGetProperty12(String)B<br> 
     * 
     * (n)<br>
     * ϓ_FA,F<br>
     * 
     * ͒lF<code>key=@@</code><br>
     * ҒlF@<br>
     * property.test008.id.0=@@ƃvpeBt@Cɐݒ肵A
     * @邱ƂmFB
     * @throws Exception O */
    public void testGetPropertyString11() throws Exception {
        // ͒l̐ݒ
        String input = "property.test008.id.0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertEquals("@", str);
    }
    
    /**
     * testGetProperty13(String)B<br> 
     * 
     * (n)<br>
     * ϓ_FA,F<br>
     * 
     * ͒lF<code>key=@</code><br>
     * ҒlF@<br>
     * property.test009.id.0=@ƃvpeBt@Cɐݒ肵A
     * NullԂė邱ƂmFB
     * @throws Exception O */
    public void testGetPropertyString12() throws Exception {
        // ͒l̐ݒ
        String input = "property.test009.id.0";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input);

        // ʊmF
        assertNull(str);
    }
    
    /**
     * testGetProperty01(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lFkey=݂L[<br>
     * @@@@default=ftHgl<br>
     * ҒlFL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyStringString01() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test001.id.0";
        String input2 = "default";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("test", str);
    }

    /**
     * testGetProperty02(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lFkey=݂ȂL[<br>
     * @@@@default=ftHgl<br>
     * ҒlFftHgl<br>
     * @throws Exception O */
    public void testGetPropertyStringString02() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test001.id.1";
        String input2 = "default";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("default", str);
    }

    /**
     * testGetProperty03(String, String)B<br>
     * 
     * (ُn)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=null<br>
     * @@@@default=ftHgl<br>
     * ҒlFNullPointerException<br>
     * @throws Exception O */
    public void testGetPropertyStringString03() throws Exception {
        // ͒l̐ݒ
        String input1 = null;
        String input2 = "default";

        // eXgΏۂ̎s
        try {
            String str = PropertyUtil.getProperty(input1, input2);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * testGetProperty04(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=݂L[<br>
     * @@@@default=null<br>
     * ҒlFL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyStringString04() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test001.id.0";
        String input2 = null;

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("test", str);
    }

    /**
     * testGetProperty05(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lFkey=݂ȂL[<br>
     * @@@@default=null<br>
     * ҒlFnull(ftHg)<br>
     * @throws Exception O */
    public void testGetPropertyStringString05() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test001.id.1";
        String input2 = null;

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertNull(str);
    }

    /**
     * testGetProperty06(String, String) B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=""(󕶎)<br>
     * @@@@default=ftHgl<br>
     * ҒlFftHgl<br>
     * @throws Exception O */
    public void testGetPropertyStringString06() throws Exception {
        // ͒l̐ݒ
        String input1 = "";
        String input2 = "default";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("default", str);
    }

    /**
     * testGetProperty07(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=݂L[<br>
     * @@@@default=""(󕶎)<br>
     * ҒlFL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyStringString07() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test001.id.0";
        String input2 = "";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("test", str);
    }

    /**
     * testGetProperty08(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=݂ȂL[<br>
     * @@@@default=""(󕶎)<br>
     * ҒlF""(ftHg)<br>
     * @throws Exception O */
    public void testGetPropertyStringString08() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test001.id.1";
        String input2 = "";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testGetProperty09(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=vpeBl""(󕶎)̃L[<br>
     * @@@@default=ftHgl<br>
     * ҒlF󕶎<br>
     * @throws Exception O */
    public void testGetPropertyStringString09() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test003.id.0";
        String input2 = "default";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testGetProperty10(String, String)B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lFkey=݂L[<br>
     * @@@@default=ftHgl<br>
     * ҒlFL[̃vpeBl<br>
     * @throws Exception O */
    public void testGetPropertyStringString10() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test004.id.0";
        String input2 = "default";

        // eXgΏۂ̎s
        String str = PropertyUtil.getProperty(input1, input2);

        // ʊmF
        assertEquals("testB", str);
    }

    /**
     * testGetPropertyNames01()B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lFȂ<br>
     * ҒlFׂẴL[<br>
     * @throws Exception O */
    public void testGetPropertyNames01() throws Exception {
        // eXgΏۂ̎s
        Enumeration en = PropertyUtil.getPropertyNames();

        // ʂ̊mF
        // EnumerationvfoAVectorzɒǉ
        Vector<String> v = new Vector<String>();
        while (en.hasMoreElements()) {
            String key = (String) en.nextElement();
            v.add(key);
        }
        // L[̑݊mF
        assertTrue(v.contains("system.name"));
        assertTrue(v.contains("property.test001.id.0"));
        assertTrue(v.contains("property.test002.id.0"));
        assertTrue(v.contains("property.test002.id.1"));
        assertTrue(v.contains("property.test002.id.2"));
        assertTrue(v.contains("property.test003.id.0"));
        assertTrue(v.contains("property.test004.id.0"));
        assertTrue(v.contains("property.test004.id.0"));
        assertTrue(v.contains("@property.test0"));
        assertTrue(v.contains("fileutiltest.dir.base"));
        assertTrue(v.contains("property.test100.id.0"));
        assertTrue(v.contains("property.test005"));
        assertTrue(v.contains("property.test006.id.0"));
        assertTrue(v.contains("property.test007.id.0"));
        assertTrue(v.contains("property.test008.id.0"));
        assertTrue(v.contains("property.test009.id.0"));
        assertTrue(v.contains("codelist.gengo1.define.1"));
        assertTrue(v.contains("codelist.gengo1.define.2"));
        assertTrue(v.contains("codelist.gengo1.define.3"));
        assertTrue(v.contains("codelist.gengo2.define.1"));
        assertTrue(v.contains("codelist.gengo2.define.2"));
        assertTrue(v.contains("codelist.sql1.sql.0"));
    }

    /**
     * testGetPropertyNames01(String) B<br>
     *  
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lFkey=݂vtBbNX<br>
     * ҒlFL[Xg(1)<br>
     * @throws Exception O */
    public void testGetPropertyNamesString01() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test001.id";

        // eXgΏۂ̎s
        Enumeration enume = PropertyUtil.getPropertyNames(input1);

        // ʊmF
        assertEquals("property.test001.id.0", enume.nextElement());
        assertFalse(enume.hasMoreElements());
    }

    /**
     * testGetPropertyNames02(String)B<br>
     *  
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=݂ȂvtBbNX<br>
     * ҒlFL[Xg(0)<br>
     * @throws Exception O */
    public void testGetPropertyNamesString02() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test999.id";

        // eXgΏۂ̎s
        Enumeration enume = PropertyUtil.getPropertyNames(input1);

        // ʊmF
        assertFalse(enume.hasMoreElements());
    }

    /**
     * testGetPropertyNames03(String)B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lFkey=݂vtBbNX<br>
     * ҒlFL[Xg(3)<br>
     * @throws Exception O */
    public void testGetPropertyNamesString03() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test002.id";

        // eXgΏۂ̎s
        Enumeration enume = PropertyUtil.getPropertyNames(input1);

        // ʊmF
        assertEquals("property.test002.id.0", enume.nextElement());
        assertEquals("property.test002.id.1", enume.nextElement());
        assertEquals("property.test002.id.2", enume.nextElement());
        assertFalse(enume.hasMoreElements());
    }

    /**
     * testGetPropertyNames04(String) B<br>
     * 
     * (ُn)<br>
     * ϓ_FC,G<br>
     * 
     * ͒lFkey=null<br>
     * ҒlFNullPointerException<br>
     * @throws Exception O */
    public void testGetPropertyNamesString04() throws Exception {
        // ͒l̐ݒ
        String input1 = null;

        // eXgΏۂ̎s
        try {
            Enumeration enume = PropertyUtil.getPropertyNames(input1);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * testGetPropertyNames05(String)B<br>
     * 
     * (n)<br>
     * ϓ_FC,F<br>
     * 
     * ͒lFkey=""<br>
     * ҒlFL[Xg(S)<br>
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertyNamesString05() throws Exception {
        // ͒l̐ݒ
        String input1 = "";

        // eXgΏۂ̎s
        Enumeration actualEnum = PropertyUtil.getPropertyNames(input1);

        // ʊmF
        Map expectedProps =
            (Map) UTUtil.getPrivateField(PropertyUtil.class, "props");
        Enumeration expectedEnum = Collections.enumeration(expectedProps.keySet());
        while (expectedEnum.hasMoreElements()) {
            String actualStr = (String) actualEnum.nextElement();
            String expectedStr = (String) expectedEnum.nextElement();
            assertEquals(expectedStr, actualStr);
        }
    }

    /**
     * testGetPropertyNames06(String)B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒lFkey=݂L[̃vtBbNX<br>
     * ҒlFL[Xg(1)<br>
     * @throws Exception O */
    public void testGetPropertyNamesString06() throws Exception {
        // ͒l̐ݒ
        String input1 = "property.test004.id";

        // eXgΏۂ̎s
        Enumeration enume = PropertyUtil.getPropertyNames(input1);

        // ʊmF
        assertEquals("property.test004.id.0", enume.nextElement());
        assertFalse(enume.hasMoreElements());
    }

    /**
     * testGetPropertiesValues01(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FF<br>
     * <br>
     * ͒l :vpeBt@C,L[<br>
     * Ғl :lZbgigPj<br>
     *
     * FL[ɊYlP̎A
     * w肳ꂽvpeBt@Cl擾邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertiesValuesString01() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = "test";
        //L[
        String key = "file";
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        // ʊmF
        assertTrue(result.contains("/tmp/test"));
    }

    /**
     * testGetPropertiesValues02(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBt@C,L[<br>
     * Ғl :lZbgigj<br>
     *
     * FL[ɊYl̎A
     * w肳ꂽvpeBt@ClZbg擾邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertiesValuesString02() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = "test";
        //L[
        String key = "code";
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        // ʊmF
        assertTrue(
            result.contains(
                "select values01,values01,values01 "
                    + "from table_kamoTest where Key1 between ? and ?"));
        assertTrue(result.contains("\u660e\u6cbb"));
        assertTrue(result.contains("\u662d\u548c"));
        assertTrue(result.contains("\u6c5f\u6238"));
        assertTrue(result.contains("\u5e73\u6210"));
        assertTrue(result.contains("\u5927\u6b63"));
    }

    /**
     * testGetPropertiesValues03(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :vpeBt@C,L[null<br>
     * Ғl :null<br>
     *
     * FL[Null̎Anullԋp邱ƂmFB
     * 
     * @throws Exception O */
    public void testGetPropertiesValuesString03() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = "test";
        //L[
        String key = null;
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        // ʊmF
        assertNull(result);
    }

    /**
     * testGetPropertiesValues04(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :vpeBt@Cnull,L[<br>
     * Ғl :null<br>
     *
     * FvpeBt@CNull̎A
     * Null߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertiesValuesString04() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = null;
        //L[
        String key = "file";

        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        //ʊmF
        assertNull(result);
    }

    /**
     * testGetPropertiesValues05(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBt@C,YL[ȂL[<br>
     * Ғl :lZbgigj<br>
     *
     * FL[ɊYlȂꍇA
     * "Enumeration"ԋp邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertiesValuesString05() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = "test_message_01";
        //L[
        String key = "file";
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        // ʊmF
        assertTrue(result.isEmpty());
    }

    /**
     * testGetPropertiesValues06(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :vpeBt@C󕶎,L[<br>
     * Ғl :null<br>
     *
     * FvpeBt@C󕶎̎A
     * Null߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertiesValuesString06() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = "";
        //L[
        String key = "file";

        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        //ʊmF
        assertNull(result);
    }

    /**
     * testGetPropertiesValues07(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBt@C,L[͋󕶎<br>
     * Ғl :lZbgiSđIj<br>
     *
     * FL[񂪋󕶎̏ꍇA
     * IꂽvpeBt@C̑SĒlԋp邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertiesValuesString07() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = "test_message_01";
        //L[
        String key = "";
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        // ʊmF
        assertTrue(result.contains("{0}ftHgbZ[W"));
        assertTrue(result.contains("ObZ[W"));
        assertTrue(result.contains(""));
    }

    /**
     * testGetPropertiesValues08(String, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBt@C,L[(݂L[܂)<br>
     * Ғl :lZbgigj<br>
     *
     * FL[ɕ݂L[܂߂A
     * lZbg1擾邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertiesValuesString08() throws Exception {
        // ͒l̐ݒ
        //vpeBt@C
        String input = "test";
        //L[
        String key = "property.test004";
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, key);

        // ʊmF
        assertTrue(result.contains("testB"));
        assertFalse(result.contains("testA"));
    }

    /**
     * testGetPropertyNames01(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBi1jAL[vtBbNX<br>
     * Ғl :ΉL[ꗗi1j<br>
     *
     * FvpeBIuWFNg̒gP̎A
     * ΉL[1擾Ă邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertyNamesPropertiesString01() throws Exception {
        // ͒l̐ݒ
        String key1 = "SystemExceptionHandlerTest.key";
        String value1 = "{0}message";

        Properties input = new Properties();
        input.setProperty(key1, value1);

        String keyprefix = "System";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        Set set = new HashSet();
        set.add("SystemExceptionHandlerTest.key");
        assertTrue(set.contains(result.nextElement()));
        assertFalse(result.hasMoreElements());
    }

    /**
     * testGetPropertyNames02(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBijAL[vtBbNX<br>
     * Ғl :ΉL[ꗗi1j<br>
     *
     * FvpeBIuWFNg̒g̎A
     * ΉL[1擾Ă邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertyNamesPropertiesString02() throws Exception {
        // ͒l̐ݒ
        String key1 = "SystemExceptionHandlerTest.key";
        String value1 = "{0}message";

        String key2 = "property.test004.id.0";
        String value2 = "testA";

        Properties input = new Properties();
        input.setProperty(key1, value1);
        input.setProperty(key2, value2);

        String keyprefix = "System";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        Set set = new HashSet();
        set.add("SystemExceptionHandlerTest.key");
        assertTrue(set.contains(result.nextElement()));
        assertFalse(result.hasMoreElements());
    }

    /**
     * testGetPropertyNames03(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBijAL[vtBbNX<br>
     * Ғl :ΉL[ꗗij<br>
     *
     * FvpeBIuWFNg̒g̎A
     * ΉL[擾Ă邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertyNamesPropertiesString03() throws Exception {
        // ͒l̐ݒ
        String key1 = "SystemExceptionHandlerTest.key";
        String value1 = "{0}message";

        String key2 = "property.test002.id.2";
        String value2 = "test2";

        String key3 = "property.test004.id.0";
        String value3 = "testB";

        Properties input = new Properties();
        input.setProperty(key1, value1);
        input.setProperty(key2, value2);
        input.setProperty(key3, value3);

        String keyprefix = "property";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        //ꂽEnumurationɓĂ邱Ƃ̊mF
        Set set = new HashSet();
        set.add("property.test002.id.2");
        set.add("property.test004.id.0");
        assertTrue(set.contains(result.nextElement()));
        assertTrue(set.contains(result.nextElement()));
        assertFalse(result.hasMoreElements());
    }

    /**
     * testGetPropertyNames04(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBijAL[vtBbNX<br>
     * Ғl :Enumeration<br>
     *
     * FvpeBIuWFNgɑΉ镔L[vtBbNXȂꍇA
     * EnumerationԋpĂ邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertyNamesPropertiesString04() throws Exception {
        // ͒l̐ݒ
        String key1 = "SystemExceptionHandlerTest.key";
        String value1 = "{0}message";

        String key2 = "property.test002.id.2";
        String value2 = "test2";

        String key3 = "property.test004.id.0";
        String value3 = "testB";

        Properties input = new Properties();
        input.setProperty(key1, value1);
        input.setProperty(key2, value2);
        input.setProperty(key3, value3);

        String keyprefix = "a";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        assertFalse(result.hasMoreElements());
    }

    /**
     * testGetPropertyNames05(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :vpeBiNulljAL[vtBbNX<br>
     * Ғl :null<br>
     *
     * FvpeBIuWFNgnull̏ꍇA
     * null߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertyNamesPropertiesString05() throws Exception {
        // ͒l̐ݒ
        Properties input = null;

        String keyprefix = "properties";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        assertNull(result);
    }

    /**
     * testGetPropertyNames06(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FC,F<br>
     * <br>
     * ͒l :vpeBAL[vtBbNX(null)<br>
     * Ғl :null<br>
     *
     * FL[vtBbNXnull̏ꍇA
     * null߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertyNamesPropertiesString06() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();
        String key1 = "SystemExceptionHandlerTest.key";
        String value1 = "{0}message";
        input.setProperty(key1, value1);

        String keyprefix = null;

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        assertNull(result);
    }

    /**
     * testGetPropertyNames07(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FC,F<br>
     * <br>
     * ͒l :vpeBijAL[vtBbNX<br>
     * Ғl :Enumeration<br>
     *
     * FvpeBIuWFNg̏ꍇA
     * EnumerationԋpĂ邱ƂmFB
     *
     * @throws Exception O */
    public void testGetPropertyNamesPropertiesString07() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();

        String keyprefix = "properties";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        assertFalse(result.hasMoreElements());
    }

    /**
     * testGetPropertyNames08(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FC,F<br>
     * <br>
     * ͒l :vpeBAL[vtBbNX(󕶎)<br>
     * Ғl :ΉSẴL[ꗗ<br>
     *
     * FL[vtBbNX󕶎̏ꍇA
     * ΉSẴL[ꗗԋp邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertyNamesPropertiesString08() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();

        String key1 = "property.test002.id.2";
        String value1 = "test2";

        String key2 = "property.test004.id.0";
        String value2 = "testB";

        String key3 = "property.test001.id.0";
        String value3 = "test";

        input.setProperty(key1, value1);
        input.setProperty(key2, value2);
        input.setProperty(key3, value3);

        String keyprefix = "";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        Set set = new HashSet();
        set.add("property.test002.id.2");
        set.add("property.test004.id.0");
        set.add("property.test001.id.0");
        assertTrue(set.contains(result.nextElement()));
        assertTrue(set.contains(result.nextElement()));
        assertTrue(set.contains(result.nextElement()));
        assertFalse(result.hasMoreElements());
    }

    /**
     * testGetPropertyNames09(Properties, String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :L[݂vpeBIuWFNg<br>
     * Ғl :ΉSẴL[ꗗ<br>
     *
     * FL[݂vpeBIuWFNg̏ꍇ
     * ̂1ԋp邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertyNamesPropertiesString09() throws Exception {
        // ͒l̐ݒ
        String key1 = "SystemExceptionHandlerTest.key";
        String value1 = "{0}message";

        String key2 = "property.test002.id.2";
        String value2 = "test2";

        String key3 = "property.test004.id.0";
        String value3 = "testA";

        String key4 = "property.test004.id.0";
        String value4 = "testB";

        Properties input = new Properties();
        input.setProperty(key1, value1);
        input.setProperty(key2, value2);
        input.setProperty(key3, value3);
        input.setProperty(key4, value4);

        String keyprefix = "pro";

        // eXgΏۂ̎s
        Enumeration result = PropertyUtil.getPropertyNames(input, keyprefix);

        // ʊmF
        //ꂽEnumurationɓĂ邱Ƃ̊mF
        Set set = new HashSet();
        set.add("property.test002.id.2");
        set.add("property.test004.id.0");
        assertTrue(set.contains(result.nextElement()));
        assertTrue(set.contains(result.nextElement()));
        assertFalse(result.hasMoreElements());
    }
    /**
     * testGetPropertiesValues01(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBi1jAL[̈ꗗi1j<br>
     * Ғl :lZbgi1j<br>
     *
     * FvpeBIuWFNg̒gPŁAL[ꗗ̒gP̎A
     * w肳ꂽvpeBl1擾Ă邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues01() throws Exception {
        // ͒l̐ݒ
        String key1 = "SystemExceptionHandlerTest.key";
        String value1 = "{0}message";

        Properties input = new Properties();
        input.setProperty(key1, value1);

        Enumeration em = new StringTokenizer("SystemExceptionHandlerTest.key");
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertTrue(result.contains("{0}message"));
    }

    /**
     * testGetPropertiesValues02(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBijAL[̈ꗗij<br>
     * Ғl :lZbgij<br>
     *
     * FvpeBIuWFNg̒g̎A
     * w肳ꂽvpeBl擾Ă邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues02() throws Exception {
        // ͒l̐ݒ
        String key1 = "property.test001.id.0";
        String value1 = "test";

        String key2 = "property.test002.id.0";
        String value2 = "test0";

        String key3 = "property.test002.id.1";
        String value3 = "test1";

        Properties input = new Properties();
        input.setProperty(key1, value1);
        input.setProperty(key2, value2);
        input.setProperty(key3, value3);

        Enumeration em =
            new StringTokenizer("property.test001.id.0 property.test002.id.0 property.test002.id.1");

        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertTrue(result.contains("test0"));
        assertTrue(result.contains("test1"));
        assertTrue(result.contains("test"));
    }

    /**
     * testGetPropertiesValues03(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBilɋ󂪂̂܂ށjAL[̈ꗗij<br>
     * Ғl :lZbgil̂̂ɂẮAƕ\j<br>
     *
     * FvpeBIuWFNg̒ɁAL[ɑ΂lȂ̂܂܂ꍇ
     * " "Ŏ擾Ă邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues03() throws Exception {
        // ͒l̐ݒ
        String key1 = "property.test001.id.0";
        String value1 = "test";

        String key2 = "property.test002.id.0";
        String value2 = "test0";

        String key3 = "property.test003.id.0";
        String value3 = "";

        Properties input = new Properties();
        input.setProperty(key1, value1);
        input.setProperty(key2, value2);
        input.setProperty(key3, value3);

        Enumeration em =
            new StringTokenizer("property.test001.id.0 property.test002.id.0 property.test003.id.0");

        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertTrue(result.contains("test0"));
        assertTrue(result.contains("test"));
        assertTrue(result.contains(""));
    }

    /**
     * testGetPropertiesValues04(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FC,F<br>
     * <br>
     * ͒l :vpeBnullAL[̈ꗗ<br>
     * Ғl :null<br>
     *
     * FvpeBnull̎Anull߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues04() throws Exception {
        // ͒l̐ݒ
        Properties input = null;

        Enumeration em = new StringTokenizer("property.test001.id.0");
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertNull(result);
    }

    /**
     * testGetPropertiesValues05(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBAL[̈ꗗnull<br>
     * Ғl :null<br>
     *
     * FL[̈ꗗnull̎Anull߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues05() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();
        String key1 = "property.test001.id.0";
        String value1 = "test";
        input.setProperty(key1, value1);

        Enumeration em = null;
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertNull(result);
    }

    /**
     * testGetPropertiesValues06(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FC,F<br>
     * <br>
     * ͒l :vpeBAL[̈ꗗ<br>
     * Ғl :"null"<br>
     *
     * FvpeB̎A"null"Ŏ擾邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues06() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();

        Enumeration em = new StringTokenizer("property.test001.id.0");
        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertTrue(result.contains(null));
    }

    /**
     * testGetPropertiesValues07(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBAL[̈ꗗ<br>
     * Ғl :<br>
     *
     * FL[̈ꗗ̎A󂪎擾邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues07() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();
        String key1 = "property.test001.id.0";
        String value1 = "test";
        input.setProperty(key1, value1);

        Enumeration em = new StringTokenizer("");

        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertTrue(result.isEmpty());
    }

    /**
     * testGetPropertiesValues08(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :L[݂vpeBIuWFNg<br>
     * Ғl :lZbg<br>
     *
     * FL[݂vpeBIuWFNg̏ꍇ
     * ̂1̒l擾Ă邱ƂmFB
     * 
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues08() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();
        String key1 = "property.test004.id.0";
        String value1 = "testA";

        String key2 = "property.test004.id.0";
        String value2 = "testB";

        input.setProperty(key1, value1);
        input.setProperty(key2, value2);

        Enumeration em = new StringTokenizer("property.test004.id.0");

        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertTrue(result.contains("testB"));
        assertFalse(result.contains("testA"));
    }

    /**
     * testGetPropertiesValues09(Properties, Enumeration)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :L[ꗗɑ݂ȂvpeBL[<br>
     * Ғl :"null"<br>
     *
     * FvpeB̃L[L[ꗗɑ݂ȂꍇA"null"Ŏ擾邱ƂmFB
     * 
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetPropertiesValues09() throws Exception {
        // ͒l̐ݒ
        Properties input = new Properties();
        String key1 = "property.test001.id.0";
        String value1 = "test";

        input.setProperty(key1, value1);

        Enumeration em = new StringTokenizer("property.test004.id.0");

        // eXgΏۂ̎s
        Set result = PropertyUtil.getPropertiesValues(input, em);

        // ʊmF
        assertTrue(result.contains(null));
        assertFalse(result.contains("test"));
    }

    /**
     * testLoadProperties01(String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBt@C<br>
     * Ғl :vpeBIuWFNgigPj<br>
     *
     * FvpeBIuWFNg̒gP̎A
     * w肳ꂽvpeBt@C[hĂ邱ƂmFB
     *
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testLoadProperties01() throws Exception {
        // ͒l̐ݒ
        String input = "test_message_01_en_US";

        // eXgΏۂ̎s
        Properties result = PropertyUtil.loadProperties(input);

        // ʊmF
        Set set = new HashSet();
        set.add("{SystemExceptionHandlerTest.key={0}message}");

        assertTrue(result.containsKey("SystemExceptionHandlerTest.key"));
        assertTrue(result.containsValue("{0}message"));
    }

    /**
     * testLoadProperties02(String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :vpeBt@C<br>
     * Ғl :vpeBIuWFNgigj<br>
     *
     * Fw肳ꂽvpeBt@C̒ǧ[hĂ邱ƂmFB
     *
     * @throws Exception O */
    public void testLoadProperties02() throws Exception {
        // ͒l̐ݒ
        String input = "test_message_01";

        // eXgΏۂ̎s
        Properties result = PropertyUtil.loadProperties(input);

        // ʊmF
        assertTrue(
            result.containsKey("SystemExceptionHandlerTest.error.message"));
        assertTrue(
            result.containsValue("\u4f8b\u5916\u30e1\u30c3\u30bb\u30fc\u30b8"));
        assertTrue(
            result.containsKey(
                "SystemExceptionHandlerTest.error.message.null"));
        assertTrue(result.containsValue(""));
        assertTrue(result.containsKey("SystemExceptionHandlerTest.key"));
        assertTrue(
            result.containsValue(
                "{0}\u30c7\u30d5\u30a9\u30eb\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8"));
    }

    /**
     * testLoadProperties03(String)B<br>
     * 
     * inj<br>
     * ϓ_FC,F<br>
     * <br>
     * ͒l :null<br>
     * Ғl :null<br>
     *
     * FvpeBt@C݂ȂꍇNull߂lƂďI邱ƂmFB
     * @throws Exception O */
    public void testLoadProperties03() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgΏۂ̎s
        Properties result = PropertyUtil.loadProperties(input);

        //ʊmF
        assertNull(result);
    }

    /**
     * testLoadProperties04(String)B<br>
     * 
     * inj<br>
     * ϓ_FC,F<br>
     * <br>
     * ͒l :""(󕶎)<br>
     * Ғl :null<br>
     *
     * FvpeBt@C݂ȂꍇNull߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    public void testLoadProperties04() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgΏۂ̎s
        Properties result = PropertyUtil.loadProperties(input);

        //ʊmF
        assertNull(result);
    }

    /**
     * testLoadProperties05(String)B<br>
     * 
     * inj<br>
     * ϓ_FA,F<br>
     * <br>
     * ͒l :gɉĂȂvpeBt@C<br>
     * Ғl :̃vpeBIuWFNg<br>
     *
     * Fw肳ꂽvpeBt@C̒g̎A
     * ̃vpeBIuWFNgoĂ邱ƂmFB
     *
     * @throws Exception O */
    public void testLoadProperties05() throws Exception {
        // ͒l̐ݒ
        String input = "test_message_10";

        // eXgΏۂ̎s
        Properties result = PropertyUtil.loadProperties(input);

        // ʊmF
        assertTrue(result.isEmpty());
    }

    /**
     * testLoadProperties06(String)B<br>
     * 
     * inj<br>
     * ϓ_FF<br>
     * <br>
     * ͒l :݂ȂvpeBt@C<br>
     * Ғl :null<br>
     * OF"*** Can not find property-file [test_me.properties] ***"
     *
     * F݂Ȃt@Cw肳ꂽA
     * null߂lƂďI邱ƂmFB
     *
     * @throws Exception O */
    public void testLoadProperties06() throws Exception {
        // ͒l̐ݒ
        String input = "test_me";

        // eXgΏۂ̎s
        Properties result = PropertyUtil.loadProperties(input);

        // ʊmF
        LogUTUtil.checkWarn("*** Can not find property-file" +
                " [test_me.properties] ***");
        assertNull(result);
    }

    /**
     * testGetPropertiesPathStringString01()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :fBNgtt@C=
     * subDir/PropertyUtil.class<br>
     * Ώۂ̃t@C=hoge.txt
     * Ғl :subDir"t@CZp[^(OSɂقȂ)"hoge.txt<br>
     *
     * ̃tpXt@CAfBNg{t@C
     * o͂邱ƂmFB
     * 
     * @throws Exception
     * @throws Exception O */
    public void testGetPropertiesPathStringString01() throws Exception {
        // eXgݒ
        // getPropertiesPatḧNXvf
        Class[] clz = new Class[]{String.class, String.class};
        // getPropertiesPatḧIuWFNgvf
        Object[] obj = new Object[]{"subDir/PropertyUtil.class", "hoge.txt"};

        // eXgs
        Object retObj = UTUtil.invokePrivate(PropertyUtil.class,
            "getPropertiesPath", clz, obj);
        
        // eXg
        assertEquals("subDir" + System.getProperty("file.separator")
            + "hoge.txt", retObj);
    }

    /**
     * testGetPropertiesPathStringString02()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :
     * ()resourceFnull<br>
     * ()addFileF"/hoge.txt"<br>
     * Ғl :
     * (߂l)StringF-<br>
     * (O)FNullPointerException
     *
     * resourcenull̏ꍇ
     * 
     * @throws Exception
     * @throws Exception O */
    public void testGetPropertiesPathStringString02() throws Exception {
        // eXgݒ
        // getPropertiesPatḧNXvf
        Class[] clz = new Class[]{String.class, String.class};
        // getPropertiesPatḧIuWFNgvf
        Object[] obj = new Object[]{null, "hoge.txt"};

        // eXgs
        try {
            UTUtil.invokePrivate(PropertyUtil.class,
                    "getPropertiesPath", clz, obj);
            fail();
        } catch (NullPointerException e) {
            // eXg
        	return;
        }
    }

    /**
     * testGetPropertiesPathStringString03()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :
     * ()resourceF"subDir/PropertyUtil.class"<br>
     * ()addFileFnull<br>
     * Ғl :
     * (߂l)StringF"subDir/null"<br>
     * (O)F-
     *
     * addFilenull̏ꍇ
     * 
     * @throws Exception
     * @throws Exception O */
    public void testGetPropertiesPathStringString03() throws Exception {
        // eXgݒ
        // getPropertiesPatḧNXvf
        Class[] clz = new Class[]{String.class, String.class};
        // getPropertiesPatḧIuWFNgvf
        Object[] obj = new Object[]{"subDir/PropertyUtil.class", null};

        // eXgs
        Object retObj = UTUtil.invokePrivate(PropertyUtil.class,
            "getPropertiesPath", clz, obj);
        
        // eXg
        assertEquals("subDir" + System.getProperty("file.separator")
            + "null", retObj);
    }

    /**
     * testGetPropertiesPathStringString04()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :
     * ()resourceF""<br>
     * ()addFileF""<br>
     * Ғl :
     * (߂l)StringF""<br>
     * (O)F-
     *
     * 󔒂̏ꍇ
     * 
     * @throws Exception
     * @throws Exception O */
    public void testGetPropertiesPathStringString04() throws Exception {
        // eXgݒ
        // getPropertiesPatḧNXvf
        Class[] clz = new Class[]{String.class, String.class};
        // getPropertiesPatḧIuWFNgvf
        Object[] obj = new Object[]{"", ""};

        // eXgs
        Object retObj = UTUtil.invokePrivate(PropertyUtil.class,
            "getPropertiesPath", clz, obj);
        
        // eXg
        assertEquals("", retObj);
    }

}
