/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.CollectorResultHandler;
import jp.terasoluna.fw.batch.core.JobStatus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <code>CollectorResultHandler</code> C^tF[X̕WNXB
 *
 * <p>̃NXł́ARN^ʂ0łꍇɂ
 * G[Ƃɂ̂܂܌pB</p>
 *
 * <p>RN^ʂ<code>NORMAL_CONTINUE</code>A
 * <code>NORMAL_END</code>̏ꍇ͏񃍃OɁA
 * <code>ERROR_CONTINUE</code>̏ꍇ͌xOɁA
 * <code>ERROR_END</code>̏ꍇ̓G[Oɂꂼo͂B</p>
 *
 */
public class StandardCollectorResultHandler 
    implements CollectorResultHandler {

    /**
     * OCX^XB
     */
    private static Log log = 
        LogFactory.getLog(StandardCollectorResultHandler.class);

    /**
     * RN^ʂB
     * 
     * @param collectorResult RN^
     * @param jobStatus WuXe[^X
     */
    public void handle(CollectorResult collectorResult, JobStatus jobStatus) {
        switch (collectorResult.getReturnCode()) {
            case NORMAL_CONTINUE:
                writeInfoLog("Collector processing result code is "
                        + "NORMAL_CONTINUE", jobStatus, collectorResult);
                break; 
            case NORMAL_END:
                writeInfoLog("Collector processing result code is NORMAL_END",
                        jobStatus, collectorResult);
                break;
            case ERROR_CONTINUE:
                writeWarnLog("Collector processing result code is "
                        + "ERROR_CONTINUE", jobStatus, collectorResult);
                break;
            case ERROR_END:
                jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                writeErrorLog("Collector processing result code is ERROR_END",
                        jobStatus, collectorResult);
                break;
            default:
                throw new IllegalArgumentException(
                        collectorResult.getCollected() + " illegal ReturnCode");
        }
    }

    /**
     * RN^ʂł̏񃍃Oo͂B
     * 
     * @param message bZ[W
     * @param jobStatus WuXe[^X
     * @param collectorResult RN^
     */
    protected void writeInfoLog(String message, JobStatus jobStatus,
            CollectorResult collectorResult) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder(message);
            logStr.append(" : [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [CollectorResult Info:");
            logStr.append(collectorResult);
            logStr.append("]");
            log.info(logStr.toString());
        }
    }
    
    /**
     * RN^ʂł̃G[Oo͂B
     * 
     * @param message bZ[W
     * @param jobStatus WuXe[^X
     * @param collectorResult RN^
     */
    protected void writeErrorLog(String message, JobStatus jobStatus,
            CollectorResult collectorResult) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [CollectorResult Info:");
        logStr.append(collectorResult);
        logStr.append("]");
        log.error(logStr.toString());
    }

    /**
     * RN^ʂł̌xOo͂B
     * 
     * @param message bZ[W
     * @param jobStatus WuXe[^X
     * @param collectorResult RN^
     */
    protected void writeWarnLog(String message, JobStatus jobStatus,
            CollectorResult collectorResult) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [CollectorResult Info:");
        logStr.append(collectorResult);
        logStr.append("]");
        log.warn(logStr.toString());
    }
}
