/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.Workable;

/**
 * gUNVs[J[NXB
 * 
 * <p><code>jobWorker</code> ɐݒ肳ꂽ[J̌ĂяogUNV
 * ŎsB</p>
 * 
 * <p>gUNVs߁AWuXe[^XƂ 
 * <code>TransactionalJobStatus</code>gpKvB</p>
 * 
 */
public class TransactionalWorker implements Workable<Chunk> {

    /**
     * Wu[J[B
     */
    private Workable<Chunk> jobWorker = null;
    
    /**
     * [J[̏sB
     * 
     * @param chunk `N
     * @param jobStatus gUNViWuXe[^X
     */
    public void work(Chunk chunk, JobStatus jobStatus) {
        
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;
        transactionalJobStatus.beginTransaction();
        
        // Z[u|CgLɍŏ̃Z[u|Cg쐬
        if (transactionalJobStatus.useSavepoint()) {
            transactionalJobStatus.releaseAndCreateSavepoint();
        }

        jobWorker.work(chunk, transactionalJobStatus);
        
        //I
        if (jobStatus.isShutdownImmediate()) {
            jobStatus.suspend();
            transactionalJobStatus.rollback();
            return;
        }

        if (jobStatus.isExecuting()
                || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY
                || jobStatus.isShutdownGraceful()) {
            transactionalJobStatus.commit();
        } else {
            transactionalJobStatus.rollback();
            // Z[u|CgL͍ŌɃR~bg
            if (transactionalJobStatus.useSavepoint()) {
                transactionalJobStatus.commit();
            }
        }

        //fI
        if (jobStatus.isShutdownGraceful()) {
            jobStatus.suspend();
            return;
        }
    }

    /**
     * Wu[J[ݒ肷B
     * 
     * @param jobWorker Wu[J[
     */
    public void setJobWorker(Workable<Chunk> jobWorker) {
        this.jobWorker = jobWorker;
    }
}
