/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.openapi.JobContext;

import org.apache.commons.collections.FastHashMap;
import org.apache.commons.lang.ArrayUtils;

/**
 * <p>Rg[uCNp`NNXB</p>
 * <p>`NRg[uCNL[̃`N𐶐AL[ɒǉB
 * ̃NXł͐ݒ肳ꂽL[͂A`NRg[uCN
 * Ă邩ǂ𔻒肷B</p>
 * <p>fʂ`NRg[uCNRowf[^ɎA
 * <code>ControlBreakWorker</code>A
 * <code>ControlBreakBLogicExecutor</code>łꂼuCNNB
 * 
 * 
 */
public class ControlBreakChunk extends Chunk {

    /**
     * `N̏I[pIuWFNgB
     */
    public static final Object END_MARK = new Object();
    
    
    /**
     * `ÑuCN}[NpIuWFNgB
     */
    public static final Object CHUNK_BREAK_MARK = new Object();
    
    /**
     * Rg[uCNL[XgBij
     */
    private final List<ControlBreakDefItem> controlBreakDefItemList;

    /**
     * `NRg[uCNL[XgBij
     */
    private final ControlBreakDefItem chunkControlBreakDefItem;

    /**
     * gXRg[uCNL[XgBij
     */
    private final List<ControlBreakDefItem> transChunkControlBreakDefItemList;
    
    /**
     * ̃f[^ŁA`NRg[uCNĂ邩ǂ
     * B
     */
    private boolean chunkControlBreak = false;
    
    /**
     * `NRg[uCNL[}bvB
     * ΏۃIuWFNgɊւāÃIuWFNg̑ێ}bvB
     * `NRg[uCNL[\vpeB݂̂ێB
     */
    private Map<String, Object> chunkControlBreakMap = null;

    /**
     * ΏۃIuWFNgɊւāÃIuWFNg̑ێ}bvB
     * `NRg[uCNL[\vpeB݂̂ێB
     */
    private Map<String, Object> chunkNextData = null;

    /**
     * Rg[uCNL[}bvB
     * ΏۃIuWFNgɊւāÃIuWFNg̑ێ}bvB
     * Rg[uCNL[\vpeB݂̂ێB
     */
    private Map<String, Object> controlBreakMap = null;

    /**
     * ΏۃIuWFNgɊւāÃIuWFNg̑ێ}bvB
     * Rg[uCNL[\vpeB݂̂ێB
     */
    private Map<String, Object> nextData = null;

    /**
     * gXRg[uCNL[B
     */
    private List<List<String>> transChunkControlBreakKeyList;
    
    /**
     * ΏۃIuWFNgɊւāÃIuWFNg̑ێ}bvB
     * gXRg[uCNL[\vpeB݂̂ێB
     */
    private LinkedHashMap<String, Object> transNextData;

    /**
     * ŏI`NtOB
     */
    private boolean endChunk = false;
    
    /**
     * Methodcache
     */
    private FastHashMap methodMap = null;
    
    /**
     * RXgN^
     *  
     * @param jobContext WuReLXg
     * @param controlBreakDef Rg[uCN̒`
     * @param chunkSize `NTCY
     */
    public ControlBreakChunk(JobContext jobContext,
            ControlBreakDef controlBreakDef, int chunkSize) {
        super(chunkSize, jobContext);
        this.controlBreakDefItemList = controlBreakDef
                .getControlBreakDefItemList();
        this.chunkControlBreakDefItem = controlBreakDef
                .getChunkControlBreakDefItem();
        this.transChunkControlBreakDefItemList = controlBreakDef
                .getTransChunkControlBreakDefItemList();
        this.transChunkControlBreakKeyList = new ArrayList<List<String>>(
                transChunkControlBreakDefItemList.size());

        chunkNextData = new LinkedHashMap<String, Object>(
                chunkControlBreakDefItem.getBreakKey().size());
        transNextData = new LinkedHashMap<String, Object>(chunkNextData.size());

    }

    /**
     * RXgN^ 
     * 
     * @param jobContext JobContext
     * @param controlBreakDef Rg[uCN`
     * @param chunkSize `NTCY
     * @param nextData O`ÑRg[uCNL[̍\
     * @param chunkNextData O`Ñ`NRg[uCNL[̍\
     * 
     */
    public ControlBreakChunk(JobContext jobContext,
            ControlBreakDef controlBreakDef, int chunkSize,
            Map<String, Object> nextData, Map<String, Object> chunkNextData) {
        super(chunkSize, jobContext);
        this.controlBreakDefItemList = controlBreakDef
                .getControlBreakDefItemList();
        this.chunkControlBreakDefItem = controlBreakDef
                .getChunkControlBreakDefItem();
        this.transChunkControlBreakDefItemList = controlBreakDef
                .getTransChunkControlBreakDefItemList();
        this.transChunkControlBreakKeyList = new ArrayList<List<String>>(
                transChunkControlBreakDefItemList.size());

        this.nextData = nextData;
        controlBreakMap = nextData;

        chunkControlBreakMap = chunkNextData;
        this.chunkNextData = new LinkedHashMap<String, Object>(
                chunkControlBreakDefItem.getBreakKey().size());
        transNextData = new LinkedHashMap<String, Object>(chunkNextData.size());

    }
    
    /**
     * f[^ݒ肷B
     * 
     * @param next f[^
     * @return Rg[uCNpRowIuWFNgNX
     */
    public ControlBreakRowObject setNext(Object next) {
        controlBreakMap = nextData;

        transChunkControlBreakKeyList.clear();

        // `NRg[uCNL[}bv̏
        chunkNextData.clear();

        List<List<String>> controlBreakKeyList = new ArrayList<List<String>>(
                controlBreakDefItemList.size());

        // gX`NRg[uCÑuCNL`FbNp
        transNextData.clear();
        
        //`NRg[uCN̔𔻒fAʂ`NɂɒǉB
        if (chunkControlBreakDefItem.getBreakKey().size() > 0) {
            for (String propertyName : chunkControlBreakDefItem.getBreakKey()) {
                Object value = getBreakKeyValue(next, propertyName);
                chunkNextData.put(propertyName, value);
                
                // `NRg[uCNL[\vpeB
                // ǂꂩЂƂłlςĂꍇɂ́A
                // `NRg[uCNL[ĂB
                if (chunkControlBreakMap != null && value != null
                        && !value.equals(
                                chunkControlBreakMap.get(propertyName))) {
                    chunkControlBreak = true;
                    //gX`NRg[̃uCN
                    transNextData.put(propertyName, value);
                }
            }
        }
        // `NRg[uCNʂ̃Rg[uCN
        // Ă邩mFB
        if (chunkControlBreak) {
            checkTransChunkControlBreak(transNextData.keySet());
        }
        
        if (chunkControlBreakMap == null) {
            chunkControlBreakMap = chunkNextData;
            chunkNextData = new LinkedHashMap<String, Object>(
                    chunkControlBreakDefItem.getBreakKey().size());
        }
        
        // Rg[uCN̔𔻒fAʂRowf[^ɒǉB
        if (controlBreakDefItemList.size() > 0) {
            nextData = new LinkedHashMap<String, Object>(
                    controlBreakDefItemList.size());

            for (ControlBreakDefItem controlBreakDefItem
                    : controlBreakDefItemList) {
                boolean controlBreak = false;
                for (String propertyName : controlBreakDefItem.getBreakKey()) {
                    Object value = getBreakKeyValue(next, propertyName);
                    nextData.put(propertyName, value);
                    // `NRg[uCNL[\vpeB
                    // ǂꂩЂƂłlςĂꍇɂ́A
                    // `NRg[uCNL[ĂB
                    if (!controlBreak && controlBreakMap != null
                            && value != null
                            && !value.equals(controlBreakMap.get(propertyName)))
                    {
                        controlBreak = true;
                    }
                }
                if (controlBreak) {
                    controlBreakKeyList.add(controlBreakDefItem.getBreakKey());
                }
            }
        }

        return new ControlBreakRowObject(next, controlBreakKeyList,
                controlBreakMap);
    }
    
    /**
     * ŏIf[^̃Rg[uCN̍Đݒ
     * @param last ŏIf[^
     * @return Rg[uCNpRowIuWFNgNX
     */
    public ControlBreakRowObject setLastData(Object last) {
        transChunkControlBreakKeyList.clear();

        // `NRg[uCNL[}bv̏
        chunkNextData = new LinkedHashMap<String, Object>(
                chunkControlBreakDefItem.getBreakKey().size());
        nextData = new LinkedHashMap<String, Object>(controlBreakDefItemList
                .size());
        chunkControlBreak = true;

        List<List<String>> controlBreakKeyList = new ArrayList<List<String>>(
                controlBreakDefItemList.size());

        // `NRg[uCN̔𔻒fAʂ`NɂɒǉB
        for (String propertyName : chunkControlBreakDefItem.getBreakKey()) {
            Object value = getBreakKeyValue(last, propertyName);
            chunkNextData.put(propertyName, value);
        }
        checkTransChunkControlBreak(chunkNextData.keySet());

        // Rg[uCN̔𔻒fAʂRowf[^ɒǉB
        if (controlBreakDefItemList.size() > 0) {
            for (ControlBreakDefItem controlBreakDefItem
                    : controlBreakDefItemList) {
                for (String propertyName : controlBreakDefItem.getBreakKey()) {
                    Object value = getBreakKeyValue(last, propertyName);
                    nextData.put(propertyName, value);
                    controlBreakKeyList.add(controlBreakDefItem.getBreakKey());
                }
            }
        }
        return new ControlBreakRowObject(ControlBreakChunk.END_MARK,
                controlBreakKeyList, nextData);
    }
    
    
    /**
     * w肳ꂽvpeB̒l̐؂ւɂāA`NRg[uC
     * Nʂ̃Rg[uCNĂ邩mFB
     *  
     * @param propertyNameSet l̐؂ւ肪vpeB
     */
    private void checkTransChunkControlBreak(Set<String> propertyNameSet) {
        if (transChunkControlBreakDefItemList == null) {
            return;
        }
        // `Nœo^ꂽuCNL[tɂĂ`FbNs
        String[] propertyNames =
            propertyNameSet.toArray(new String[propertyNameSet.size()]);
        ArrayUtils.reverse(propertyNames);
        for (ControlBreakDefItem transChunkControlBreakDefItem
                : transChunkControlBreakDefItemList) {
            for (String propertyName : propertyNames) {
                if (transChunkControlBreakDefItem.getBreakKey().contains(
                        propertyName)) {
                    transChunkControlBreakKeyList
                            .add(transChunkControlBreakDefItem.getBreakKey());
                    break;
                }
            }
        }
    }
    
    /**
     * `NRg[uCÑuCNL[̒l擾B
     * 
     * @return `NRg[uCÑuCNL[̒l
     */
    public Map<String, Object> getChunkControlBreakMap() {
        return chunkControlBreakMap;
    }

    /**
     * gXRg[uCNL[̃Xg擾B
     * 
     * @return gXRg[uCNL[̃Xg
     */
    public List<List<String>> getTransChunkControlBreakKeyList() {
        return transChunkControlBreakKeyList;
    }

    
    /**
     * `NRg[uCNĂ邩ǂ𔻒肷B
     * 
     * @return `NRg[uCNĂꍇɂ́A
     * <code>true</code>
     */
    public boolean isChunkControlBreak() {
        return chunkControlBreak;
    }

    /**
     * ŏI`Nł邩]B
     * 
     * @return ŏI`FbN̏ꍇA<code>true</code>
     */
    public boolean isEndChunk() {
        return endChunk;
    }

    /**
     * ŏI`NtOݒ肷B
     * 
     * @param endChunk ŏI`NtO
     */
    public void setEndChunk(boolean endChunk) {
        this.endChunk = endChunk;
    }

    
    /**
     * Rg[uCÑuCNL[̒l擾B
     * @return controlBreakMap Rg[uCÑuCNL[̒l
     */
    public Map<String, Object> getNextData() {
        return nextData;
    }

    /**
     * `NRg[uCÑuCNL[̒l擾B
     * @return chunkNextData `NRg[uCÑuCNL[̒l
     */
    public Map<String, Object> getChunkNextData() {
        return chunkNextData;
    }
    
    /**
     * uCNL[̒l擾
     * @param object RowObject 
     * @param breakKey uCNL[
     * @return uCNL[̒l
     */
    private Object getBreakKeyValue(Object object, String breakKey) {
        // 
        if (methodMap == null) {
            try {
                // BreakKeySet
                HashSet<String> keySet = new HashSet<String>();
                for (String propertyName : chunkControlBreakDefItem
                        .getBreakKey()) {
                    keySet.add(propertyName);
                }
                for (ControlBreakDefItem controlBreakDefItem
                        : controlBreakDefItemList) {
                    for (String propertyName : controlBreakDefItem
                            .getBreakKey()) {
                        if (!keySet.contains(propertyName)) {
                            keySet.add(propertyName);
                        }
                    }
                }
                // Method Map
                methodMap = new FastHashMap();
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                PropertyDescriptor[] descriptors = beanInfo
                        .getPropertyDescriptors();
                for (PropertyDescriptor descriptor : descriptors) {
                    if (keySet.contains(descriptor.getName())) {
                        methodMap.put(descriptor.getName(), descriptor
                                .getReadMethod());
                    }
                }
            } catch (IntrospectionException e) {
                throw new JobException(e);
            }
        }

        try {
            Method method = (Method) methodMap.get(breakKey);
            return method.invoke(object, new Object[0]);
        } catch (IllegalAccessException e) {
            throw new JobException(e);
        } catch (InvocationTargetException e) {
            throw new JobException(e);
        }
    }

    /**
     * @return methodMap ߂܂B
     */
    public FastHashMap getMethodMap() {
        return methodMap;
    }

    /**
     * @param methodMap ݒ肷 methodMapB
     */
    public void setMethodMap(FastHashMap methodMap) {
        this.methodMap = methodMap;
    }
}
