/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;

/**
 * CommonJ[N}l[WŎsĂ郏[NL[̏ԂĎNXB
 * 
 * 
 */
public class WorkQueueListener implements WorkMapListener {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(WorkQueueListener.class);

    /**
     * XPW[ꂽ[Nێ}bvB
     */
    private Map<WorkItem, Work> map = Collections
            .synchronizedMap(new HashMap<WorkItem, Work>());

    /**
     * XPW[ꂽ[N̓o^B
     * 
     * @param workItem [N[N}lW[ŃXPW[Ƃ̕ԋpl
     * @param work XPW[[N
     */
    public void addWork(WorkItem workItem, Work work) {
        map.put(workItem, work);
    }

    /**
     * XPW[Ă郏[N̎擾B
     * 
     * @param workItem [N[N}lW[ŃXPW[Ƃ̕ԋpl
     * @return XPW[Ă郏[N
     */
    public Work getWork(WorkItem workItem) {
        return (Work) map.get(workItem);
    }

    /**
     * Ƃ[N폜B
     * 
     * @param workItem [N[N}lW[ŃXPW[Ƃ̕ԋpl
     * @return XPW[Ă郏[N
     */
    public Work removeWork(WorkItem workItem) {
        return (Work) map.remove(workItem);
    }

    /**
     * [N̎tɎs郁\bhB
     * 
     * @param we [NCxg
     */
    public void workAccepted(WorkEvent we) {
        printSimpleLog("Work accepted: ", getWork(we.getWorkItem()));
    }

    /**
     * [N̊Ɏs郁\bhB
     * 
     * @param we [NCxg
     */
    public void workCompleted(WorkEvent we) {
        printSimpleLog("Work completed: ", removeWork(we.getWorkItem()));
    }

    /**
     * [N̎tێɎs郁\bhB
     * 
     * @param we [NCxg
     */
    public void workRejected(WorkEvent we) {
        printSimpleLog("Work rejected: ", removeWork(we.getWorkItem()));
    }

    /**
     * [N̊JnɎs郁\bhB
     * 
     * @param we [NCxg
     */
    public void workStarted(WorkEvent we) {
        printSimpleLog("Work started: ", getWork(we.getWorkItem()));
    }

    /**
     * ȒPȃOóB
     * 
     * @param message ObZ[W
     * @param object o̓IuWFNg
     */
    private void printSimpleLog(String message, Object object) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append("[");
            builder.append(object);
            builder.append("]");
            log.debug(builder.toString());
        }
    }

}
