/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.xml;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;
import org.springmodules.validation.bean.conf.BeanValidationConfiguration;
import org.springmodules.validation.bean.conf.CascadeValidation;
import org.springmodules.validation.bean.conf.DefaultBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.ValidationConfigurationException;
import org.springmodules.validation.bean.conf.loader.xml.AbstractXmlBeanValidationConfigurationLoader;
import org.springmodules.validation.bean.conf.loader.xml.DefaultValidationRuleElementHandlerRegistry;
import org.springmodules.validation.bean.conf.loader.xml.ValidationRuleElementHandlerRegistry;
import org.springmodules.validation.bean.conf.loader.xml.handler.ClassValidationElementHandler;
import org.springmodules.validation.bean.conf.loader.xml.handler.PropertyValidationElementHandler;
import org.springmodules.validation.bean.rule.PropertyValidationRule;
import org.springmodules.validation.bean.rule.ValidationMethodValidationRule;
import org.springmodules.validation.bean.rule.ValidationRule;
import org.springmodules.validation.bean.rule.resolver.ErrorArgumentsResolver;
import org.springmodules.validation.bean.rule.resolver.FunctionErrorArgumentsResolver;
import org.springmodules.validation.util.cel.ConditionExpressionBased;
import org.springmodules.validation.util.cel.ConditionExpressionParser;
import org.springmodules.validation.util.cel.valang.ValangConditionExpressionParser;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.common.AlwaysTrueCondition;
import org.springmodules.validation.util.fel.FunctionExpressionBased;
import org.springmodules.validation.util.fel.FunctionExpressionParser;
import org.springmodules.validation.util.fel.parser.ValangFunctionExpressionParser;
import org.springmodules.validation.util.lang.ReflectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlBeanValidationConfigurationLoader
extends AbstractXmlBeanValidationConfigurationLoader
implements ConditionExpressionBased,
FunctionExpressionBased,
ApplicationContextAware {
    public static final String DEFAULT_NAMESPACE_URL = "http://www.springmodules.org/validation/bean";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader == null ? (class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader = DefaultXmlBeanValidationConfigurationLoader.class$("org.springmodules.validation.bean.conf.loader.xml.DefaultXmlBeanValidationConfigurationLoader")) : class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader));
    private static final String CLASS_TAG = "class";
    private static final String GLOBAL_TAG = "global";
    private static final String PROPERTY_TAG = "property";
    private static final String METHOD_TAG = "method";
    private static final String VALIDATOR_TAG = "validator";
    private static final String PACKAGE_ATTR = "package";
    private static final String NAME_ATTR = "name";
    private static final String CASCADE_ATTR = "cascade";
    private static final String CASCADE_CONDITION_ATTR = "cascade-condition";
    private static final String CLASS_ATTR = "class";
    private static final String CODE_ATTR = "code";
    private static final String MESSAGE_ATTR = "message";
    private static final String ARGS_ATTR = "args";
    private static final String APPLY_IF_ATTR = "apply-if";
    private static final String CONTEXTS_ATTR = "contexts";
    private static final String FOR_PROPERTY_ATTR = "for-property";
    private ValidationRuleElementHandlerRegistry handlerRegistry;
    private boolean conditionParserExplicitlySet = false;
    private ConditionExpressionParser conditionExpressionParser;
    private boolean functionParserExplicitlySet = false;
    private FunctionExpressionParser functionExpressionParser;
    private ApplicationContext applicationContext;
    static /* synthetic */ Class class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader;
    static /* synthetic */ Class class$org$springframework$validation$Validator;
    static /* synthetic */ Class class$org$springmodules$validation$util$cel$ConditionExpressionParser;
    static /* synthetic */ Class class$org$springmodules$validation$util$fel$FunctionExpressionParser;

    public DefaultXmlBeanValidationConfigurationLoader() {
        this(new DefaultValidationRuleElementHandlerRegistry());
    }

    public DefaultXmlBeanValidationConfigurationLoader(ValidationRuleElementHandlerRegistry handlerRegistry) {
        this(handlerRegistry, new ValangConditionExpressionParser(), new ValangFunctionExpressionParser());
    }

    public DefaultXmlBeanValidationConfigurationLoader(ValidationRuleElementHandlerRegistry handlerRegistry, ConditionExpressionParser conditionExpressionParser, FunctionExpressionParser functionExpressionParser) {
        this.handlerRegistry = handlerRegistry;
        this.conditionExpressionParser = conditionExpressionParser;
        this.functionExpressionParser = functionExpressionParser;
    }

    protected Map loadConfigurations(Document document, String resourceName) {
        HashMap<Class, BeanValidationConfiguration> configurations = new HashMap<Class, BeanValidationConfiguration>();
        Element validationDefinition = document.getDocumentElement();
        String packageName = validationDefinition.getAttribute(PACKAGE_ATTR);
        NodeList nodes = validationDefinition.getElementsByTagNameNS(DEFAULT_NAMESPACE_URL, "class");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Class clazz;
            Element classDefinition = (Element)nodes.item(i);
            String className = classDefinition.getAttribute(NAME_ATTR);
            className = StringUtils.hasLength((String)packageName) ? packageName + "." + className : className;
            try {
                clazz = ClassUtils.forName((String)className);
            }
            catch (ClassNotFoundException cnfe) {
                logger.error((Object)("Could not load class '" + className + "' as defined in '" + resourceName + "'"), (Throwable)cnfe);
                continue;
            }
            configurations.put(clazz, this.handleClassDefinition(clazz, classDefinition));
        }
        return configurations;
    }

    public void afterPropertiesSet() throws Exception {
        this.initContext(this.handlerRegistry);
        super.afterPropertiesSet();
        this.findConditionExpressionParserInApplicationContext();
        this.findFunctionExpressionParserInApplicationContext();
        Assert.notNull((Object)this.conditionExpressionParser);
        Assert.notNull((Object)this.functionExpressionParser);
    }

    public void setElementHandlerRegistry(ValidationRuleElementHandlerRegistry registry) {
        this.handlerRegistry = registry;
    }

    public ValidationRuleElementHandlerRegistry getElementHandlerRegistry() {
        return this.handlerRegistry;
    }

    public void setConditionExpressionParser(ConditionExpressionParser conditionExpressionParser) {
        this.conditionParserExplicitlySet = true;
        this.conditionExpressionParser = conditionExpressionParser;
    }

    public void setFunctionExpressionParser(FunctionExpressionParser functionExpressionParser) {
        this.functionParserExplicitlySet = true;
        this.functionExpressionParser = functionExpressionParser;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void initContext(Object object) throws Exception {
        if (object instanceof ApplicationContextAware) {
            ((ApplicationContextAware)object).setApplicationContext(this.applicationContext);
        }
        if (object instanceof InitializingBean) {
            ((InitializingBean)object).afterPropertiesSet();
        }
    }

    public BeanValidationConfiguration handleClassDefinition(Class clazz, Element element) {
        int i;
        DefaultBeanValidationConfiguration configuration = new DefaultBeanValidationConfiguration();
        NodeList nodes = element.getElementsByTagNameNS(DEFAULT_NAMESPACE_URL, VALIDATOR_TAG);
        for (i = 0; i < nodes.getLength(); ++i) {
            Element validatorDefinition = (Element)nodes.item(i);
            this.handleValidatorDefinition(validatorDefinition, clazz, configuration);
        }
        nodes = element.getElementsByTagNameNS(DEFAULT_NAMESPACE_URL, GLOBAL_TAG);
        for (i = 0; i < nodes.getLength(); ++i) {
            Element globalDefinition = (Element)nodes.item(i);
            this.handleGlobalDefinition(globalDefinition, clazz, configuration);
        }
        nodes = element.getElementsByTagNameNS(DEFAULT_NAMESPACE_URL, METHOD_TAG);
        for (i = 0; i < nodes.getLength(); ++i) {
            Element methodDefinition = (Element)nodes.item(i);
            this.handleMethodDefinition(methodDefinition, clazz, configuration);
        }
        nodes = element.getElementsByTagNameNS(DEFAULT_NAMESPACE_URL, PROPERTY_TAG);
        for (i = 0; i < nodes.getLength(); ++i) {
            Element propertyDefinition = (Element)nodes.item(i);
            this.handlePropertyDefinition(propertyDefinition, clazz, configuration);
        }
        return configuration;
    }

    protected void handleValidatorDefinition(Element validatorDefinition, Class clazz, MutableBeanValidationConfiguration configuration) {
        String className = validatorDefinition.getAttribute("class");
        configuration.addCustomValidator(this.constructValidator(className));
    }

    protected void handleGlobalDefinition(Element globalDefinition, Class clazz, MutableBeanValidationConfiguration configuration) {
        NodeList nodes = globalDefinition.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element ruleDefinition = (Element)node;
            ClassValidationElementHandler handler = this.handlerRegistry.findClassHandler(ruleDefinition, clazz);
            if (handler == null) {
                logger.error((Object)("Could not handle element '" + ruleDefinition.getTagName() + "'. Please make sure the proper validation rule definition handler is registered"));
                throw new ValidationConfigurationException("Could not handler element '" + ruleDefinition.getTagName() + "'");
            }
            handler.handle(ruleDefinition, configuration);
        }
    }

    protected void handleMethodDefinition(Element methodDefinition, Class clazz, MutableBeanValidationConfiguration configuration) {
        String methodName = methodDefinition.getAttribute(NAME_ATTR);
        if (!StringUtils.hasText((String)methodName)) {
            logger.error((Object)"Could not parse method element. Missing or empty 'name' attribute");
            throw new ValidationConfigurationException("Could not parse method element. Missing 'name' attribute");
        }
        String errorCode = methodDefinition.getAttribute(CODE_ATTR);
        String message = methodDefinition.getAttribute(MESSAGE_ATTR);
        String argsString = methodDefinition.getAttribute(ARGS_ATTR);
        String conditionString = methodDefinition.getAttribute(APPLY_IF_ATTR);
        String propertyName = methodDefinition.getAttribute(FOR_PROPERTY_ATTR);
        String contextsString = methodDefinition.getAttribute(CONTEXTS_ATTR);
        ValidationMethodValidationRule rule = this.createMethodValidationRule(clazz, methodName, errorCode, message, argsString, contextsString, conditionString);
        if (StringUtils.hasText((String)propertyName)) {
            this.validatePropertyExists(clazz, propertyName);
            configuration.addPropertyRule(propertyName, rule);
        } else {
            configuration.addGlobalRule(rule);
        }
    }

    protected ValidationMethodValidationRule createMethodValidationRule(Class clazz, String methodName, String errorCode, String message, String argsString, String contextsString, String applyIfString) {
        Method method = ReflectionUtils.findMethod(clazz, methodName);
        if (method == null) {
            throw new ValidationConfigurationException("Method named '" + methodName + "' was not found in class hierarchy of '" + clazz.getName() + "'.");
        }
        if (!StringUtils.hasText((String)errorCode)) {
            errorCode = methodName + "()";
        }
        if (!StringUtils.hasText((String)message)) {
            message = errorCode;
        }
        if (!StringUtils.hasText((String)argsString)) {
            argsString = "";
        }
        ErrorArgumentsResolver argsResolver = this.buildErrorArgumentsResolver(argsString);
        Condition applyIfCondition = new AlwaysTrueCondition();
        if (StringUtils.hasText((String)applyIfString)) {
            applyIfCondition = this.conditionExpressionParser.parse(applyIfString);
        }
        String[] contexts = null;
        if (StringUtils.hasText((String)contextsString)) {
            contexts = StringUtils.commaDelimitedListToStringArray((String)contextsString);
        }
        ValidationMethodValidationRule rule = new ValidationMethodValidationRule(method);
        rule.setErrorCode(errorCode);
        rule.setDefaultErrorMessage(message);
        rule.setErrorArgumentsResolver(argsResolver);
        rule.setApplicabilityCondition(applyIfCondition);
        rule.setContextTokens(contexts);
        return rule;
    }

    protected ErrorArgumentsResolver buildErrorArgumentsResolver(String argsString) {
        String[] args = StringUtils.tokenizeToStringArray((String)argsString, (String)", ");
        return new FunctionErrorArgumentsResolver(args, this.functionExpressionParser);
    }

    protected void handlePropertyDefinition(Element propertyDefinition, Class clazz, MutableBeanValidationConfiguration configuration) {
        String propertyName = propertyDefinition.getAttribute(NAME_ATTR);
        if (!StringUtils.hasText((String)propertyName)) {
            logger.error((Object)"Could not parse property element. Missing or empty 'name' attribute");
            throw new ValidationConfigurationException("Could not parse property element. Missing 'name' attribute");
        }
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)clazz, (String)propertyName);
        if (propertyDescriptor == null) {
            logger.error((Object)("Property '" + propertyName + "' does not exist in class '" + clazz.getName() + "'"));
        }
        if (propertyDefinition.hasAttribute(CASCADE_ATTR) && "true".equals(propertyDefinition.getAttribute(CASCADE_ATTR))) {
            CascadeValidation cascadeValidation = new CascadeValidation(propertyName);
            if (propertyDefinition.hasAttribute(CASCADE_CONDITION_ATTR)) {
                String conditionExpression = propertyDefinition.getAttribute(CASCADE_CONDITION_ATTR);
                cascadeValidation.setApplicabilityCondition(this.conditionExpressionParser.parse(conditionExpression));
            }
            configuration.addCascadeValidation(cascadeValidation);
        }
        NodeList nodes = propertyDefinition.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element ruleDefinition = (Element)node;
            PropertyValidationElementHandler handler = this.handlerRegistry.findPropertyHandler(ruleDefinition, clazz, propertyDescriptor);
            if (handler == null) {
                logger.error((Object)("Could not handle element '" + ruleDefinition.getTagName() + "'. Please make sure the proper validation rule definition handler is registered"));
                throw new ValidationConfigurationException("Could not handle element '" + ruleDefinition.getTagName() + "'");
            }
            handler.handle(ruleDefinition, propertyName, configuration);
        }
    }

    protected PropertyValidationRule createPropertyRule(String propertyName, ValidationRule rule) {
        return new PropertyValidationRule(propertyName, rule);
    }

    protected Validator constructValidator(String className) {
        try {
            Class clazz = ClassUtils.forName((String)className);
            if (!(class$org$springframework$validation$Validator == null ? (class$org$springframework$validation$Validator = DefaultXmlBeanValidationConfigurationLoader.class$("org.springframework.validation.Validator")) : class$org$springframework$validation$Validator).isAssignableFrom(clazz)) {
                throw new ValidationConfigurationException("class '" + className + "' is not a Validator implementation");
            }
            return (Validator)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ValidationConfigurationException("Could not load validator class '" + className + "'");
        }
        catch (IllegalAccessException e) {
            throw new ValidationConfigurationException("Could not instantiate validator '" + className + "'. Make sure it has a default constructor.");
        }
        catch (InstantiationException e) {
            throw new ValidationConfigurationException("Could not instantiate validator '" + className + "'. Make sure it has a default constructor.");
        }
    }

    protected void findConditionExpressionParserInApplicationContext() {
        if (this.applicationContext == null || this.conditionParserExplicitlySet) {
            return;
        }
        String[] names = this.applicationContext.getBeanNamesForType(class$org$springmodules$validation$util$cel$ConditionExpressionParser == null ? (class$org$springmodules$validation$util$cel$ConditionExpressionParser = DefaultXmlBeanValidationConfigurationLoader.class$("org.springmodules.validation.util.cel.ConditionExpressionParser")) : class$org$springmodules$validation$util$cel$ConditionExpressionParser);
        if (names.length == 0) {
            return;
        }
        if (names.length > 1) {
            logger.warn((Object)"Multiple condition expression parsers are defined in the application context. Only the first encountered one will be used");
        }
        this.conditionExpressionParser = (ConditionExpressionParser)this.applicationContext.getBean(names[0]);
    }

    protected void findFunctionExpressionParserInApplicationContext() {
        if (this.applicationContext == null || this.functionParserExplicitlySet) {
            return;
        }
        String[] names = this.applicationContext.getBeanNamesForType(class$org$springmodules$validation$util$fel$FunctionExpressionParser == null ? (class$org$springmodules$validation$util$fel$FunctionExpressionParser = DefaultXmlBeanValidationConfigurationLoader.class$("org.springmodules.validation.util.fel.FunctionExpressionParser")) : class$org$springmodules$validation$util$fel$FunctionExpressionParser);
        if (names.length == 0) {
            return;
        }
        if (names.length > 1) {
            logger.warn((Object)"Multiple function expression parsers are defined in the application context. Only the first encountered one will be used");
        }
        this.functionExpressionParser = (FunctionExpressionParser)this.applicationContext.getBean(names[0]);
    }

    protected void validatePropertyExists(Class clazz, String property) {
        BeanUtils.getPropertyDescriptor((Class)clazz, (String)property);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

