/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.CollectorResultHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardCollectorResultHandler
implements CollectorResultHandler {
    private static Log log = LogFactory.getLog(StandardCollectorResultHandler.class);

    public void handle(CollectorResult collectorResult, JobStatus jobStatus) {
        switch (collectorResult.getReturnCode()) {
            case NORMAL_CONTINUE: 
            case NORMAL_END: {
                if (collectorResult.getCollected() != 0) break;
                this.writeInfoLog(jobStatus, collectorResult);
                break;
            }
            case ERROR_CONTINUE: {
                this.writeErrorLog(jobStatus, collectorResult);
                break;
            }
            case ERROR_END: {
                jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                this.writeErrorLog(jobStatus, collectorResult);
                break;
            }
            default: {
                throw new IllegalArgumentException(collectorResult.getCollected() + " illegal ReturnCode");
            }
        }
    }

    protected void writeInfoLog(JobStatus jobStatus, CollectorResult collectorResult) {
        StringBuilder logStr = new StringBuilder();
        logStr.append(" [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("]");
        logStr.append(" [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("]");
        logStr.append(" [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("]");
        logStr.append(" [CollectorResult Info:");
        logStr.append(collectorResult);
        logStr.append("]");
        log.info((Object)logStr.toString());
    }

    protected void writeErrorLog(JobStatus jobStatus, CollectorResult collectorResult) {
        StringBuilder logStr = new StringBuilder();
        logStr.append(" [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("]");
        logStr.append(" [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("]");
        logStr.append(" [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("]");
        logStr.append(" [CollectorResult Error:");
        logStr.append(collectorResult);
        logStr.append("]");
        log.error((Object)logStr.toString());
    }
}

