/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueProcessor {
    private static Log log = LogFactory.getLog(QueueProcessor.class);
    private Workable<WorkUnit> worker = null;
    private String name = null;
    private SupportProcessor preProcessor = null;
    private SupportProcessor postProcessor = null;

    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        this.printStartLog(jobStatus);
        boolean donePreProcess = false;
        WorkUnit preElement = null;
        while (true) {
            WorkUnit element;
            if ((element = workQueue.take()).isEndMark()) {
                if (preElement == null || this.postProcessor == null) break;
                this.postProcessor.process(preElement.getJobContext(), jobStatus);
                break;
            }
            if (!donePreProcess && this.preProcessor != null) {
                this.preProcessor.process(element.getJobContext(), jobStatus);
                if (!jobStatus.isContinue()) break;
                donePreProcess = true;
            }
            this.worker.work(element, jobStatus);
            if (!jobStatus.isContinue()) break;
            preElement = element;
        }
        this.printEndLog(jobStatus);
    }

    public void setWorker(Workable<WorkUnit> worker) {
        this.worker = worker;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    protected void printStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("\u3010START\u3011");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [QueueProcessorName=");
            logStr.append(this.name);
            logStr.append("]");
            logStr.append(" [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    protected void printEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("\u3010 END \u3011");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [QueueProcessorName=");
            logStr.append(this.name);
            logStr.append("]");
            logStr.append(" [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }
}

