/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.init;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import jp.terasoluna.fw.batch.core.JobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndFileChecker
extends TimerTask {
    private static Log log = LogFactory.getLog(EndFileChecker.class);
    private static final String EXTENSION_IMMEDIATE = "end";
    private static final String EXTENSION_GRACEFUL = "irp";
    private Map<String, JobStatus> jobStatusMap = new HashMap<String, JobStatus>();
    private String endFileDir = null;

    @Override
    public synchronized void run() {
        File dir = new File(this.endFileDir);
        if (!this.jobStatusMap.isEmpty()) {
            this.processEnd(dir);
        }
    }

    public void addParentJobStatus(JobStatus jobStatus, String jobID, String jobOptionID) {
        if (jobID == null || "".equals(jobID)) {
            return;
        }
        if (jobOptionID == null || "".equals(jobOptionID)) {
            this.jobStatusMap.put(jobID, jobStatus);
        } else {
            this.jobStatusMap.put(jobID + "_" + jobOptionID, jobStatus);
        }
    }

    private void processEnd(File endFileDir) {
        String[] fileNames = endFileDir.list();
        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        for (String fileName : fileNames) {
            String[] splitFileName = fileName.split("[.]");
            if (splitFileName.length != 2) continue;
            String endFileName = splitFileName[0];
            String endType = splitFileName[1];
            List<String> processKey = this.getProcessKey(endFileName);
            this.endJob(endType, processKey);
        }
    }

    private void endJob(String endType, List<String> processKey) {
        for (String key : processKey) {
            JobStatus jobStatus = this.jobStatusMap.get(key);
            if (EXTENSION_IMMEDIATE.equals(endType)) {
                jobStatus.shutdownImmediate();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(key + " shutdown_immediate"));
                continue;
            }
            if (EXTENSION_GRACEFUL.equals(endType)) {
                jobStatus.shutdownGraceful();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(key + " shutdown_graceful"));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\"." + endType + "\" is invalid file extension."));
        }
    }

    private List<String> getProcessKey(String endFileName) {
        Set<String> keyset = this.jobStatusMap.keySet();
        ArrayList<String> processKey = new ArrayList<String>();
        String processKeyPrefix = endFileName + "_";
        for (String jobStatusKey : keyset) {
            if (!jobStatusKey.equals(endFileName) && !jobStatusKey.startsWith(processKeyPrefix)) continue;
            processKey.add(jobStatusKey);
        }
        return processKey;
    }

    public void setEndFileDir(String endFileDir) {
        this.endFileDir = endFileDir;
    }
}

