/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.external;

import com.ibatis.common.jdbc.logging.ConnectionLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.sqlmap.engine.transaction.IsolationLevel;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ExternalTransaction
implements Transaction {
    private static final Log connectionLog = LogFactory.getLog(class$java$sql$Connection == null ? (class$java$sql$Connection = ExternalTransaction.class$("java.sql.Connection")) : class$java$sql$Connection);
    private DataSource dataSource;
    private boolean defaultAutoCommit;
    private boolean setAutoCommitAllowed;
    private Connection connection;
    private IsolationLevel isolationLevel = new IsolationLevel();
    static /* synthetic */ Class class$java$sql$Connection;

    public ExternalTransaction(DataSource ds, boolean defaultAutoCommit, boolean setAutoCommitAllowed, int isolationLevel) throws TransactionException {
        this.dataSource = ds;
        if (this.dataSource == null) {
            throw new TransactionException("ExternalTransaction initialization failed.  DataSource was null.");
        }
        this.defaultAutoCommit = defaultAutoCommit;
        this.setAutoCommitAllowed = setAutoCommitAllowed;
        this.isolationLevel.setIsolationLevel(isolationLevel);
    }

    private void init() throws SQLException, TransactionException {
        this.connection = this.dataSource.getConnection();
        if (this.connection == null) {
            throw new TransactionException("ExternalTransaction could not start transaction.  Cause: The DataSource returned a null connection.");
        }
        this.isolationLevel.applyIsolationLevel(this.connection);
        if (this.setAutoCommitAllowed && this.connection.getAutoCommit() != this.defaultAutoCommit) {
            this.connection.setAutoCommit(this.defaultAutoCommit);
        }
        if (connectionLog.isDebugEnabled()) {
            this.connection = ConnectionLogProxy.newInstance(this.connection);
        }
    }

    public void commit() throws SQLException, TransactionException {
    }

    public void rollback() throws SQLException, TransactionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException, TransactionException {
        if (this.connection != null) {
            try {
                this.isolationLevel.restoreIsolationLevel(this.connection);
            }
            finally {
                this.connection.close();
                this.connection = null;
            }
        }
    }

    public Connection getConnection() throws SQLException, TransactionException {
        if (this.connection == null) {
            this.init();
        }
        return this.connection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

