/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.jndi;

import java.util.Map;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiLocatorSupport;

/**
 * <p>TERASOLUNA񋟂JNDI֘Ã[eBeBftHgNXB</p>
 *
 * <p>
 * WebAPReiJNDI\[X[eBeBłB<br>
 * JNDI̔F؏񂪕Kvȏꍇ́ABean`t@CɕKvȃvpeB
 * ȉ̂悤ɐݒ肵Ainitialize\bhs邱ƁB
 * Bean`t@CoRł̃NX̃CX^X𐶐ꍇ
 * init-methodinitialize\bhw肷邱ƁB
 * <br>
 * <table border="1">
 * <caption><strong>Bean`t@C̐ݒ</strong></caption>
 * <tr>
 *   <td><center><strong>F؏</strong></center></td>
 *   <td><center><strong></strong></center></td>
 *   <td><center><strong></strong></center></td>
 * </tr>
 * <tr>
 *   <td>factory</td>
 *   <td>JNDIt@NgNXw肷B</td>
 *   <td>weblogic.jndi.WLInitialContextFactory</td>
 * </tr>
 * <tr>
 *   <td>url</td>
 *   <td>JNDIvoC_ĂURIw肷B</td>
 *   <td>t3://localhost:7001</td>
 * </tr>
 * <tr>
 *   <td>username</td>
 *   <td>JNDIT[õ[Uw肷B</td>
 *   <td>weblogic</td>
 * </tr>
 * <tr>
 *   <td>password</td>
 *   <td>JNDIT[õpX[hw肷B</td>
 *   <td>password</td>
 * </tr>
 * </table>
 * </p>
 * <br>
 *
 * WebLogiĉ悤JNDI\[XɃvtBbNXujava:comp/env/vtĂ
 * ȂꍇAvpeBujndiPrefixvfalseɐݒ肷B<br>
 * ftHgfalsełB<br>
 * <br>
 *
 * <strong>WebLogicBean`t@Cݒ</strong>
 * <code><pre>
 * &lt;bean id=&quot;jndiSupport&quot; singleton="false"
 *       class=&quot;jp.terasoluna.fw.web.jndi.DefaultJndiSupport&quot;&gt;
 *       init-method="initialize"&gt;
 *   &lt;!-- Zb^CWFNVŔF؏ݒ --&gt;
 *   &lt;property name="jndiEnvironmentMap"&gt;
 *     &lt;map&gt;
 *       &lt;entry key="factory"&gt;
 *         &lt;value&gt;weblogic.jndi.WLInitialContextFactory&lt;/value&gt;
 *       &lt;/entry&gt;
 *       &lt;entry key="url"&gt;
 *         &lt;value&gt;t3://localhost:7001&lt;/value&gt;
 *       &lt;/entry&gt;
 *       &lt;entry key="username"&gt;
 *         &lt;value&gt;weblogic&lt;/value&gt;
 *       &lt;/entry&gt;
 *       &lt;entry key="password"&gt;
 *         &lt;value&gt;password&lt;/value&gt;
 *       &lt;/entry&gt;
 *     &lt;/map&gt;
 *   &lt;/property&gt;
 *   &lt;!-- vpeBjndiPrefix̐ݒ --&gt;
 *   &lt;property name="jndiPrefix"&gt;&lt;value&gt;<strong>false</strong>&lt;/value&gt;&lt;/property&gt;
 * &lt;/bean&gt;
 * </pre></code>
 * </p>
 * <strong>TomcatBean`t@Cݒ</strong>
 * <code><pre>
 * &lt;bean id=&quot;jndiSupport&quot; singleton="false"
 *       class=&quot;jp.terasoluna.fw.web.jndi.DefaultJndiSupport&quot; &gt;<br>
 *   &lt;!-- vpeBjndiPrefix̐ݒiftHglfalsej --&gt;
 *   &lt;property name="jndiPrefix"&gt;&lt;value&gt;<strong>false</strong>&lt;/value&gt;&lt;/property&gt;
 * &lt;/bean&gt;
 * </pre></code>
 * </p>
 * <strong>gp@</strong>
 * <p>
 * Bean`t@CɃT[rXWbN̐ݒȉ̂悤ɍsB
 * <code><pre>
 * &lt;bean id="jndiLogic" singleton="false"
 *   class="jp.sample.JndiLogic"&gt;
 *   &lt;property name=<strong>"jndiSupport"</strong>&gt;
 *     &lt;ref bean=<strong>"jndiSupport"</strong> /&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;<br>
 * &lt;!-- JndiSupportݒ --&gt;
 * &lt;bean id=<strong>"jndiSupport"</strong>  singleton="false"
 *   class="jp.terasoluna.fw.web.jndi.DefaultJndiSupport" /&gt;
 * </code></pre>
 *
 * T[rXWbNňȉ̂悤{@link DefaultJndiSupport}擾B<br>
 *
 * <code><pre>
 * public class JndiLogic {
 *   private JndiSupport <strong>jndiSupport</strong> = null;
 *
 *   public void setJndiSupport(jndiSupport) {
 *     this.jndiSupport = jndiSupport;
 *   }
 *
 *   public Object jndiLookup(String name) {
 *     return <strong>jndiSupport.lookup(name)</strong>;
 *   }
 * }
 * </code></pre>
 * </p>
 *
 */
public class DefaultJndiSupport extends JndiLocatorSupport implements
        JndiSupport {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(DefaultJndiSupport.class);

    /**
     * JNDIt@NgNXjndiEnvironmentMap炩擾Ƃ̃L[B
     */
    private static final String JNDI_FACTORY_KEY = "factory";

    /**
     * JNDIvoC_URLjndiEnvironmentMap炩擾Ƃ̃L[B
     */
    private static final String JNDI_URL_KEY = "url";

    /**
     * JNDI[UjndiEnvironmentMap炩擾Ƃ̃L[B
     */
    private static final String JNDI_USERNAME_KEY = "username";

    /**
     * JNDIpX[hjndiEnvironmentMap炩擾Ƃ̃L[B
     */
    private static final String JNDI_PASSWORD_KEY = "password";

    /**
     * JNDIF؏i[<code>Map</code>B
     */
    private Map<String, String> jndiEnvironmentMap = null;

    /**
     * \[X̃vtBbNX̃Zb^[B
     * X[p[NXresourceRef̒lݒ肷B
     * ̑truȅꍇAvtBbNX"java:comp/env/"\[XɂB
     *
     * @param jndiPrefix \[X̃vtBbNXttO
     */
    public void setJndiPrefix(boolean jndiPrefix) {
        super.setResourceRef(jndiPrefix);
    }

    /**
     * \[X̃vtBbNX̃Qb^[B
     * X[p[NXresourceRef̒l擾B
     * ̑truȅꍇAvtBbNX"java:comp/env/"\[XɂB
     *
     * @return jndiPrefix \[X̃vtBbNXttO
     */
    public boolean isJndiPrefix() {
        return super.isResourceRef();
    }

    /**
     * jndiEnvironmentMap擾B
     * @return JNDIF؏i[<code>Map</code>B
     */
    public Map<String, String> getJndiEnvironmentMap() {
        return jndiEnvironmentMap;
    }

    /**
     * jndiEnvironmentMapݒ肷B
     * @param jndiEnvironmentMap JNDIF؏i[<code>Map</code>B
     */
    public void setJndiEnvironmentMap(Map<String, String> jndiEnvironmentMap) {
        this.jndiEnvironmentMap = jndiEnvironmentMap;
    }

    /**
     * RXgN^B
     */
    public DefaultJndiSupport() {
    }

    /**
     * JndiTemplate̊ݒsB
     */
    public void initialize() {

        // JNDIݒ肪Ăꍇ̂݁iWeblogic̏ꍇj
        if (jndiEnvironmentMap != null) {

            // jndiEnvironmentMapF؏擾
            String factory = jndiEnvironmentMap.get(JNDI_FACTORY_KEY);
            String url = jndiEnvironmentMap.get(JNDI_URL_KEY);
            String username = jndiEnvironmentMap.get(JNDI_USERNAME_KEY);
            String password = jndiEnvironmentMap.get(JNDI_PASSWORD_KEY);

            Properties environment = new Properties();
            environment.put(Context.INITIAL_CONTEXT_FACTORY, factory);
            environment.put(Context.PROVIDER_URL, url);

            if (!"".equals(username) && username != null) {
                environment.put(Context.SECURITY_PRINCIPAL, username);
                if (password == null) {
                    password = "";
                }
                environment.put(Context.SECURITY_CREDENTIALS, password);
            }

            // F؏vpeB̐ݒ
            getJndiTemplate().setEnvironment(environment);

            // Oo
            if (log.isInfoEnabled()) {
                log.info("Initialize Weblogic JNDI Resource");
                log.info(Context.INITIAL_CONTEXT_FACTORY + " = " + factory);
                log.info(Context.PROVIDER_URL + " = " + url);
                log.info(Context.SECURITY_PRINCIPAL + " = " + username);
                log.info(Context.SECURITY_CREDENTIALS + " = " + password);
            }
        }
    }

    /**
     * OIuWFNgɃoChāA
     * ̃oCfBO㏑B
     *
     * @param name IuWFNg
     * @param obj oChIuWFNg
     */
    public void rebind(String name, Object obj) {
        if (name == null || obj == null) {
            log.error("Illegal arguments error : name="
                    + name + ", obj=" + obj);
            throw new IllegalArgumentException();
        }
        // \[X̃vtBbNXݒ
        String jndiNameToUse = convertJndiName(name);
        try {
            getJndiTemplate().rebind(jndiNameToUse, obj);
        } catch (NamingException e) {
            log.error("Illegal JNDI context name.");
            throw new JndiException(e);
        }
    }

    /**
     * w肳ꂽIuWFNgAoChB
     *
     * @param name IuWFNg
     */
    public void unbind(String name) {
        if (name == null) {
            log.error("Illegal arguments error : name=" + name);
            throw new IllegalArgumentException();
        }
        // \[X̃vtBbNXݒ
        String jndiNameToUse = convertJndiName(name);
        try {
            getJndiTemplate().unbind(jndiNameToUse);
        } catch (NamingException e) {
            log.error("Illegal JNDI context name.");
            throw new JndiException(e);
        }
    }

    /**
     * w肳ꂽIuWFNg擾B
     *
     * @param name IuWFNg
     * @return IuWFNg
     */
    @Override
    public Object lookup(String name) {
        if (name == null) {
            log.error("Illegal arguments error : name=" + name);
            throw new IllegalArgumentException();
        }
        // \[X̃vtBbNXݒ
        String jndiNameToUse = convertJndiName(name);
        try {
            return getJndiTemplate().lookup(jndiNameToUse);
        } catch (NamingException e) {
            log.error("Illegal JNDI context name.");
            throw new JndiException(e);
        }
    }
}