/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.openapi.SupportLogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 񓯊^WuNɂāAWusOɎsT|[gB
 * 
 * <p>NΏۂ̃WũWuǗe[űN󋵂uNvɍXVB</p>
 * 
 */
public class AsyncJobPreLogic implements SupportLogic<AsyncJobContext> {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(AsyncJobPreLogic.class);

    /**
     * ObZ[WiNpjB
     */
    private String successMessage = "job starting by BatchDaemon";

    /**
     * RXgN^
     *
     */
    public AsyncJobPreLogic() {
    }
    
    /**
     * RXgN^
     * 
     * @param successMessage ObZ[WiIpj
     */
    protected AsyncJobPreLogic(String successMessage) {
        this.successMessage = successMessage;
    }

    /**
     * WuNOB<BR>
     * NΏۂ̃Wu˗̋N󋵂NɍXV鏈B
     * 
     * @param jobContext Wu˗i[WuReLXg
     * @return 񓯊WusȌʁBN󋵂XVłȂ
     * ꍇɂ́A<code>ReturnCode.ERROR_END</code>B
     */
    public BLogicResult execute(AsyncJobContext jobContext) {
        // WuJnO
        if (log.isDebugEnabled()) {
            printDebugLog(successMessage, jobContext.getJobInfo().getJobId());
        }
        
        return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

    /**
     * fobNbZ[W̏óB
     * 
     * @param message ObZ[W
     * @param requestID Wu˗ԍ
     */
    private void printDebugLog(String message, String requestID) {
        StringBuilder builder = new StringBuilder(message);
        builder.append(" yJob RequestID : ");
        builder.append(requestID);
        builder.append("z");
        log.debug(builder.toString());
    }
}
