/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.util;

import java.util.List;

/**
 * t@C@\Œ񋟂鏈̃C^tF[X.
 *
 * @see FileControlImpl
 * @see FileUtility
 */
public interface FileControl {

    /**
     * t@C̃Rs[.
     *
     * @param srcFile Rs[̃t@C̃pX
     * @param newFile Rs[̃t@C̃pX
     */
    void copyFile(String srcFile, String newFile);

    /**
     * t@C̍폜.
     *
     * @param srcFile 폜t@C̃pX
     */
    void deleteFile(String srcFile);

    /**
     * t@C.
     *
     * @param fileList t@C̃Xg
     * @param newFile Ăłt@C̃pX
     */
    void mergeFile(List<String> fileList, String newFile);

    /**
     * t@C̕ύXt@C̈ړ.
     *
     * @param srcFile ړÕpX
     * @param newFile ړ̃pX
     */
    void renameFile(String srcFile, String newFile);

}
