/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.terasoluna.fw.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControlFilter<E>
implements Filter {
    private static Log log = LogFactory.getLog(AbstractControlFilter.class);
    protected FilterConfig config = null;

    public void init(FilterConfig config) throws ServletException {
        this.setConfig(config);
    }

    protected void setConfig(FilterConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"setConfig() called.");
        }
        this.config = config;
    }

    protected E getController() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"setController() called.");
        }
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.config.getServletContext());
        String controllerId = this.config.getInitParameter("controller");
        if (controllerId == null || "".equals(controllerId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"init parameter 'controller' isn't defined or empty");
            }
            controllerId = this.getDefaultControllerBeanId();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("controller bean id = \"" + controllerId + "\""));
        }
        Object controller = null;
        try {
            controller = wac.getBean(controllerId, this.getControllerClass());
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error((Object)("not found " + controllerId + ". " + "controller bean not defined in Beans definition file."), (Throwable)e);
            throw new SystemException(e, this.getErrorCode());
        }
        catch (BeanNotOfRequiredTypeException e) {
            log.error((Object)("controller not implemented " + this.getControllerClass().toString() + "."), (Throwable)e);
            throw new SystemException(e, this.getErrorCode());
        }
        catch (BeansException e) {
            log.error((Object)"bean generation failed.", (Throwable)e);
            throw new SystemException(e, this.getErrorCode());
        }
        return (E)controller;
    }

    protected abstract Class getControllerClass();

    protected abstract String getErrorCode();

    public abstract String getDefaultControllerBeanId();

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void destroy() {
    }
}

