/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class TransactionalJobStatus
extends JobStatus {
    private Object savepoint = null;
    private PlatformTransactionManager transactionManager = null;
    private TransactionStatus transactionStatus = null;
    private boolean useSavepoint = false;

    public void beginTransaction() {
        this.transactionStatus = this.transactionManager.getTransaction(null);
    }

    public void commit() {
        if (!this.transactionStatus.isCompleted()) {
            this.transactionManager.commit(this.transactionStatus);
            this.savepoint = null;
            this.incrementCommitCount();
        }
    }

    public JobStatus getChild(JobContext jobContext) {
        TransactionalJobStatus childJobStatus = new TransactionalJobStatus();
        childJobStatus.setTransactionManager(this.transactionManager);
        childJobStatus.setUseSavepoint(this.useSavepoint);
        this.resetChildData(childJobStatus, jobContext);
        return childJobStatus;
    }

    protected PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void releaseAndCreateSavepoint() {
        if (!this.useSavepoint) {
            return;
        }
        if (this.savepoint != null) {
            this.transactionStatus.releaseSavepoint(this.savepoint);
        }
        this.savepoint = this.transactionStatus.createSavepoint();
    }

    public void rollback() {
        if (!this.transactionStatus.isCompleted() && this.useSavepoint && this.savepoint != null) {
            this.transactionStatus.rollbackToSavepoint(this.savepoint);
        } else if (!this.transactionStatus.isCompleted()) {
            this.transactionManager.rollback(this.transactionStatus);
        }
    }

    public void rollbackToSavepoint() {
        if (!this.useSavepoint) {
            return;
        }
        if (!this.transactionStatus.isCompleted() && this.savepoint != null) {
            this.transactionStatus.rollbackToSavepoint(this.savepoint);
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setUseSavepoint(boolean useSavepoint) {
        this.useSavepoint = useSavepoint;
    }

    public boolean useSavepoint() {
        return this.useSavepoint;
    }
}

