/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.init.JobControlTableHandler;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.openapi.SupportLogic;
import jp.terasoluna.fw.batch.springsupport.init.AsyncJobContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncJobPostLogic
implements SupportLogic<AsyncJobContext> {
    private static Log log = LogFactory.getLog(AsyncJobPostLogic.class);
    private JobControlTableHandler jobControlTableHandler = null;
    private String failureMessage = "job ended in failure by BatchDaemon";
    private String successMessage = "job ending by BatchDaemon";

    public AsyncJobPostLogic() {
    }

    protected AsyncJobPostLogic(String faulureMessage, String successMessage) {
        this.failureMessage = faulureMessage;
        this.successMessage = successMessage;
    }

    @Override
    public BLogicResult execute(AsyncJobContext jobContext) {
        if (this.handle(jobContext.getJobInfo()) != 1) {
            if (log.isDebugEnabled()) {
                this.printDebugLog(this.failureMessage, jobContext.getJobInfo().getJobId());
            }
            return new BLogicResult(ReturnCode.ERROR_END);
        }
        if (log.isDebugEnabled()) {
            this.printDebugLog(this.successMessage, jobContext.getJobInfo().getJobId());
        }
        return new BLogicResult(ReturnCode.NORMAL_END);
    }

    protected int handle(JobInfo jobInfo) {
        return this.jobControlTableHandler.updateJobEnd(jobInfo);
    }

    public void setJobControlTableHandler(JobControlTableHandler jobControlTableHandler) {
        this.jobControlTableHandler = jobControlTableHandler;
    }

    private void printDebugLog(String message, String jobId) {
        StringBuilder builder = new StringBuilder(message);
        builder.append(" \u3010Job ID : ");
        builder.append(jobId);
        builder.append("\u3011");
        log.debug((Object)builder.toString());
    }
}

