/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.core;

import java.util.Map;


/**
 * Onh̃[eBeBNXB
 * 
 * <p>t[[NAKvȗOnh擾ۂɃ[eBeBƂ
 * pB</p>
 * 
 * <p><code>JobExceptionHandler</code> C^tF[XOnh
 * p邱Ƃz肵[eBeBł͂ȂƂɗӂ邱ƁB</p>
 * 
 */
public final class ExceptionHandlerUtil {

    /**
     * RXgN^B
     *
     */
    private ExceptionHandlerUtil() {
    }

    /**
     * w肳ꂽOɑΉOnh擾B
     *
     * @param e nhOΏۂ̗O
     * @param exceptionHandlerMap Onhi[Map
     * @param defaultJobExceptionHandler ftHgOnh
     * @return nhOΏۂ̗OɑΉOnh
     */
    public static JobExceptionHandler getJobExceptionHandler(Exception e,
            Map<JobException, JobExceptionHandler> exceptionHandlerMap,
            JobExceptionHandler defaultJobExceptionHandler) {
        JobExceptionHandler handler = null;
        for (Map.Entry<JobException, JobExceptionHandler> entry
                : exceptionHandlerMap.entrySet()) {
            JobException entryJobException = entry.getKey();
            if (entryJobException.getClass().isAssignableFrom(e.getClass())) {
                handler = entry.getValue();
                break;
            }
        }
        if (handler == null) {
            handler = defaultJobExceptionHandler;
        }
        return handler;
    }

}
