/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * PtH[hANVB
 *
 * <p>
 *  ActionEx̋@\iJڃOóEgUNVg[N`FbNjpA
 *  JSPȂǂփtH[hANVłB
 *  Struts񋟂ĂForwardActionƓl
 *  struts-config.xml&lt;action&gt;vf
 *  parameterɎw肵ɃtH[hB
 *  parameterݒ肳ĂȂꍇA
 *  Œ̘_tH[husuccessvŃANVtH[h擾B
 *  tH[h悪ݒ肳ĂȂꍇA
 *  SC_NOT_FOUNDi404jG[ԂB
 *  *.jspt@Cւ̒ڃANZX֎~ĂꍇɁA
 *  JSPƖoPɕ\ɂ
 *  ̃ANVpstruts-config.xml
 *  ɃGg쐬KvB
 *  ActionEx#execute()ōsĂ鏈́A
 *  łpB
 * </p>
 * <p>
 *  parameterł́AW[΃pX̎w肵sȂȂB
 *  W[ׂJڂ⃊_CNgsȂꍇ́A
 *  &lt;forward&gt;vfgp邱ƁB
 * </p>
 *
 * <p>Bean`t@Cystruts-config.xml̋LqȉɎB</p>
 *
 * :<br>
 * <p>
 * <strong>Bean`t@C̐ݒ</strong>
 *  <code><pre>
 *  &lt;bean name="/foo" scope="prototype"
 *      <strong>class="jp.terasoluna.fw.web.struts.actions.ForwardAction"</strong>&gt
 *  &lt;/bean&gt
 *  </pre></code>
 * </p>
 * <p>
 * <strong>struts-config.xml̐ݒ</strong>
 * <code><pre>
 *  &lt;action path="/foo"
 *          parameter="/foo.jsp"&gt;
 *  &lt;/action&gt;
 * </pre></code>
 * ܂
 * <code><pre>
 *  &lt;action path="/foo"
 *          parameter="/foo.jsp"&gt;
 *    &lt;forward name="success" path="/foo.jsp" module="/sub1" redirect="true"&gt;
 *  &lt;/action&gt;
 * </pre></code>
 * </p>
 *
 */
public class ForwardAction extends ActionEx {

    /**
     * ONXB
     */
    private static Log log
              = LogFactory.getLog(ForwardAction.class);

    /**
     * G[y[Wi404jJڎsG[R[hB
     */
    private static final String FORWARD_ERRORPAGE_ERROR =
        "error.forward.errorpage";

    /**
     * Œ̘_tH[hB
     */
    private static final String FORWARD_SUCCESS = "success";

    /**
     * parameterɐݒ肳ꂽJڐ
     * ANVtH[hɃZbgĕԂB
     * parameterݒ肳ĂȂꍇA
     * Jڐ_tH[h"success"
     * ANVtH[h擾ĕԂB
     * ǂݒ肳ĂȂꍇ́Ai404jG[ԂB
     *
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @return Jڐ̃ANVtH[h
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping,
                                ActionForm form,
                                HttpServletRequest req,
                                HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            log.debug("doExecute() called.");
        }

        // parameteritH[hj擾
        String path = mapping.getParameter();

        // ANVtH[h𐶐
        ActionForward retVal = null;

        if (path == null) {

            // ActionMappingActionForward擾
            retVal = mapping.findForward(FORWARD_SUCCESS);

            // ActionFowardݒ肳ĂȂꍇ
            if (retVal == null) {
                // parameterAforwardvfƂɐݒ肳ĂȂꍇA
                // i404jG[ԋp
                try {
                    res.sendError(HttpServletResponse.SC_NOT_FOUND);
                } catch (IOException e) {
                    log.error("Error page(404) forwarding failed.");

                    throw new SystemException(e, FORWARD_ERRORPAGE_ERROR);
                }
                return null;
            }
			return retVal;
        }

        retVal = new ActionForward(path);

        return retVal;
    }
}
