/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.web.action;

import java.util.Map;

import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.thin.tutorial.service.blogic.ListBLogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ꗗ擾ANVB
 *
 * ꗗ擾rWlXWbNĂсAꗗ擾B
 *
 */
public class ListAction extends AbstractBLogicAction<Map<String, String>> {

    /**
     * ONXB
     */
    private Log log = LogFactory.getLog(ListAction.class);

    /**
     * srWlXWbNNXB
     */
    private ListBLogic listBLogic = null;

    /**
     * rWlXWbNԋpB
     *
     * @return ێrWlXWbN
     */
    public ListBLogic getListBLogic() {
        return listBLogic;
    }

    /**
     * rWlXWbNݒ肷B
     *
     * @param listBLogic rWlXWbN
     */
    public void setListBLogic(ListBLogic listBLogic) {
        this.listBLogic = listBLogic;
    }

    /**
     * rWlXWbNsAꗗ擾AԋpB
     *
     * @param map ꗗ擾̂߂̕ϐێMap
     * @return ꗗێBLogicResult
     * @throws Exception O
     */
    @Override
    public BLogicResult doExecuteBLogic(Map<String, String> map) 
        throws Exception {

        if (log.isDebugEnabled()) {
            log.debug("doExecuteBLogic Start.");
        }

        //rWlXWbN̎sAʂ̎擾
        Map<String, Object> retMap = listBLogic.getUserList(map);

        //BLogicResult̐Aʂ̐ݒ
        BLogicResult result = new BLogicResult();
        result.setResultString("success");
        result.setResultObject(retMap);

        return result;
    }

}
