/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.util.StringUtil;

/**
 * w肳ꂽtB[hɑ΂đIt̓͂
 * sJ_[͋@\B
 * 
 * <p>
 * ȉ̍ڂbZ[W\[Xt@CɋLq邱ƂŁA
 * J_[͋@\̐ݒύX邱ƂłB<br>
 * ȂAbZ[W\[Xt@ĆucalendarvŒƂB<br>
 * Fucalendar.propertiesvAucalendar_en.propertiesv<br>
 * </p>
 * <ul>
 *   <li>x`</li>
 * </ul>
 * <div style="text-align: center;">
 * <table style="width:90%;border:1pt;" frame="box">
 *   <tr>
 *     <td style="font-weight:bold;width:60px;">@\ڍ</td>
 *     <td style="text-align: left;">
 *       bZ[W\[Xt@CɈȉ̂悤ɋLq邱Ƃ
 *       J_[̋xw肷邱ƂłB
 *       bZ[W\[XL[́Aucalendar.holiday.vŒƂāA
 *       ̌ɁAu1vAԂU邱ƂƂB
 *       p[^́AuNvuvuvuxTvvu,(J})v
 *       ؂ċLq邱ƂƂB
 *       Nt̋x`́uNvu0v
 *       w肷邱ƂŖNƔFB
 *     </td>
 *   </tr>
 *   <tr>
 *     <td style="font-weight:bold;">ݒ</td>
 *     <td style="text-align: left;">
 *       calendar.holiday.1=0,1,1,U<br/>
 *       calendar.holiday.2=0,2,11,LO<br/>
 *       calendar.holiday.3=0,4,29,݂ǂ̓<br/>
 *       calendar.holiday.4=2005,1,10,l̓<br/>
 *       calendar.holiday.5=2005,3,20,t̓<br/>
 *       calendar.holiday.6=2005,9,19,hV̓<br/>
 *       calendar.holiday.7=2005,9,23,H̓<br/>
 *       calendar.holiday.8=2005,10,10,̈̓<br/>
 *     </td>
 *   </tr>
 * </table>
 * </div>
 * <br/>
 * <ul>
 *   <li>{^\ύX</li>
 * </ul>
 * <div style="text-align: center;">
 * <table style="width:90%;border:1pt;" frame="box">
 *   <tr>
 *     <td style="font-weight:bold;width:60px;">@\ڍ</td>
 *     <td style="text-align: left;">
 *       bZ[W\[Xt@CɈȉ̂悤ɋLq邱Ƃ
 *       J_[\{^̕ύX邱ƂłB
 *       bZ[W\[XL[́Aucalendar.button.stringvŒƂB
 *       ftHǵuCalendarvƂȂB
 *     </td>
 *   </tr>
 *   <tr>
 *     <td style="font-weight:bold;">ݒ</td>
 *     <td style="text-align: left;">
 *       calendar.button.string=J_[
 *     </td>
 *   </tr>
 * </table>
 * </div>
 * <br/>
 * <ul>
 *   <li>X^CvtBbNXύX</li>
 * </ul>
 * <div style="text-align: center;">
 * <table style="width:90%;border:1pt;" frame="box">
 *   <tr>
 *     <td style="font-weight:bold;width:60px;">@\ڍ</td>
 *     <td style="text-align: left;">
 *       bZ[W\[Xt@CɈȉ̂悤ɋLq邱Ƃ
 *       J_[ɂĎgpX^CV[g̃vtBbNXA
 *       щ摜t@C̃vtBbNXύX邱ƂłB
 *       <br/>
 *       bZ[W\[XL[́Aucalendar.style.themeprefixvŒƂB
 *       ftHǵuBlueStylevƂȂB
 *     </td>
 *   </tr>
 *   <tr>
 *     <td style="font-weight:bold;">ݒ</td>
 *     <td style="text-align: left;">
 *       calendar.style.themeprefix=BlueStyle
 *     </td>
 *   </tr>
 * </table>
 * </div>
 * <br/>
 * <ul>
 *   <li>ݓt\ύX</li>
 * </ul>
 * <div style="text-align: center;">
 * <table style="width:90%;border:1pt;" frame="box">
 *   <tr>
 *     <td style="font-weight:bold;width:60px;">@\ڍ</td>
 *     <td style="text-align: left;">
 *       bZ[W\[Xt@CɈȉ̂悤ɋLq邱Ƃ
 *       J_[̉ɕ\錻ݓtɕt^镶
 *       ύX邱ƂłB
 *       <br/>
 *       bZ[W\[XL[́Aucalendar.today.stringvŒƂB
 *       ftHǵuToday is vƂȂB
 *     </td>
 *   </tr>
 *   <tr>
 *     <td style="font-weight:bold;">ݒ</td>
 *     <td style="text-align: left;">calendar.today.string=Today is </td>
 *   </tr>
 * </table>
 * </div>
 * <br/>
 * <ul>
 *   <li>J_[摜ۑꏊύX</li>
 * </ul>
 * <div style="text-align: center;">
 * <table style="width:90%;border:1pt;" frame="box">
 *   <tr>
 *     <td style="font-weight:bold;width:60px;">@\ڍ</td>
 *     <td style="text-align: left;">
 *       bZ[W\[Xt@CɈȉ̂悤ɋLq邱Ƃ
 *       J_[͋@\ɂĎgp摜̕ۑꏊύX邱ƂłB
 *       Ṓu/vŏIKvB
 *       摜̕ۑꏊ͕ύX\A摜t@C̖O͕ύX邱ƂłȂB
 *       <br/>
 *       bZ[W\[XL[́Aucalendar.img.dirvŒƂB
 *       ftHǵuimg/calendar/vƂȂB
 *     </td>
 *   </tr>
 *   <tr>
 *     <td style="font-weight:bold;">ݒ</td>
 *     <td style="text-align: left;">calendar.img.dir=image/</td>
 *   </tr>
 * </table>
 * </div>
 * <br/>
 * <ul>
 *   <li>X^CV[gۑꏊύX</li>
 * </ul>
 * <div style="text-align: center;">
 * <table style="width:90%;border:1pt;" frame="box">
 *   <tr>
 *     <td style="font-weight:bold;width:60px;">@\ڍ</td>
 *     <td style="text-align: left;">
 *       bZ[W\[Xt@CɈȉ̂悤ɋLq邱Ƃ
 *       J_[͋@\ɂĎgpX^CV[g̕ۑꏊ
 *       ύX邱ƂłBṒu/vŏIKvB
 *       ̋@\ŎgpX^CV[g̃t@ĆA
 *       u<vtBbNX> + InputCalendar.cssvłB
 *       <br/>
 *       bZ[W\[XL[́Aucalendar.stylesheet.dirvŒƂB
 *       ftHǵucss/vƂȂB
 *     </td>
 *   </tr>
 *   <tr>
 *     <td style="font-weight:bold;">ݒ</td>
 *     <td style="text-align: left;">calendar.stylesheet.dir=style/</td>
 *   </tr>
 * </table>
 * </div>
 * <br/>
 * <ul>
 *   <li>OJavaScriptt@CۑꏊύX</li>
 * </ul>
 * <div style="text-align: center;">
 * <table style="width:90%;border:1pt;" frame="box">
 *   <tr>
 *     <td style="font-weight:bold;width:60px;">@\ڍ</td>
 *     <td style="text-align: left;">
 *       bZ[W\[Xt@CɈȉ̂悤ɋLq邱Ƃ
 *       J_[͋@\ɂĎgpOJavaScript̕ۑꏊ
 *       ύX邱ƂłBṒu/vŏIKvB
 *       ̋@\ŎgpJavaScript̃t@ĆA
 *       uInputCalendar.jsvłB
 *       <br/>
 *       bZ[W\[XL[́Aucalendar.javascript.dirvŒƂB
 *       ftHǵujs/vƂȂB
 *     </td>
 *   </tr>
 *   <tr>
 *     <td style="font-weight:bold;">ݒ</td>
 *     <td style="text-align: left;">calendar.javascript.dir=javascript/</td>
 *   </tr>
 * </table>
 * </div>
 * <p/>
 * <strong>J_[͋@\̎gp</strong>
 * <p>
 * ȉ̂悤ɁA̓tB[hƑ΂ƂȂ悤ɋLqB
 * J_[͋@\forɂ́AΏۂƂȂ̓tB[h̖O
 * w肷Bȉ̗ł́Atextvfproperty̓tB[h
 * OƂȂ邽߁Aforɂ́AtextvfpropertyƓl
 * w肷B
 * </p>
 * <code>
 *   &lt;html:text property="value" /&gt;<br>
 *   &lt;t:inputCalendar for="value" format="yyyy-MM-dd" /&gt;
 * </code>
 * <br/>
 * <p/>
 * <strong>^OT|[g鑮</strong>
 * <p>
 * J_[͋@\ł́Aȉ̑T|[gB
 * </p>
 * <div align="center">
 *  <table width="90%" border="1">
 *   <tr>
 *    <td><b></b></td>
 *    <td><b>ftHgl</b></td>
 *    <td><b>K{</b></td>
 *    <td><b>s</b></td>
 *    <td><b>Tv</b></td>
 *   </tr>
 *   <tr>
 *    <td><code>for</code></td>
 *    <td><code>-</code></td>
 *    <td><code>true</code></td>
 *    <td><code>true</code></td>
 *    <td style="text-align: left;">
 *      It͂̓tB[hw肷B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>format</code></td>
 *    <td><code>yyyy/MM/dd</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td style="text-align: left;">
 *      J_[̃tH[}bgw肷B<br/>
 *      włt`́uy(N)vuM()vud()vA
 *      ؕƂẮu/vu-vu.vupXy[Xv
 *      ̂ꂩłB܂A؂蕶́Aꕶ݂̂gp邱ƁB
 *      uyyyy/MM-ddv̂悤ɕ̋؂蕶gp邱Ƃ͂łȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>formatKey</code></td>
 *    <td><code>-</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td style="text-align: left;">
 *      J_[̃tH[}bgbZ[W\[X
 *      擾邽߂̃L[lw肷B
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 * <p/>
 * 
 */
public class InputCalendarTag extends TagSupport {

    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -3163804374592471898L;

	/**
     * ΉeLXgtB[hw葮B
     * It͂tB[hw肷B
     */
    private String forId = null;

    /**
     * tH[}bgw葮B
     * tB[hɓ͂t̃tH[}bgw肷B
     * uyvuMvudv3gpB
     * ؂蕶́u/vu-vu.vu v̂Sgp\łB
     */
    private String format = CALENDAR_DEFAULT_FORMAT;

    /**
     * tH[}bgL[w葮B
     * tB[hɓ͂t̃tH[}bg
     * bZ[W\[X̃L[w肷B
     */
    private String formatKey = null;

    /**
     * ΉeLXgtB[hw葮̒lԋpB
     * @return ΉeLXgtB[hw葮̒l
     */
    public String getFor() {
        return forId;
    }

    /**
     * ΉeLXgtB[hw葮̒lݒ肷B
     * @param forId ݒ肷l
     */
    public void setFor(String forId) {
        this.forId = forId;
    }

    /**
     * tH[}bgw葮̒lԋpB
     * @return tH[}bgw葮̒l
     */
    public String getFormat() {
        return format;
    }

    /**
     * tH[}bgw葮̒lݒ肷B
     * @param format ݒ肷l
     */
    public void setFormat(String format) {
        this.format = format;
    }

    /**
     * tH[}bgL[w葮̒lԋpB
     * @return tH[}bgL[w葮̒l
     */
    public String getFormatKey() {
        return formatKey;
    }

    /**
     * tH[}bgL[w葮̒lݒ肷B
     * @param formatKey ݒ肷l
     */
    public void setFormatKey(String formatKey) {
        this.formatKey = formatKey;
    }

    /**
     * J_[͋@\ɂĎgpJ_[摜ۑꏊ
     * bZ[W\[X擾邽߂̎擾L[B
     */
    protected static final String
        CALENDAR_IMG_DIR = "calendar.img.dir";

    /**
     * J_[͋@\ɂĎgp錻ݓtt^
     * bZ[W\[X擾邽߂̎擾L[B
     */
    protected static final String
        CALENDAR_TODAY_STRING = "calendar.today.string";

    /**
     * J_[͋@\ɂĎgp{^\
     * bZ[W\[X擾邽߂̎擾L[B
     */
    protected static final String
        CALENDAR_BUTTON_VALUE = "calendar.button.value";

    /**
     * J_[͋@\ɂĎgpX^CvtBbNX
     * bZ[W\[X擾邽߂̎擾L[B
     */
    protected static final String
        CALENDAR_STYLE_THEMEPREFIX = "calendar.style.themeprefix";

    /**
     * J_[͋@\ɂĎgpX^CV[gۑꏊ
     * bZ[W\[X擾邽߂̎擾L[B
     */
    protected static final String
        CALENDAR_STYLESHEET_DIR = "calendar.stylesheet.dir";

    /**
     * J_[͋@\ɂĎgpJ_[OJavaScriptۑꏊ
     * bZ[W\[X擾邽߂̎擾L[B
     */
    protected static final String
        CALENDAR_JAVASCRIPT_DIR = "calendar.javascript.dir";

    /**
     * J_[͋@\ɂĎgpx`
     * bZ[W\[X擾邽߂̎擾L[B
     */
    protected static final String
        CALENDAR_HOLIDAY_PREFIX = "calendar.holiday";

    /**
     * ftHg̃tH[}bgB
     */
    protected static final String
        CALENDAR_DEFAULT_FORMAT = "yyyy/MM/dd";

    /**
     * ftHgX^CvtBbNXB
     */
    protected static final String
        CALENDAR_DEFAULT_STYLEPREFIX_NAME = "BlueStyle";

    /**
     * ftHg̉摜ۑꏊpXB
     */
    protected static final String
        CALENDAR_DEFAULT_IMAGE_PATH = "img/calendar/";

    /**
     * ftHg̃J_[{^\B
     */
    protected static final String
        CALENDAR_DEFAULT_BUTTON_VALUE = "Calendar";

    /**
     * ftHg̃X^CV[gۑꏊB
     */
    protected static final String
        CALENDAR_DEFAULT_STYLESHEET_DIR = "css/";

    /**
     * ftHg̃J_[OJavaScriptۑꏊB
     */
    protected static final String
        CALENDAR_DEFAULT_JAVASCRIPT_DIR = "js/";

    /**
     * J_[͋@\ĎgpJavaScript̃t@CB
     */
    protected static final String
        CALENDAR_JAVASCRIPT_FILE_NAME = "InputCalendar.js";

    /**
     * J_[͋@\ĎgpX^CV[g̃t@C(vtBbNX)B
     */
    protected static final String
        CALENDAR_STYLESHEET_FILE_NAME = "InputCalendar.css";

    /**
     * o͏ԃtOL[B
     */
    protected static final String
        INPUTCALENDAR_FLG = "InputCalendarFlg";

    /**
     * ΉĂtH[}bgQB
     */
    protected static final String
        FORMAT_VALUE = "yMd ./-";

    /**
     * ^O]JnɌĂ΂郁\bhB
     * ۉΉ̂߂̓@\p̃\[Xoh擾B
     * @\gp邽߂JavaScriptу{^̏o͂sB
     * 
     * @return w
     * @exception JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        //\[Xoh
        ResourceBundle calendarBundle = null;

        //P[擾
        Locale locale = pageContext.getRequest().getLocale();

        //J_[͋@\p̃\[Xoh擾B
        try {
            calendarBundle
                = ResourceBundle.getBundle("calendar", locale);
        } catch (MissingResourceException e) {
            //bZ[W\[Xݒ肳ĂȂꍇ͉ȂB
            //KvȒlftHggpB
        }

        //J_[͋@\̗vfLqĂĂA
        //JavaScript`JSPňxo͂Ao͂ȂB
        //o͂pageContextɃtO𗧂ĂĔfB
        if (!getPageContextFlg(pageContext, INPUTCALENDAR_FLG)) {
            //J_[͋@\ŎgpJavaScript`̏o
            defineJavaScript(calendarBundle);

            //xo͂̂ŃtO𗧂ĂB
            setPageContextFlg(pageContext, INPUTCALENDAR_FLG);
        }

        //J_[ʂo͂邽߂̃{^o͂B
        defineButton(calendarBundle);

        return SKIP_BODY;
    }

    /**
     * JavaScript̒`o͂B
     * {ꃍP[tOAݓttAX^CvtBbNXA
     * J_[摜ꏊwAJ_[X^CV[gꏊwA
     * J_[JavaScriptꏊw̏o͂sB
     * ܂AX^CV[g&lt;link&gt;vfA
     * J_[͋@\&lt;script&gt;vf̏o͂sB
     * 
     * @param calendarBundle J_[͋@\p\[Xoh
     * @throws JspException JSPO
     */
    protected void defineJavaScript(ResourceBundle calendarBundle)
            throws JspException {

        //P[̎擾
        Locale currentLocale = pageContext.getRequest().getLocale();

        //{ꃍP[tO
        boolean jpFlg = false;
        if ((Locale.JAPAN.getLanguage()).equals(currentLocale.getLanguage())) {
            jpFlg = true;
        }

        //DateFormatSymbols̐сAP[ɑΉjA̎擾sB
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] weekdays = mapWeekdays(symbols);
        String[] months = mapMonths(symbols);

        //ݓttbZ[W\[X擾B
        String todayString = getParameter(calendarBundle,
                CALENDAR_TODAY_STRING, "");

        //X^CvtBbNXbZ[W\[X擾B
        String styleThemePrefix = getParameter(calendarBundle,
                CALENDAR_STYLE_THEMEPREFIX, CALENDAR_DEFAULT_STYLEPREFIX_NAME);

        //J_[摜ꏊwbZ[W\[X擾B
        String imageDir = getParameter(calendarBundle, CALENDAR_IMG_DIR,
                CALENDAR_DEFAULT_IMAGE_PATH);
        imageDir = imageDir + styleThemePrefix + "/";

        //J_[X^CV[gꏊwbZ[W\[X擾B
        String styleFileName = styleThemePrefix + CALENDAR_STYLESHEET_FILE_NAME;
        String styleSheetDir = getParameter(calendarBundle,
                CALENDAR_STYLESHEET_DIR, CALENDAR_DEFAULT_STYLESHEET_DIR);

        //J_[JavaScriptꏊwbZ[W\[X擾B
        String javaScriptFileName = CALENDAR_JAVASCRIPT_FILE_NAME;
        String javaScriptDir = getParameter(calendarBundle,
                CALENDAR_JAVASCRIPT_DIR, CALENDAR_DEFAULT_JAVASCRIPT_DIR);

        //scriptvf̊Jn^Oo
        TagUtil.writeln(
                pageContext, "<script type=\"text/javascript\">");
        TagUtil.writeln(pageContext, "<!--");

        //{ꃍP[tȌo
        TagUtil.writeln(pageContext, 
                defineObjectVariable("localja", String.valueOf(jpFlg)));

        //Xg̏o
        TagUtil.writeln(pageContext, 
                defineArrayVariable("jscalendarMonthName", months));

        //jXg̏o
        TagUtil.writeln(pageContext, 
                defineArrayVariable("jscalendarDayName", weekdays));

        //ݓtt̏o
        TagUtil.writeln(pageContext, 
                defineStringVariable("jscalendarTodayString",
                todayString));

        //X^CvtBbNX̏o
        TagUtil.writeln(pageContext, 
                defineStringVariable("jscalendarThemePrefix",
                styleThemePrefix));

        //J_[摜ꏊw̏o
        TagUtil.writeln(pageContext, 
                defineStringVariable("jscalendarImgDir", imageDir));

        //scriptvf̕^Oo
        TagUtil.writeln(pageContext, "-->");
        TagUtil.writeln(pageContext, "</script>");

        //J_[͋@\JavaScriptOt@C
        //荞scriptvf̏o
        TagUtil.write(pageContext, "<script type=\"text/javascript\" src=\"");
        TagUtil.write(pageContext, javaScriptDir);
        TagUtil.write(pageContext, javaScriptFileName);
        TagUtil.writeln(pageContext, "\" ></script>");

        //J_[͋@\̊OX^CV[g
        //荞݂slinkvf̏o
        TagUtil.writeln(pageContext, 
                "<link rel=\"stylesheet\" href=\"" + styleSheetDir
                + styleFileName + "\"  type=\"text/css\"/>");

        //scriptvf̊Jn^Oo
        TagUtil.writeln(pageContext,
                "<script type=\"text/javascript\">");
        TagUtil.writeln(pageContext, "<!--");

        //x`擾B
        List<Map<String, String>> holidays = getHolidayList(calendarBundle);

        //擾x`o
        for (int i = 0; i < holidays.size() ; i++) {
            Map<String, String> map = holidays.get(i);
            TagUtil.write(pageContext, "jscalendarAddHoliday('");
            TagUtil.write(pageContext, map.get("year"));
            TagUtil.write(pageContext, "', '");
            TagUtil.write(pageContext, map.get("month"));
            TagUtil.write(pageContext, "', '");
            TagUtil.write(pageContext, map.get("day"));
            TagUtil.write(pageContext, "', '");
            TagUtil.write(pageContext, map.get("desc"));
            TagUtil.writeln(pageContext, "');");
        }
        TagUtil.writeln(pageContext, "");

        //JavaScript̏sscriptvf̏o
        TagUtil.writeln(pageContext, "jscalendarInit();");

        //scriptvf̕^Oo
        TagUtil.writeln(pageContext, "-->");
        TagUtil.writeln(pageContext, "</script>");

    }

    /**
     * bZ[W\[Xɒ`ꂽx`擾B
     * 
     * @param calendarBundle J_[͋@\p\[Xoh
     * @return 擾x`Xg
     */
    protected List<Map<String, String>> getHolidayList(
            ResourceBundle calendarBundle) {

        //x`Xg
        List<Map<String, String>> holidays
            = new ArrayList<Map<String, String>>();

        if (calendarBundle == null) {
            return holidays;
        }

        //擾L[l`Ăx擾B
        //x`@
        //ucomponent.calendar.holiday.1=2004,11,23,ΘJӂ̓v
        //̂悤ɁuNvuvuvuTvvu,vŋLq邱ƁB
        for (int i = 1; ; i++) {

            //`ێMAP
            Map<String, String> map = new HashMap<String, String>();

            //bZ[W\[XL[̐
            String key = CALENDAR_HOLIDAY_PREFIX + "." + i;

            //bZ[W\[XL[p[^擾B
            String param = null;
            try {
                param = calendarBundle.getString(key);
            } catch (MissingResourceException e) {
                //NULL̏ꍇ͂ȏ`Ȃ̂Ƃă[vI
                break;
            }

            //PARAM擾łꍇ́u,vɕB
            String[] paramSprit = param.split(",");

            //A4ɕĂȂΈȉ̍ƂsȂB
            if (paramSprit.length != 4) {
                continue;
            }

            //`Ăꍇ́AMAPɊi[āA`XgɊi[B
            map.put("year",  StringUtil.trim(paramSprit[0]));
            map.put("month", StringUtil.trim(paramSprit[1]));
            map.put("day",   StringUtil.trim(paramSprit[2]));
            map.put("desc",  StringUtil.trim(paramSprit[3]));
            holidays.add(map);

        }

        //x`XgԋpB
        return holidays;

    }

    /**
     * J_[ʂ\邽߂̃{^o͂B
     *
     * @param calendarBundle J_[͋@\p\[Xoh
     * @throws JspException JSPO
     */
    protected void defineButton(ResourceBundle calendarBundle)
            throws JspException {

        //ttH[}bg
        String dateFormat = null;

        //^OɂĎw肳ꂽttH[}bg擾āA
        //JSt@CɂđΉĂ^ۂ肷B
        //܂AttH[}bg擾łAttH[}bgL[
        //w肳Ăꍇ̓L[p[^擾Ă
        //JSt@CɑΉĂ邩sB
        if (formatKey != null) {
            dateFormat = createFormat(getParameter(calendarBundle, formatKey,
                    CALENDAR_DEFAULT_FORMAT));
        } else {
            dateFormat = createFormat(format);
        }

        //{^\̎擾
        String buttonValue = getParameter(calendarBundle,
                CALENDAR_BUTTON_VALUE, 
                CALENDAR_DEFAULT_BUTTON_VALUE);

        TagUtil.writeln(pageContext, 
                "<input type=\"button\" onclick=\""
                + "jscalendarPopUpCalendar(this,this.form.elements['"
                + forId + "'],'" + dateFormat + "');\" value=\""
                + buttonValue + "\" />");
    }

    /**
     * bZ[W\[XL[ɒl擾ĕԋpB
     * L[null܂͋󔒂̏ꍇA擾lnull̏ꍇ
     * ftHglԋpB
     * @param calendarBundle J_[͋@\p\[Xoh
     * @param key bZ[W\[X̃L[
     * @param def ftHgƂȂl
     * @return bZ[W\[X擾lA܂̓ftHgl
     */
    protected String getParameter(ResourceBundle calendarBundle,
            String key, String def) {

        if (calendarBundle == null || key == null || "".equals(key)) {
            return def;
        }

        String retValue = null;

        //擾\[XohL[Ƃɒl擾B
        try {
            retValue = calendarBundle.getString(key);
        } catch (MissingResourceException e) {
            //w肳ꂽL[݂Ȃ߃ftHgԋpB
            return def;
        }

        return retValue;
    }

    /**
     * ɂēnꂽl<code>JavaScript</code>
     * <code>String</code>錾ƂĕԋpB<br>
     * Fϐu<code>kanji</code>vAluv
     * u<code>var kanji = "";\n</code>vƂȂB
     * 
     * @param name <code>JavaScript</code>Ő錾ϐ
     * @param value ϐ̒l
     * @return ҏW㕶
     */
    protected String defineStringVariable(String name, String value) {
        StringBuilder retValue = new StringBuilder("var ");
        retValue.append(name);
        retValue.append(" = \"");
        retValue.append(value);
        retValue.append("\";");
        return retValue.toString();
    }

    /**
     * ɂēnꂽl<code>JavaScript</code>
     * <code>Object</code>錾ƂāAԋpB<br>
     * Fϐu<code>obj1</code>vA
     * lu<code>document.forms[0]</code>v
     * ˁu<code>var obj1 = document.forms[0];\n</code>vƂȂB
     * 
     * @param name <code>JavaScript</code>Ő錾ϐ
     * @param value ϐ̒l
     * @return ҏW㕶
     */
    protected String defineObjectVariable(String name, String value) {
        StringBuilder retValue = new StringBuilder("var ");
        retValue.append(name);
        retValue.append(" = ");
        retValue.append(value);
        retValue.append(";");
        return retValue.toString();
    }

    /**
     * ɂēnꂽz<code>JavaScript</code>
     * <code>Array</code>^ƂĕҏWĕԋpB<br>
     * Fϐu<code>array</code>vAlu<code>10,20,30</code>v
     * ˁu<code>var obj1 = new Array("10","20","30");\n</code>v<br>
     * ȂAarraynull̏ꍇ́ANullPointerExceptionB
     * 
     * @param arrayName <code>JavaScript</code>Ő錾ϐ
     * @param array <code>Array</code>Ƃč쐬lێz
     * @return ҏW㕶
     */
    protected String defineArrayVariable(String arrayName, String[] array) {
        StringBuilder retValue = new StringBuilder("var ");
        retValue.append(arrayName);
        retValue.append(" = new Array(");
        for (int i = 0; i < array.length; i++) {
            if (i != 0) {
                retValue.append(",");
            }
            retValue.append("\"");
            retValue.append(array[i]);
            retValue.append("\"");
        }
        retValue.append(");");
        return retValue.toString();
    }

    /**
     * w肳ꂽf[gtH[}bgV{ujv擾ĕԋpB
     * 
     * @param symbols f[gtH[}bgV{(P[ݒς)
     * @return 擾ujvi[z
     */
    protected String[] mapWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[Calendar.SUNDAY];
        weekdays[1] = localeWeekdays[Calendar.MONDAY];
        weekdays[2] = localeWeekdays[Calendar.TUESDAY];
        weekdays[3] = localeWeekdays[Calendar.WEDNESDAY];
        weekdays[4] = localeWeekdays[Calendar.THURSDAY];
        weekdays[5] = localeWeekdays[Calendar.FRIDAY];
        weekdays[6] = localeWeekdays[Calendar.SATURDAY];
        return weekdays;
    }

    /**
     * w肳ꂽf[gtH[}bgV{uv擾ĕԋpB
     * 
     * @param symbols f[gtH[}bgV{(P[ݒς)
     * @return 擾uvi[z
     */
    protected String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0]  = localeMonths[Calendar.JANUARY];
        months[1]  = localeMonths[Calendar.FEBRUARY];
        months[2]  = localeMonths[Calendar.MARCH];
        months[3]  = localeMonths[Calendar.APRIL];
        months[4]  = localeMonths[Calendar.MAY];
        months[5]  = localeMonths[Calendar.JUNE];
        months[6]  = localeMonths[Calendar.JULY];
        months[7]  = localeMonths[Calendar.AUGUST];
        months[8]  = localeMonths[Calendar.SEPTEMBER];
        months[9]  = localeMonths[Calendar.OCTOBER];
        months[10] = localeMonths[Calendar.NOVEMBER];
        months[11] = localeMonths[Calendar.DECEMBER];
        return months;
    }

    /**
     * w肳ꂽKEYɂĎ擾l^UlɕϊĕԋpB
     * ȂAkeynull̏ꍇ́ANullPointerExceptionB
     * 
     * @param pageContext y[WReLXg
     * @param key FLG擾KEY
     * @return w肳ꂽKEYɂĎ擾o͏ԃtO
     */
    protected boolean getPageContextFlg(
            PageContext pageContext, String key) {
        //y[WReLXgtO擾B
        Object obj = pageContext.getAttribute(key);
        Boolean bol = Boolean.valueOf(false);
        if (obj != null && obj instanceof Boolean) {
           bol = (Boolean) obj;
        }
        return bol.booleanValue();
    }

    /**
     * y[WReLXgɑ΂āAw肳ꂽKEỸtOݒ肷B
     * ȂAkeynull̏ꍇ́ANullPointerExceptionB
     * 
     * @param pageContext y[WReLXg
     * @param key FLGݒ肷KEY
     */
    protected void setPageContextFlg(
            PageContext pageContext, String key) {
        //y[WReLXgɃtO𗧂ĂB
        pageContext.setAttribute(key, Boolean.valueOf(true));
    }

    /**
     * ̕ɑ΂ăf[gtH[}bg̐sB
     * <code>null</code>A܂͋󔒂̏ꍇ́A
     * ̂܂ܕԋpB
     * ܂A񂪃f[gtH[}bgɑΉĂȂꍇ́AB
     * 
     * @param format f[gtH[}bg
     * @return ̃tH[}bg
     */
    protected String createFormat(String format) {

        //NULL̏ꍇ́AftHg̃f[gtH[}bgƂB
        if (format == null || "".equals(format)) {
            return CALENDAR_DEFAULT_FORMAT;
        }

        //ꕶÑΉ镶ۂmFB
        //ΉĂȂꍇ́ArĂԋpB
        StringBuilder retValue = new StringBuilder("");
        for (int i = 0; i < format.length(); i++) {
            char c = format.charAt(i);
            if (FORMAT_VALUE.indexOf(String.valueOf(c)) != -1) {
                retValue.append(c);
            }
        }

        //ʂԋpB
        return StringUtil.trim(retValue.toString());

    }

    /**
     * ׂẴAP[gꂽB
     */
    @Override
    public void release() {
        super.release();
        forId = null;
        format = CALENDAR_DEFAULT_FORMAT;
        formatKey = null;
    }

}
