/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;

/**
 * MessageResourcesDAO̎NXB
 * 
 * DBMessageResourcesFactorybZ[W\[Xt@NgNXƂ
 * pꍇADBMessageResourcesMessageResourcesDAONX
 * gpBڍׂ{@link DBMessageResources}QƂ̂ƁB
 *
 * <h5>gp@</h5>
 * DBMessageResourcesDAOImplSpringt[[N𗘗płB
 * Strutst[[ÑA[LeN`łDIRei擾p
 * Ȃ߁Af[^\[X̒`pɍsKvB<br>
 * DBANZXɕKvȃf[^\[X̒`dbMessageResources.xmlƂO
 * Bean`t@CɉL̂悤ɒ`ANXpXɒuAȉ̂悤ɏB<br>
 * Bean`t@CBLogicȂǂ̐ݒɗp̂Ƃ͕ʂɗpӂ邱ƁB<br>
 * <strong>JNDIf[^\[X擾ꍇ</strong><br>
 * <pre><code>
 * &lt;bean id="sampleDataSource" 
 *       class="org.springframework.jndi.JndiObjectFactoryBean" 
 *       abstract="false" scope="singleton" 
 *       lazy-init="default" 
 *       autowire="default" 
 *       dependency-check="default"&gt;
 *   &lt;property name="jndiName" 
 *             value="sampleJndiDataSource" /&gt; 
 * &lt;/bean&gt;
 * </code></pre>
 * evf̑̓VXeɂĈقȂ̂ŊmF邱ƁB<br>
 * <br>
 * <strong>JNDI𗘗pȂꍇ</strong><br>
 * <pre><code>
 * &lt;bean id="dataSource"
 *       class="org.springframework.jdbc.datasource.DriverManagerDataSource"&gt;
 *   &lt;property name="driverClassName"&gt;
 *     &lt;value&gt;oracle.jdbc.OracleDriver&lt;/value&gt;
 *   &lt;/property&gt;
 *   &lt;property name="url"&gt;
 *     &lt;value&gt;jdbc:oracle:thin:@192.0.34.166:1521:ORCL&lt;/value&gt;
 *   &lt;/property&gt;
 *   &lt;property name="username"&gt;&lt;value&gt;username&lt;/value&gt;&lt;/property&gt;
 *   &lt;property name="password"&gt;&lt;value&gt;password&lt;/value&gt;&lt;/property&gt;
 * &lt;/bean&gt;
 * </code></pre>
 * L̐ݒ̂A4̓VXeɂĈقȂ̂ŊmF邱ƁB
 * <ol>
 *   <li>hCoNXioracle.jdbc.OracleDriver̕j</li>
 *   <li>URLijdbc:oracle:thin:@192.0.34.166:1521:ORCL̕j</li>
 *   <li>[Uiusername̕j</li>
 *   <li>pX[hipassword̕j</li>
 * </ol>
 * 
 * ȂAWebAvP[VŎgpꍇ͊{IJNDIpق𐄏B
 * 
 */
public class MessageResourcesDAOImpl implements MessageResourcesDAO {

    /**
     * f[^\[X̒`ĂBean`t@CB
     */
    public static final String BEANS_XML
        = "dbMessageResources.xml";
    
    /**
     * f[^\[Xbean擾ۂidlB
     */
    private static final String DATASOURCE_BEAN_ID
        = "dataSource";
    
    /**
     * f[^\[X̎擾s\G[R[hB
     */
    private static final String MESSAGE_RESOURCES_DAO_IMPL_ERROR
        = "errors.message.resources.dao.impl";
    
    /**
     * ONXB
     */
    private static Log log 
        = LogFactory.getLog(MessageResourcesDAOImpl.class);
    
    /**
     * bZ[W\[X擾B
     * 
     * ^ꂽSQL̑JMap̃L[AJMap̒lƂ
     * ݒ肵MapԂB
     * SQLŕԂꂽʃZbg̑Jɏdꍇ́Aǂꂩ1
     * o^ĂȂMapԂB
     * 
     * @param sql bZ[W\[X擾邽߂SQL
     * 
     * @return L[ɃbZ[WL[AlɃbZ[W̓Map
     */
    @SuppressWarnings("unchecked")
	public Map<String, String> queryMessageMap(String sql) {
        
        if (log.isDebugEnabled()) {
            log.debug("call queryMessageMap()");
        }

        // f[^\[X̃IuWFNg𐶐DIRei𐶐
        ApplicationContext context = null;
        try {
            context = new ClassPathXmlApplicationContext(getBeansXml());
        } catch (BeansException e) {
            // t@CȂAXML\invalidłAȂ
            log.error(getBeansXml() + " not found or not " 
                      + "-//SPRING//DTD BEAN//EN or invalid or anything else.",
                      e);
            throw new SystemException(e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        
        // DIReif[^\[X擾
        DataSource ds = null;

        try {
            ds = (DataSource) context.getBean(DATASOURCE_BEAN_ID);
        } catch (NoSuchBeanDefinitionException e) {
            log.error("\"dataSource\" not defined.", e);
          throw new SystemException(e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        } catch (ClassCastException e) {
            log.error("\"dataSource\" not implemented DataSource.", e);
            throw new SystemException(e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        } catch (BeansException e) {
            log.error("getBean() failed", e);
            throw new SystemException(e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        
        // O/R}bsO
        DBMessageBeanMappingSqlQuery query
            = new DBMessageBeanMappingSqlQuery(ds, sql);
        
        try {
            query.compile();
        } catch (InvalidDataAccessApiUsageException e) {
            log.error("SQL is null or something wrong.", e);
            throw new SystemException(e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        
        List<DBMessageBean> dbMessageList = null;
        try {
            dbMessageList = query.execute();
        } catch (DataAccessException e) {
            log.error("Data access exception.", e);
            throw new SystemException(e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        
        if (log.isDebugEnabled()) {
            log.debug("db message acquired");
        }
        
        // bZ[W\[XMapɋlߑւ
        Map<String, String> dbMessages 
            = new HashMap<String, String>(dbMessageList.size());
        Iterator<DBMessageBean> iterator = dbMessageList.iterator();
        DBMessageBean dbmb = null;
        while (iterator.hasNext()) {
            dbmb = iterator.next();
            if (log.isDebugEnabled()) {
                log.debug("Saving db message key [" + dbmb.getKey() + "], "
                          + "value [" + dbmb.getValue() + "]");
            }
            dbMessages.put(dbmb.getKey(), dbmb.getValue());
        }
        return dbMessages;
    }

    /**
     * f[^\[X`ꂽBean`t@C擾B
     * 
     * @return f[^\[X`ꂽBean`t@C
     */
    protected String getBeansXml() {
        return BEANS_XML;
    }

}
