/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.util.Collections;
import java.util.List;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.object.MappingSqlQuery;


/**
 * R[hXg̏f[^x[XpčsA
 * {@link jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader}
 * NXłB
 *
 * <p>
 * ̃NXpăR[hXg𐶐ꍇ́A
 * dataSourceɎgpf[^\[Xw肵ƁA
 * init-methodloadw肵Aload()\bhŏɎsKvB
 * </p>
 *
 * <p>
 * R[hXgf[^x[X擾邽߂ SQL ́ABean`t@C
 * ݒ肷B
 * </p>
 * <p>
 * <strong>Bean`t@C̐ݒB</strong>
 * <br>
 * f[^\[XTerasolunaDataSourceƂĒ`ĂꍇB
 * </p>
 * <p>
 * <code><pre>
 * &lt;bean id=<strong>&quot;loader1&quot;</strong>
 *       class=&quot;jp.terasoluna.fw.web.codelist.DBCodeListLoader&quot;
 *       init-method=&quot;load&quot;&gt;
 *   &lt;property name=&quot;dataSource&quot;&gt;
 *     &lt;ref bean=<strong>&quot;TerasolunaDataSource&quot;</strong>/&gt;
 *   &lt;/property&gt;
 *   &lt;property name=&quot;sql&quot;&gt;
 *     &lt;value&gt;<strong>SELECT KEY, VALUE FROM CODE_LISTS</strong>&lt;/value&gt;
 *   &lt;/property&gt;
 *
 * &lt;/bean&gt;
 * </code></pre>
 * </p>
 *
 * <p>
 *  R[hXgi[NX CodeBean ́A
 *  id A name A
 *   SELECT Ŏw肳ꂽJ̏Ԃ CodeBean 
 *  i[B<br>
 *  Lł́A KEY  id A
 *   VALUE  name ̏ԂŊi[B<br>
 *  擾ꂽJ2ɖȂꍇAႦΏL
 *   KEY ̂ݎ擾ꍇ́A name 
 *   null i[B
 *   SELECT Ŏ擾J3ȏłƂ́A
 *  3߈ȍ~̃J͖B
 * </p>
 *
 * <p>
 *  SQL Ŏ擾ꂽʂ́AT[ubgReLXgɊi[A
 *  JSP ɂāA Struts &lt;logic:iterate&gt;
 *  ^O name A&lt;html:options&gt;^O
 *  collection beanƂĎQƂB<br>
 *  ȉ́Abean &quot;loader1&quot; ƂāA
 *  &lt;html:options&gt;  collectionɎw
 *  ꍇ̗łB
 * </p>
 * <strong>JSP ł̃R[hXggpB</strong><br>
 * <p>
 *  <code><pre>
 *  &lt;ts:defineCodeList id=<b>"loader1"</b> /&gt;
 *  c
 *  &lt;html:select property="selectOptions"&gt;
 *    &lt;html:options collection=<b>"loader1"</b>
 *                  labelProperty="name"
 *                  property="id"/&gt;
 *  &lt;/html:select&gt;
 *  </pre></code>
 * </p>
 * R[hXg̃[hɂẮA
 * {@link
 *  jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction}
 *
 * A܂R[hXgJSPł̎gp@́A
 * {@link
 *  jp.terasoluna.fw.web.taglib.DefineCodeListTag}
 * ƁA
 * {@link
 *  jp.terasoluna.fw.web.taglib.WriteCodeCountTag}
 * QƂ̂ƁB
 *
 * </p>
 * @see jp.terasoluna.fw.web.codelist.CodeBean
 * @see
 *    jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction
 * @see jp.terasoluna.fw.web.taglib.DefineCodeListTag
 * @see jp.terasoluna.fw.web.taglib.WriteCodeCountTag
 */
public class DBCodeListLoader implements ReloadableCodeListLoader {

    /**
     * ONXB
     */
    private Log log = LogFactory.getLog(DBCodeListLoader.class);

    /**
     * R[hXgB
     * @see jp.terasoluna.fw.web.codelist.CodeBean
     */
    private List<CodeBean> codeLists = null;
    
    /**
     * R[hXg擾邽߂SQLB
     */
    private String sql = null;

    /**
     * DBڑɎgpf[^\[XB
     */
    private DataSource dataSource = null;

    /**
     * R[hXgɎgp郍bNIuWFNgB
     */
    private final Object lockObject = new Object();

    /**
     * R[hXg̏sB
     *
     * <p>
     * {@link #loadCodeList()}gĊɐݒ肳Ă
     * dataSourceƎw肳ꂽSQLɃR[hXg𐶐B
     * R[hXgłɑ݂ꍇɂ́AsȂB
     * </p>
     */
    public void load() {
        if (log.isDebugEnabled()) {
            log.debug("load() called.");
        }
        if (codeLists != null) {
            // łɃR[hXgǂݍ܂ĂƂɂ͉ȂB
            return;
        }
        // R[hXgǂݍށB
        loadCodeList();
    }

    /**
     * R[hXg̍ēǂݍ݂sB
     *
     * <p>
     * codeLists̓{@link #loadCodeList()}
     * ĂяoB
     * </p>
     */
    public void reload() {
        if (log.isDebugEnabled()) {
            log.debug("reload() called.");
        }
        if (codeLists == null) {
            // codeLists݂Ȃꍇ͂̂܂loadCodeListĂԁB
            loadCodeList();
        } else {
            synchronized (lockObject) {
                // codeLists݂ꍇA
                // ǂݍݒɍēǂݍ݂hߓB
                loadCodeList();
            }
        }
    }

    /**
     * R[hXgǂݍށB
     *
     * dataSourceƎw肳ꂽSQLɃR[hXg𐶐B
     */
    @SuppressWarnings("unchecked")
	protected void loadCodeList() {
        if (log.isDebugEnabled()) {
            log.debug("loadCodeList() called.");
        }

        // f[^x[XlR[hXg擾B
        MappingSqlQuery query = new DBCodeListQuery(dataSource, sql);
        query.compile();
        List<CodeBean> resultList = query.execute();
        codeLists = Collections.unmodifiableList(resultList);
    }

    /**
     * R[hXg擾B
     *
     * R[hXg {@link CodeBean} ̔zƂĎ擾łB<br>
     * R[hXg͌ƂăAvP[VňӂƂȂłB
     * ̃\bhI[o[Chꍇ́AƖWbNȂǂ
     * R[hXg̓eҏWĂeȂ悤ɎKvB
     *
     * @return R[hXg
     */
    public CodeBean[] getCodeBeans() {
        if (codeLists == null) {
            // codeLists݂ȂƂ͋̔zԂB
            return new CodeBean[0];
        }
        CodeBean[] cb = new CodeBean[codeLists.size()];
        for (int i = 0; i < codeLists.size(); i++) {
            cb[i] = new CodeBean();
            cb[i].setId(codeLists.get(i).getId());
            cb[i].setName(codeLists.get(i).getName());
        }
        return cb;
    }

    /**
     * dataSource擾B
     *
     * @return dataSource \tB[hlB
     */
    public DataSource getDataSource() {
        return dataSource;
    }

    /**
     * dataSourceݒ肷B
     *
     * @param dataSource dataSource\tB[hlB
     */
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

	/**
	 * R[hXg擾SQL擾B
	 * @return SQL
	 */
    public String getSql() {
		return sql;
	}

	/**
	 * R[hXg擾SQLݒ肷B
	 * @param sql SQL
	 */
    public void setSql(String sql) {
		this.sql = sql;
	}

}
