/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

import org.apache.commons.beanutils.PropertyUtils;

/**
 * JX^^O@\Sʂɒʂ郆[eBeBNXB
 * 
 */
public class TagUtil {

    /**
     * XR[v}bvB
     */
    private static final Map<String, Integer> SCOPES = 
        new HashMap<String, Integer>();

    /**
     * XR[v}bv̐sB
     */
    static {
        SCOPES.put("application", PageContext.APPLICATION_SCOPE);
        SCOPES.put("session", PageContext.SESSION_SCOPE);
        SCOPES.put("request", PageContext.REQUEST_SCOPE);
        SCOPES.put("page", PageContext.PAGE_SCOPE);
    }

    /**
     * ̃XR[vƈvXR[v̒萔ԋpB
     * vXR[v݂Ȃꍇ͗O𔭐B
     * 
     * @param scopeName 擾萔̃XR[v
     * @return 擾XR[v̒萔
     * @throws JspException vXR[v݂Ȃꍇ
     */
    public static int getScope(String scopeName) throws JspException {

        if (scopeName == null) {
            throw new JspException();
        }

        Integer scope = SCOPES.get(scopeName.toLowerCase());

        if (scope == null) {
            throw new JspException();
        }

        return scope.intValue();
    }

    /**
     * w肳ꂽBeanw肳ꂽXR[v擾B
     * scopeNameNull̏ꍇPageScope擾B
     * 
     * @param pageContext y[WReLXg
     * @param name 擾Bean
     * @param scopeName Bean擾XR[v
     * @return 擾Bean
     * @throws JspException vXR[v݂Ȃꍇ
     */
    public static Object lookup(PageContext pageContext, String name,
            String scopeName)
            throws JspException {

        if (scopeName == null) {
            return pageContext.findAttribute(name);
        }

        return pageContext.getAttribute(name, getScope(scopeName));

    }

    /**
     * w肳ꂽBean擾ABean
     * w肳ꂽvpeBl擾B
     * ̃vpeBNull̏ꍇ͎擾BeanԋpB
     * Bean擾łȂꍇ́AO𔭐B
     *  
     * @param pageContext y[WReLXg
     * @param name 擾Bean
     * @param property BeañvpeB
     * @param scopeName Bean擾XR[v
     * @return 擾Bean
     * @throws JspException vXR[v݂Ȃꍇ,
     * w肳ꂽBean݂Ȃꍇ
     */
    public static Object lookup(PageContext pageContext, String name,
            String property, String scopeName) throws JspException {

        //w肳ꂽBean擾B
        Object bean = lookup(pageContext, name, scopeName);

        //BeanNull̏ꍇ͗OƂB
        if (bean == null) {
            throw new JspException();
        }

        //vpeBw肳ĂȂꍇ́ABeanԋpB
        if (property == null) {
            return bean;
        }

        //擾Beanw肳ꂽvpeB̒l擾B
        //OJspExceptionŃbvēB
        try {
            return PropertyUtils.getProperty(bean, property);

        } catch (IllegalAccessException e) {
            throw new JspException(e);
        } catch (IllegalArgumentException e) {
            throw new JspException(e);
        } catch (InvocationTargetException e) {
            throw new JspException(e);
        } catch (NoSuchMethodException e) {
            throw new JspException(e);
        }

    }

    /**
     * PageContextJspWriter擾āAw肳ꂽeLXgo͂B
     * sȂŁB
     * 
     * @param pageContext y[WReLXg
     * @param text o͂eLXg
     * @throws JspException
     * I/OG[ꍇIOExceptionbvO
     */
    public static void write(PageContext pageContext, String text)
            throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.print(text);
        } catch (IOException e) {
            throw new JspException(e);
        }
    }

    /**
     * PageContextJspWriter擾āAw肳ꂽeLXgo͂B
     * sŁB
     * 
     * @param pageContext y[WReLXg
     * @param text o͂eLXg
     * @throws JspException
     * I/OG[ꍇIOExceptionbvO
     */
    public static void writeln(PageContext pageContext, String text)
            throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.println(text);
        } catch (IOException e) {
            throw new JspException(e);
        }
    }

    /**
     * HTMLo͎ɃTj^CYsB
     * u<vu>vu&vu"vu'vuB
     * 
     * @param value Tj^CYΏە
     * @return ҏWςݕ
     */
    public static String filter(String value) {

        if (value == null) {
            return null;
        }

        char[] content = new char[value.length()];
        value.getChars(0, value.length(), content, 0);
        StringBuilder result = new StringBuilder();

        for (int i = 0; i < content.length; i++) {
            switch (content[i]) {
                case '<':
                    result.append("&lt;");
                    break;
                case '>':
                    result.append("&gt;");
                    break;
                case '&':
                    result.append("&amp;");
                    break;
                case '"':
                    result.append("&quot;");
                    break;
                case '\'':
                    result.append("&#39;");
                    break;
                default:
                    result.append(content[i]);
                    break;
            }
        }

        return result.toString();
    }

}
