/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.serverblockage.web;

import java.util.Date;
import java.util.List;

/**
 * @\ԗTvAP̃T[oǃRg[
 *
 * @version 2006/02/28
 */
public class ServerBlockageController implements
        jp.terasoluna.fw.web.thin.ServerBlockageController {

    /**
     * J
     */
    public static final int OPEN = 0;
    
    /**
     * \Ǐ
     */
    public static final int PRE_BLOCKADED = 1;
    
    /**
     * Ǐ
     */
    public static final int BLOCKADED = 2;
    
    /**
     * T[oǂĂĂʂpX
     */
    private List<String> alwaysOpenPaths = null;
    
    /**
     * T[oǏԂǂtO
     */
    private int state = OPEN;
    
    /**
     * ǏԂɑJڂ鎞
     */
    private Date blockadingDate = null;
    
    /**
     * T[oǂ
     *
     */
    public void blockade() {
        synchronized (this){
            state = BLOCKADED;
        }
    }

    /**
     * pXgȂ߁AI[o[[hꂽ\bhɈϏB
     *
     * @return
     */
    public boolean isBlockaded() {
        return isBlockaded(null);
    }

    /**
     * T[oǏԂ̏ꍇtrueԂAłȂꍇfalseԂ
     *
     * @param pathInfo
     * @return
     */
    public boolean isBlockaded(String pathInfo) {
        for (String path : alwaysOpenPaths) {
            if (path.equals(pathInfo)){
                return false;
            }
        }
        
        // T[ȍԂmFB
        if (state == BLOCKADED) {
            return true;
        }
        
        if (blockadingDate == null){
            return false;
        }
        
        synchronized (this) {
            if (blockadingDate != null) {
                Date now = new Date();
                // ǏԂɑJڂB
                if (blockadingDate.before(now)) {
                    state = BLOCKADED;
                }
            }
        }
        
        // T[ȍԂmFB
        if (state == BLOCKADED) {
            return true;
        }
        return false;
    }

    /**
     * \ǏԂ肷B
     *
     * @return
     */
    public boolean isPreBlockaded() {
        if (state == BLOCKADED || state == PRE_BLOCKADED){
            return true;
        }
        return false;
    }

    /**
     * T[oJB
     *
     */
    public void open() {
        synchronized (this) {
            state = OPEN;
        }
    }

    /**
     * T[o\ǏԂɂB
     *
     */
    public void preBlockade() {
        synchronized (this) {
            state = PRE_BLOCKADED;
        }
    }

    /**
     * T[o\ǏԂɂAw肳ꂽɕǂB
     *
     * @param time
     */
    public void preBlockade(Date time) {
        synchronized (this) {
            state = PRE_BLOCKADED;
            blockadingDate = time;
        }
    }

    /**
     * alwaysOpenPaths擾B
     * @return alwaysOpenPaths
     */
    public List<String> getAlwaysOpenPaths() {
        return alwaysOpenPaths;
    }

    /**
     * alwaysOpenPathsݒ肷B
     * @param alwaysOpenPaths alwaysOpenPathsB
     */
    public void setAlwaysOpenPaths(List<String> alwaysOpenPaths) {
        this.alwaysOpenPaths = alwaysOpenPaths;
    }
}
