/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class NullPropertyPointer
extends PropertyPointer {
    private String propertyName = "*";
    private boolean byNameAttribute = false;

    public NullPropertyPointer(NodePointer parent) {
        super(parent);
    }

    public QName getName() {
        return new QName(this.propertyName);
    }

    public void setPropertyIndex(int index) {
    }

    public int getLength() {
        return 0;
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getImmediateNode() {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, new QName(this.getPropertyName()));
    }

    protected boolean isActualProperty() {
        return false;
    }

    public boolean isActual() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public void setValue(Object value) {
        if (this.parent == null || this.parent.isContainer()) {
            throw new JXPathException("Cannot set property " + this.asPath() + ", the target object is null");
        }
        if (!(this.parent instanceof PropertyOwnerPointer) || !((PropertyOwnerPointer)this.parent).isDynamicPropertyDeclarationSupported()) {
            throw new JXPathException("Cannot set property " + this.asPath() + ", path does not match a changeable location");
        }
        PropertyPointer propertyPointer = ((PropertyOwnerPointer)this.parent).getPropertyPointer();
        propertyPointer.setPropertyName(this.propertyName);
        propertyPointer.setValue(value);
    }

    public NodePointer createPath(JXPathContext context) {
        NodePointer newParent = this.parent.createPath(context);
        if (this.isAttribute()) {
            return newParent.createAttribute(context, this.getName());
        }
        if (newParent instanceof PropertyOwnerPointer) {
            PropertyOwnerPointer pop = (PropertyOwnerPointer)newParent;
            newParent = pop.getPropertyPointer();
        }
        return newParent.createChild(context, this.getName(), this.getIndex());
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        NodePointer newParent = this.parent.createPath(context);
        if (this.isAttribute()) {
            NodePointer pointer = newParent.createAttribute(context, this.getName());
            pointer.setValue(value);
            return pointer;
        }
        if (newParent instanceof PropertyOwnerPointer) {
            PropertyOwnerPointer pop = (PropertyOwnerPointer)newParent;
            newParent = pop.getPropertyPointer();
        }
        return newParent.createChild(context, this.getName(), this.index, value);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        return this.createPath(context).createChild(context, name, index);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        return this.createPath(context).createChild(context, name, index, value);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setNameAttributeValue(String attributeValue) {
        this.propertyName = attributeValue;
        this.byNameAttribute = true;
    }

    public boolean isCollection() {
        return this.getIndex() != Integer.MIN_VALUE;
    }

    public int getPropertyCount() {
        return 0;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public String asPath() {
        if (!this.byNameAttribute) {
            return super.asPath();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getImmediateParentPointer().asPath());
        buffer.append("[@name='");
        buffer.append(this.escape(this.getPropertyName()));
        buffer.append("']");
        if (this.index != Integer.MIN_VALUE) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    private String escape(String string) {
        int index = string.indexOf(39);
        while (index != -1) {
            string = string.substring(0, index) + "&apos;" + string.substring(index + 1);
            index = string.indexOf(39);
        }
        index = string.indexOf(34);
        while (index != -1) {
            string = string.substring(0, index) + "&quot;" + string.substring(index + 1);
            index = string.indexOf(34);
        }
        return string;
    }
}

