/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.wiring;

import org.springframework.util.Assert;

public class BeanWiringInfo {
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    private String beanName = null;
    private int autowireMode = 0;
    private boolean dependencyCheck = false;

    public BeanWiringInfo(String beanName) {
        Assert.hasText(beanName, "'beanName' must not be empty");
        this.beanName = beanName;
    }

    public BeanWiringInfo(int autowireMode, boolean dependencyCheck) {
        if (autowireMode != 1 && autowireMode != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        this.autowireMode = autowireMode;
        this.dependencyCheck = dependencyCheck;
    }

    public boolean indicatesAutowiring() {
        return this.beanName == null;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public boolean getDependencyCheck() {
        return this.dependencyCheck;
    }
}

