/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.fw.web.rich.springmvc.controller.ErrorPageHandlingController;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.controller.ErrorPageHandlingController} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * web.xmlerror-pageݒɂOnhOsƂɎgpRg[B
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.controller.ErrorPageHandlingController
 */
public class ErrorPageHandlingControllerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ErrorPageHandlingControllerTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ErrorPageHandlingControllerTest(String name) {
        super(name);
    }

    /**
     * testHandleRequest01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *                (javax.servlet.error.exception={ExceptionIuWFNg}j<br>
     *         () response:not null<br>
     *         
     * <br>
     * ҒlF(߂l) -:ŕێĂExceptionIuWFNg<br>
     *         
     * <br>
     * handleRequest\bh̃eXgBNGXgŕێĂO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHandleRequest01() throws Exception {
        // O
        ErrorPageHandlingController controller = new ErrorPageHandlingController();
        Exception exception = new Exception();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("javax.servlet.error.exception", exception);
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        try {
            controller.handleRequest(request, response);
            fail();
        } catch(IllegalStateException e) {
            fail();
        } catch(Exception e) {
            assertSame(exception, e);
        }
    }

    /**
     * testHandleRequest02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *         
     * <br>
     * handleRequest\bh̃eXgBNGXgŕێĂOȂ߁A<br>
     * IllegalStateExceptionX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHandleRequest02() throws Exception {
        // O
        ErrorPageHandlingController controller = new ErrorPageHandlingController();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        try {
            controller.handleRequest(request, response);
            fail();
        } catch(IllegalStateException e) {
            // OK
        	return;
        }
    }

}
