/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.bind.creator;

import java.util.Map;

import org.springframework.beans.BeanWrapper;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.QueryServletRequestDataBinderCreator;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.bind.creator.
 * QueryServletRequestDataBinderCreator} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * NG`̃NGXgf[^ɑΉServletRequestDataBinderNX
 * ԋpB<br>
 * OFrequestAcommandArequestNameNulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.creator.
 * QueryServletRequestDataBinderCreator
 */
public class QueryServletRequestDataBinderCreatorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(
                QueryServletRequestDataBinderCreatorTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public QueryServletRequestDataBinderCreatorTest(String name) {
        super(name);
    }

    /**
     * testCreate01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() command:not null<br>
     *         () requestName:not null<br>
     *                i"sum"j<br>
     *         
     * <br>
     * ҒlF(߂l) binder:ServletRequestDataBinderԂB<br>
     *                  bindResult.targetcommandݒ肳B<br>
     *                  bindResult.objectNamerequestNameݒ肳B<br>
     *                  bindResult.beanWrapperɃJX^GfB^[
     *                  ݒ肳B<br>
     *                  ibyte[]AByteArrayMultipartFileEditor)<br>
     *         
     * <br>
     * NG`̃oC_𐶐eXgBNGXg"sum"B
     * ServletRequestDataBinderB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreate01() throws Exception {
        // O
        QueryServletRequestDataBinderCreator creator = 
            new QueryServletRequestDataBinderCreator();
        Object command = new Object();
        String requestName = "sum";
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        ServletRequestDataBinder binder = creator.create(
                request, command, requestName);

        // 
        Object target = UTUtil.getPrivateField(binder.getBindingResult(), "target");
        assertSame(command, target);
        Object objectName = UTUtil.getPrivateField(
                binder.getBindingResult(), "objectName");
        assertEquals(requestName, objectName);
        BeanWrapper bw = (BeanWrapper)UTUtil.getPrivateField(
                binder.getBindingResult(), "beanWrapper");
        Map editorMap = (Map)UTUtil.getPrivateField(bw, "customEditors");
        assertEquals((editorMap.get(byte[].class)).getClass().getName(),
                ByteArrayMultipartFileEditor.class.getName());
    }

    /**
     * testCreate02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() command:not null<br>
     *         () requestName:not null<br>
     *                i󕶎j<br>
     *         
     * <br>
     * ҒlF(߂l) binder:ServletRequestDataBinderԂB<br>
     *                  bindResult.targetcommandݒ肳B<br>
     *                  bindResult.objectNamerequestNameݒ肳B<br>
     *                  bindResult.beanWrapperɃJX^GfB^[
     *                  ݒ肳B<br>
     *                  ibyte[]AByteArrayMultipartFileEditor)<br>
     *         
     * <br>
     * NG`̃oC_𐶐eXgBNGXg̏ꍇ̃eXgB
     * ServletRequestDataBinderB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreate02() throws Exception {
        // O
        QueryServletRequestDataBinderCreator creator = 
            new QueryServletRequestDataBinderCreator();
        Object command = new Object();
        String requestName = "";
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        ServletRequestDataBinder binder = creator.create(
                request, command, requestName);

        // 
        Object target = UTUtil.getPrivateField(binder.getBindingResult(), "target");
        assertSame(command, target);
        Object objectName = UTUtil.getPrivateField(
                binder.getBindingResult(), "objectName");
        assertEquals(requestName, objectName);
        BeanWrapper bw = (BeanWrapper)UTUtil.getPrivateField(
                binder.getBindingResult(), "beanWrapper");
        Map editorMap = (Map)UTUtil.getPrivateField(bw, "customEditors");
        assertEquals((editorMap.get(byte[].class)).getClass().getName(),
                ByteArrayMultipartFileEditor.class.getName());
    }

}
