/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.inputcheck.validator;

import org.springframework.validation.Errors;
import jp.terasoluna.fw.validation.springmodules.BaseMultiFieldValidator;
import jp.terasoluna.rich.functionsample.inputcheck.bean.CodingData;

/**
 * R[fBOɂ̓`FbNNX
 *
 */
public class CodingMultiFieldsValidator extends BaseMultiFieldValidator {

    /**
     * փ`FbNsȂB
     *
     * @param obj ̓NX
     * @param errors G[NX
     */
    @Override
    protected void validateMultiField(Object obj, Errors errors) {
        
        CodingData bean = (CodingData) obj;
        
        // JavaBeanlo
        int field1 = Integer.parseInt(bean.getField1());
        int field2 = Integer.parseInt(bean.getField2());
        
        // feild2feild1傫ɂȂ邱Ƃ͋֎~B
        if (field1 < field2) {
            errors.rejectValue("field1", "errors.UC109.00001",
                    new String[]{"field1", "field2"}, "");
        }
    }
}
