/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.Map;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.View;

public class ModelAndView {
    private Object view;
    private ModelMap model;
    private boolean cleared;

    public ModelAndView() {
    }

    public ModelAndView(String viewName) {
        this.view = viewName;
    }

    public ModelAndView(View view) {
        this.view = view;
    }

    public ModelAndView(String viewName, Map model) {
        this.view = viewName;
        if (model != null) {
            this.getModelMap().addAllObjects(model);
        }
    }

    public ModelAndView(View view, Map model) {
        this.view = view;
        if (model != null) {
            this.getModelMap().addAllObjects(model);
        }
    }

    public ModelAndView(String viewName, String modelName, Object modelObject) {
        this.view = viewName;
        this.addObject(modelName, modelObject);
    }

    public ModelAndView(View view, String modelName, Object modelObject) {
        this.view = view;
        this.addObject(modelName, modelObject);
    }

    public void setViewName(String viewName) {
        this.view = viewName;
    }

    public String getViewName() {
        return this.view instanceof String ? (String)this.view : null;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view instanceof View ? (View)this.view : null;
    }

    public boolean hasView() {
        return this.view != null;
    }

    public boolean isReference() {
        return this.view instanceof String;
    }

    protected Map getModelInternal() {
        return this.model;
    }

    public ModelMap getModelMap() {
        if (this.model == null) {
            this.model = new ModelMap();
        }
        return this.model;
    }

    public Map getModel() {
        return this.getModelMap();
    }

    public ModelAndView addObject(Object modelObject) {
        this.getModelMap().addObject(modelObject);
        return this;
    }

    public ModelAndView addObject(String modelName, Object modelObject) {
        this.getModelMap().addObject(modelName, modelObject);
        return this;
    }

    public ModelAndView addAllObjects(Map modelMap) {
        this.getModelMap().addAllObjects(modelMap);
        return this;
    }

    public void clear() {
        this.view = null;
        this.model = null;
        this.cleared = true;
    }

    public boolean isEmpty() {
        return this.view == null && this.model == null;
    }

    public boolean wasCleared() {
        return this.cleared && this.isEmpty();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ModelAndView: ");
        if (this.isReference()) {
            buf.append("reference to view with name '").append(this.view).append("'");
        } else {
            buf.append("materialized View is [").append(this.view).append(']');
        }
        buf.append("; model is ").append(this.model);
        return buf.toString();
    }
}

