/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.terasoluna.fw.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    private static Log log = LogFactory.getLog(PropertyUtil.class);
    public static final String DEFAULT_PROPERTY_FILE = "ApplicationResources.properties";
    private static final String ADD_PROPERTY_PREFIX = "add.property.file.";
    private static final String PROPERTY_EXTENSION = ".properties";
    private static TreeMap<String, String> props = new TreeMap();
    private static Set<String> files = new HashSet<String>();

    private static void load(String name) {
        StringBuilder key = new StringBuilder();
        Properties p = PropertyUtil.readPropertyFile(name);
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            props.put((String)e.getKey(), (String)e.getValue());
        }
        if (p != null) {
            int i = 1;
            while (true) {
                key.setLength(0);
                key.append(ADD_PROPERTY_PREFIX);
                key.append(i);
                String addfile = p.getProperty(key.toString());
                if (addfile == null) break;
                String path = PropertyUtil.getPropertiesPath(name, addfile);
                PropertyUtil.addPropertyFile(path);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readPropertyFile(String name) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (is == null) {
            is = PropertyUtil.class.getResourceAsStream("/" + name);
        }
        Properties p = new Properties();
        try {
            try {
                p.load(is);
                files.add(name);
            }
            catch (NullPointerException e) {
                System.err.println("!!! PANIC: Cannot load " + name + " !!!");
                System.err.println(ExceptionUtil.getStackTrace(e));
            }
            catch (IOException e) {
                System.err.println("!!! PANIC: Cannot load " + name + " !!!");
                System.err.println(ExceptionUtil.getStackTrace(e));
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return p;
    }

    private static void overrideProperties() {
        Enumeration<String> enumeration = Collections.enumeration(props.keySet());
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            String value = System.getProperty(name);
            if (value == null) continue;
            props.put(name, value);
        }
    }

    public static void addPropertyFile(String name) {
        if (!name.endsWith(PROPERTY_EXTENSION)) {
            StringBuilder nameBuf = new StringBuilder();
            nameBuf.append(name);
            nameBuf.append(PROPERTY_EXTENSION);
            name = nameBuf.toString();
        }
        if (!files.contains(name)) {
            PropertyUtil.load(name);
        }
    }

    public static String getProperty(String key) {
        String result = props.get(key);
        if (result != null && result.equals("@" + key)) {
            return result;
        }
        if (result != null && result.startsWith("@@")) {
            return result.substring(1);
        }
        if (result != null && result.startsWith("@")) {
            result = PropertyUtil.getProperty(result.substring(1));
        }
        return result;
    }

    public static String getProperty(String key, String defaultValue) {
        String result = props.get(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static Enumeration getPropertyNames() {
        return Collections.enumeration(props.keySet());
    }

    public static Enumeration<String> getPropertyNames(String keyPrefix) {
        SortedMap<String, String> map = props.tailMap(keyPrefix);
        for (String name : map.keySet()) {
            if (name.startsWith(keyPrefix)) continue;
            return Collections.enumeration(props.subMap(keyPrefix, name).keySet());
        }
        return Collections.enumeration(map.keySet());
    }

    public static Set getPropertiesValues(String propertyName, String keyPrefix) {
        Properties localProps = PropertyUtil.loadProperties(propertyName);
        if (localProps == null) {
            return null;
        }
        Enumeration<String> keyEnum = PropertyUtil.getPropertyNames(localProps, keyPrefix);
        if (keyEnum == null) {
            return null;
        }
        return PropertyUtil.getPropertiesValues(localProps, keyEnum);
    }

    public static Enumeration<String> getPropertyNames(Properties localProps, String keyPrefix) {
        if (localProps == null || keyPrefix == null) {
            return null;
        }
        ArrayList<String> matchedNames = new ArrayList<String>();
        Enumeration<?> propNames = localProps.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            if (!name.startsWith(keyPrefix)) continue;
            matchedNames.add(name);
        }
        return Collections.enumeration(matchedNames);
    }

    public static Set<String> getPropertiesValues(Properties localProps, Enumeration<String> propertyNames) {
        if (localProps == null || propertyNames == null) {
            return null;
        }
        HashSet<String> retSet = new HashSet<String>();
        while (propertyNames.hasMoreElements()) {
            retSet.add(localProps.getProperty(propertyNames.nextElement()));
        }
        return retSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propertyName) {
        if (propertyName == null || "".equals(propertyName)) {
            return null;
        }
        Properties retProps = new Properties();
        StringBuilder resourceName = new StringBuilder();
        resourceName.append(propertyName);
        resourceName.append(PROPERTY_EXTENSION);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName.toString());
        if (is == null) {
            is = PropertyUtil.class.getResourceAsStream("/" + propertyName + PROPERTY_EXTENSION);
        }
        try {
            retProps.load(is);
        }
        catch (NullPointerException npe) {
            log.warn((Object)("*** Can not find property-file [" + propertyName + ".properties] ***"), (Throwable)npe);
            retProps = null;
        }
        catch (IOException ie) {
            log.error((Object)"", (Throwable)ie);
            retProps = null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ie) {
                log.error((Object)"", (Throwable)ie);
                retProps = null;
            }
        }
        return retProps;
    }

    private static String getPropertiesPath(String resource, String addFile) {
        File file = new File(resource);
        String dir = file.getParent();
        if (dir != null) {
            StringBuilder dirBuf = new StringBuilder();
            dirBuf.setLength(0);
            dirBuf.append(dir);
            dirBuf.append(File.separator);
            dir = dirBuf.toString();
        } else {
            dir = "";
        }
        StringBuilder retBuf = new StringBuilder();
        retBuf.setLength(0);
        retBuf.append(dir);
        retBuf.append(addFile);
        return retBuf.toString();
    }

    static {
        StringBuilder key = new StringBuilder();
        PropertyUtil.load(DEFAULT_PROPERTY_FILE);
        if (props != null) {
            int i = 1;
            while (true) {
                key.setLength(0);
                key.append(ADD_PROPERTY_PREFIX);
                key.append(i);
                String path = PropertyUtil.getProperty(key.toString());
                if (path == null) break;
                PropertyUtil.addPropertyFile(path);
                ++i;
            }
        }
        PropertyUtil.overrideProperties();
    }
}

