/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;
import jp.terasoluna.fw.file.annotation.StringConverter;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.standard.ColumnFormatter;
import jp.terasoluna.fw.file.dao.standard.FileDAOUtility;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileLineWriter<T>
implements FileLineWriter<T> {
    private Writer writer = null;
    private String fileName = null;
    private String fileEncoding = System.getProperty("file.encoding");
    private Class<T> clazz = null;
    private String lineFeedChar = System.getProperty("line.separator");
    private Field[] fields = null;
    private Method[] methods = null;
    private Map<String, ColumnFormatter> columnFormatterMap = null;
    private boolean writeData = false;
    private boolean writeTrailer = false;
    private int currentLineCount = 0;

    public AbstractFileLineWriter(String fileName, Class<T> clazz, Map<String, ColumnFormatter> columnFormatterMap) {
        this.fileName = fileName;
        this.clazz = clazz;
        this.columnFormatterMap = columnFormatterMap;
    }

    protected void init() {
        FileFormat fileFormat = this.clazz.getAnnotation(FileFormat.class);
        if (fileFormat == null) {
            throw new FileException("FileFormat annotation is not found.", new IllegalStateException(), this.fileName);
        }
        if (fileFormat.delimiter() == fileFormat.encloseChar()) {
            throw new FileException("Delimiter is the same as EncloseChar and is no use.", new IllegalStateException(), this.fileName);
        }
        if (fileFormat.fileEncoding() != null && !"".equals(fileFormat.fileEncoding())) {
            this.fileEncoding = fileFormat.fileEncoding();
        }
        if (fileFormat.lineFeedChar() != null && !"".equals(fileFormat.lineFeedChar())) {
            this.lineFeedChar = fileFormat.lineFeedChar();
        }
        if (this.lineFeedChar.length() > 2) {
            throw new FileException(new IllegalStateException("lineFeedChar length must be 1 or 2. but: " + this.lineFeedChar.length()), this.fileName);
        }
        this.buildFields();
        if (fileFormat.overWriteFlg()) {
            File file = new File(this.fileName);
            file.delete();
        }
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName, true), this.fileEncoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException(e, this.fileName);
        }
        catch (FileNotFoundException e) {
            throw new FileException(e, this.fileName);
        }
    }

    private void buildFields() {
        this.fields = this.clazz.getDeclaredFields();
        Field[] fieldArray = new Field[this.fields.length];
        for (Field field : this.getFields()) {
            OutputFileColumn outputFileColumn = field.getAnnotation(OutputFileColumn.class);
            if (outputFileColumn == null) continue;
            if (fieldArray[outputFileColumn.columnIndex()] == null) {
                fieldArray[outputFileColumn.columnIndex()] = field;
                continue;
            }
            throw new FileException("Column Index is duplicate : " + outputFileColumn.columnIndex(), this.fileName);
        }
        this.buildMethods();
    }

    private void buildMethods() {
        ArrayList<Method> methodList = new ArrayList<Method>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        StringBuilder getterName = new StringBuilder();
        for (Field field : this.fields) {
            if (field == null || field.getAnnotation(OutputFileColumn.class) == null) continue;
            String fieldName = field.getName();
            getterName.setLength(0);
            getterName.append("get");
            getterName.append(StringUtils.upperCase((String)fieldName.substring(0, 1)));
            getterName.append(fieldName.substring(1, fieldName.length()));
            try {
                methodList.add(this.clazz.getMethod(getterName.toString(), new Class[0]));
                fieldList.add(field);
            }
            catch (NoSuchMethodException e) {
                throw new FileException(e, this.fileName);
            }
        }
        this.methods = methodList.toArray(new Method[methodList.size()]);
        this.fields = fieldList.toArray(new Field[fieldList.size()]);
    }

    @Override
    public void printHeaderLine(List<String> headerLine) {
        if (this.writeData || this.writeTrailer) {
            throw new FileException("Header part should be called before data part or trailer part.", new IllegalStateException(), this.fileName);
        }
        this.printList(headerLine);
    }

    @Override
    public void printDataLine(T t) {
        int i;
        this.checkWriteTrailer();
        StringBuilder fileLineBuilder = new StringBuilder();
        if (this.getDelimiter() == '\u0000' && this.getEncloseChar() == '\u0000') {
            for (i = 0; i < this.getFields().length; ++i) {
                fileLineBuilder.append(this.getColumn(t, i));
            }
        } else {
            for (i = 0; i < this.getFields().length; ++i) {
                if (this.getEncloseChar() != '\u0000') {
                    fileLineBuilder.append(this.getEncloseChar());
                    fileLineBuilder.append(this.getColumn(t, i));
                    fileLineBuilder.append(this.getEncloseChar());
                } else {
                    fileLineBuilder.append(this.getColumn(t, i));
                }
                fileLineBuilder.append(this.getDelimiter());
            }
            if (fileLineBuilder.length() > 0) {
                fileLineBuilder.deleteCharAt(fileLineBuilder.length() - 1);
            }
        }
        fileLineBuilder.append(this.getLineFeedChar());
        try {
            this.getWriter().write(fileLineBuilder.toString());
        }
        catch (IOException e) {
            throw new FileException(e, this.fileName);
        }
        ++this.currentLineCount;
        this.setWriteData(true);
    }

    @Override
    public void printTrailerLine(List<String> trailerLine) {
        this.printList(trailerLine);
        this.writeTrailer = true;
    }

    private void printList(List<String> stringList) {
        for (String header : stringList) {
            try {
                this.writer.write(header);
                this.writer.write(this.lineFeedChar);
            }
            catch (IOException e) {
                throw new FileException(e, this.fileName);
            }
        }
    }

    @Override
    public void closeFile() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new FileException(e, this.fileName);
        }
    }

    protected String getColumn(T t, int index) {
        String columnString = null;
        OutputFileColumn outputFileColumn = this.fields[index].getAnnotation(OutputFileColumn.class);
        ColumnFormatter columnFormatter = this.columnFormatterMap.get(this.methods[index].getReturnType().getName());
        try {
            columnString = columnFormatter.format(t, this.methods[index], outputFileColumn.columnFormat());
        }
        catch (IllegalArgumentException e) {
            throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        catch (IllegalAccessException e) {
            throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        catch (InvocationTargetException e) {
            throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        if (columnString == null) {
            columnString = "";
        }
        columnString = FileDAOUtility.trim(columnString, this.fileEncoding, outputFileColumn.trimChar(), outputFileColumn.trimType());
        columnString = FileDAOUtility.padding(columnString, this.fileEncoding, outputFileColumn.bytes(), outputFileColumn.paddingChar(), outputFileColumn.paddingType());
        try {
            StringConverter stringConverter = outputFileColumn.stringConverter().newInstance();
            columnString = stringConverter.convert(columnString);
        }
        catch (InstantiationException e) {
            throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        catch (IllegalAccessException e) {
            throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        if (this.isCheckByte(outputFileColumn)) {
            try {
                if (0 >= outputFileColumn.bytes()) {
                    throw new FileLineException("bytes is not set or a number equal to or less than 0 is set.", new IllegalStateException(), this.getFileName(), this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
                }
                if (columnString.getBytes(this.fileEncoding).length != outputFileColumn.bytes()) {
                    throw new FileLineException("The data size is different from bytes value of the set value of the column .", new IllegalStateException(), this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new FileException(e, this.fileName);
            }
        }
        return columnString;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected String getLineFeedChar() {
        return this.lineFeedChar;
    }

    public void setColumnFormatterMap(Map<String, ColumnFormatter> columnFormatterMap) {
        this.columnFormatterMap = columnFormatterMap;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected Field[] getFields() {
        return this.fields;
    }

    protected Method[] getMethods() {
        return this.methods;
    }

    protected void setWriteData(boolean writeData) {
        this.writeData = writeData;
    }

    protected void checkWriteTrailer() {
        if (this.writeTrailer) {
            throw new FileException("Header part or data part should be called before TrailerPart", new IllegalStateException(), this.fileName);
        }
    }

    public abstract char getDelimiter();

    public abstract char getEncloseChar();

    protected boolean isCheckByte(OutputFileColumn outputFileColumn) {
        return 0 < outputFileColumn.bytes();
    }
}

