/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.math.BigDecimal;
import java.text.DecimalFormat;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.util.StringUtil;

/**
 * <p><code>decimal</code>^O̎NXB</p>
 *
 * <p>
 *  Aя_tltH[}bgďóA
 *  邢̓XNveBOϐƂĒ`B<br>
 * </p>
 * <p>
 *  tH[}bgΏۂƂȂ鐔lf[^́A<code>java.math.BigDecimal</code>
 *  ^A邢 <code>java.lang.String</code> ^T|[gB
 *  <code>java.lang.String</code> ^̏ꍇA<code>BigDecimal</code>
 *  ̃RXgN^ɂĉ߉\ȕƂȂĂKvB
 * </p>
 *
 * <p>
 *  <code>BigDecimal</code> ̃RXgN^ŉߕs\łꍇ́A
 *  <code>NumberFormatException</code> X[B
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p><code>DecimalTag</code> ł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td><code>id</code></td>
 *    <td>Ȃ</td>
 *    <td> <code>false</code> </td>
 *    <td> <code>false</code> </td>
 *    <td align="left">tH[}bgꂽX|X֏o͂ɁA
 *      XNveBOϐɃZbgۂɎw肷B
 *      tH[}bgꂽXNveBOϐɃZbgꍇɂ́A
 *      <code>filter</code> ̎wɊւ炸HTML
 *      ꕶ̓GXP[vȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>filter</code></td>
 *    <td><code>true</code></td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bgꂽo͂ۂɁAHTMLꕶ
 *      GXP[v邩ǂw肷BA<code>id</code> 
 *      w肳Ăꍇɂ́AB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>ignore</code></td>
 *    <td><code>false</code></td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left"><code>name</code> Ŏw肵 bean
 *      ȂƂɖ邩ǂw肷B<code>false</code> 
 *      w肷ƁAbeanȂƂ <code>JspException</code>
 *      B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>name</code></td>
 *    <td>Ȃ</td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bgΏۂ̕vpeBɎbean̖OB
 *      <code>property</code> w肳ĂȂƂɂ́A
 *      <code>name</code> Ŏw肳ꂽCX^X
 *      tH[}bg̑ΏۂƂȂB̏ꍇ́ÃCX^Xg
 *      <code>java.math.BigDecimal</code> ^ł邩A邢
 *      <code>java.lang.String</code> ^iE̋󔒏
 *      <code>BigDecimal</code> ̃RXgN^ɂĉ߉\ł́j
 *      ̂ǂ炩łKvB<code>value</code>
 *      w肳Ăꍇɂ́AB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>property</code></td>
 *    <td>Ȃ</td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left"><code>name</code> Ŏw肳ꂽ bean
 *      ɂăANZXvpeB̖OB<code>value</code> 
 *      w肳Ăꍇɂ͖B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>scope</code></td>
 *    <td>i<code>findAttribute()</code> \bȟj</td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left"><code>name</code> Ŏw肳ꂽbean
 *      ۂ̃XR[vB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>value</code></td>
 *    <td>Ȃ</td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bg镶B́AE̋󔒏
 *      <code>BigDecimal</code>
 *      ̃RXgN^ɂĉ߉\łKvB<code>value</code>
 *      w肵ꍇɂ́A<code>name</code>
 *      A <code>property</code> ͖B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>pattern</code></td>
 *    <td>Ȃ</td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bgo͌`B<code>pattern</code>
 *      Ŏw肵o͌`́A<code>DecimalFormat</code>
 *      NX̃p^[Ƃĉ߂Bڍׂ́A<code>DecimalFormat</code>
 *      NX̃hLgQƂ̂ƁB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>scale</code></td>
 *    <td>Ȃ</td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">ۂߓ̏_ȉB<code>n</code>
 *      w肵ꍇɂ́A <code>n + 1</code> ʂۂ߂B
 *      ۂ߃[h<code>round</code>Ŏw肷B<code>round</code>
 *      w肳ĂȂꍇ́AľܓsB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>round</code></td>
 *    <td>Ȃ</td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">ۂ߃[hB<code>scale</code>
 *      w肳Ă鎞ALɂȂB<code>ROUND_HALF_UP</code>iľܓjA
 *      <code>ROUND_FLOOR</code>i؂̂ājA<code>ROUND_CEILING</code>
 *     i؂グj ݒ\łBftHg<code>ROUND_HALF_UP
 *      </code>sBR̐ݒȊOw肵ꍇ́A
 *      <code>IllegalArgumentException</code>X[B
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>
 *  <code>DecimalTag</code> ł͈ȉ̕ϐT|[gB
 * </p>
 * <div align="center">
 * <table width="90%" border="1">
 *  <tr>
 *   <td><b>ϐ</b></td>
 *   <td><b>^</b></td>
 *   <td><b>L͈</b></td>
 *   <td><b>Lq</b></td>
 *  </tr>
 *  <tr>
 *   <td>JX^^O <code>id</code> Ŏw肳ꂽO</td>
 *   <td><code>String</code></td>
 *   <td>Jn^Oȍ~</td>
 *   <td align="left">̃JX^^Oŏo͂AXNveBOϐ
 *    ݒ肷ꍇ̕ϐB
 *   </td>
 *  </tr>
 * </table>
 * </div>
 */
public class DecimalTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -2317420257734211793L;

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(DecimalTag.class);
    
    /**
     * ̃y[Wŗpł悤ɂ邽߂̃XNveBOϐ̖OB
     *
     */
    protected String id = null;

    /**
     * XNveBOϐ̖O擾B
     *
     * @return XNveBOϐ
     */
    @Override
    public String getId() {
        return this.id;
    }

    /**
     * XNveBOϐ̖Oݒ肷B
     *
     * @param id XNveBOϐ̖O
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    /**
     * HTMLꕶo͂ۂɃtB^[邩ǂBftHg
     * <code>true</code>B
     */
    protected boolean filter = true;

    /**
     * o͒HTMLꕶtB^[邩ǂ擾B
     *
     * @return o͒HTMLꕶtB^[ꍇ <code>true</code>
     */
    public boolean getFilter() {
        return this.filter;
    }

    /**
     * o͒HTMLꕶtB^[邩ǂݒ肷B
     *
     * @param filter o͒HTMLꕶtB^[ꍇ
     *               <code>true</code>
     */
    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    /**
     * beanȂƂɁAPɖio͂ȂjǂB
     * Ȃꍇɂ́AO𓊂BftHg <code>false</code>
     * iO𓊂jB
     */
    protected boolean ignore = false;

    /**
     * beanȂꍇɖ邩ǂ擾B
     *
     * @return ꍇ <code>true</code>
     */
    public boolean getIgnore() {
        return this.ignore;
    }

    /**
     * beanȂꍇɖ邩ǂݒ肷B
     *
     * @param ignore ꍇ <code>true</code>
     */
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    /**
     * tH[}bgΏۂ̃f[^܂bean̖OB
     *
     */
    protected String name = null;

    /**
     * tH[}bgΏۂ̃f[^܂bean̖O擾B
     *
     * @return bean̖O
     */
    public String getName() {
        return this.name;
    }

    /**
     * tH[}bgΏۂ̃f[^܂bean̖Oݒ肷B
     *
     * @param name bean̖O
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * w肳ꂽbeanɂăANZXvpeB̖OB
     *
     */
    protected String property = null;

    /**
     * w肳ꂽbeanɂăANZXvpeB̖O擾B
     *
     * @return w肳ꂽbeanɂăANZXvpeB̖O
     */
    public String getProperty() {
        return this.property;
    }

    /**
     * w肳ꂽbeanɂăANZXvpeB̖Oݒ肷B
     *
     * @param property w肳ꂽbeanɂăANZXvpeB̖O
     */
    public void setProperty(String property) {
        this.property = property;
    }

    /**
     * w肳ꂽbeanXR[vB
     *
     */
    protected String scope = null;

    /**
     * w肳ꂽbeanXR[v擾B
     *
     * @return XR[v
     */
    public String getScope() {
        return this.scope;
    }

    /**
     * w肳ꂽbeanXR[vݒ肷B
     *
     * @param scope w肳ꂽbeanXR[v
     */
    public void setScope(String scope) {
        this.scope = scope;
    }

    /**
     * o͂̃tH[}bgw肷p^[B
     * <code>DecimalFormat</code> ƓŎw肷B
     *
     */
    protected String pattern = null;

    /**
     * o͂̃tH[}bgw肷p^[擾B
     *
     * @return o͂̃tH[}bgw肷p^[
     */
    public String getPattern() {
        return this.pattern;
    }

    /**
     * o͂̃tH[}bgw肷p^[ݒ肷B
     *
     * @param pattern p^[
     */
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    /**
     * tH[}bgΏۂ̒lijB
     *
     */
    protected String value = null;

    /**
     * tH[}bgΏۂ̒l擾B
     *
     * @return tH[}bgΏۂ̒l
     */
    public String getValue() {
        return this.value;
    }

    /**
     * tH[}bgΏۂ̒lݒ肷B
     *
     * @param value tH[}bgΏۂ̒l
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * ľܓ̏_ȉ̌B<code>n</code> w肵ꍇɂ́A
     *  <code>n + 1</code> ʂľܓB
     *
     */
    protected int scale = -1;

    /**
     * ľܓ̏_ȉ̌擾B
     *
     * @return _ȉ̌
     */
    public int getScale() {
        return this.scale;
    }

    /**
     * ľܓ̏_ȉ̌ݒ肷B
     *
     * @param scale _ȉ̌
     */
    public void setScale(int scale) {
        this.scale = scale;
    }

    /**
     * ۂ߃[hB
     *
     */
    protected String round = null;

    /**
     * ۂ߃[h擾B
     *
     * @return ۂ߃[h
     */
    public String getRound() {
        return this.round;
    }

    /**
     * ۂ߃[hݒ肷B
     *
     * @param round ۂ߃[h
     */
    public void setRound(String round) {
        this.round = round;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return wB <code>SKIP_BODY</code>
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        Object value = this.value;
        if (value == null) {
            // beanȂĂꍇɂ́AvꂽbeanbNAbv
            // Ȃꍇɂ́A^[
            if (ignore) {
                if (TagUtil.lookup(pageContext, name, scope) == null) {
                    return SKIP_BODY;  // o͂Ȃ
                }
            }

            // vꂽvpeB̒lbNAbv
            value = TagUtil.lookup(pageContext, name, property, scope);
            if (value == null) {
                return SKIP_BODY;  // o͂Ȃ
            }
        }

        // vpeB̒lString^łΈxBigDecimal֕ϊ
        BigDecimal bd = null;
        if (value instanceof String) {
            String trimed = StringUtil.rtrim((String) value);
            if ("".equals(trimed)) {
                return SKIP_BODY;  //  o͂Ȃ
            }
            bd = new BigDecimal(trimed);
        } else if (value instanceof BigDecimal) {
            bd = (BigDecimal) value;
        } else {
            return SKIP_BODY;  // o͂Ȃ
        }

        // _ȉw肳Ăꍇ
        if (scale >= 0) {
            // roundɐݒ肳ꂽۂ߃[hsiݒ肪ꍇ͎ľܓj
            if (round != null) {
                if ("ROUND_FLOOR".equalsIgnoreCase(round)) {
                    bd = bd.setScale(scale, BigDecimal.ROUND_FLOOR);
                } else if ("ROUND_CEILING".equalsIgnoreCase(round)) {
                    bd = bd.setScale(scale, BigDecimal.ROUND_CEILING);
                } else if ("ROUND_HALF_UP".equalsIgnoreCase(round)) {
                    bd = bd.setScale(scale, BigDecimal.ROUND_HALF_UP);
                } else {
                    log.error("Please set a rounding mode");
                    throw new IllegalArgumentException(
                            "Please set a rounding mode");
                }
            } else {
                bd = bd.setScale(scale, BigDecimal.ROUND_HALF_UP);
            }
        }

        // tH[}bg
        DecimalFormat df = new DecimalFormat(pattern);
        String output = df.format(bd);

        if (id != null) {
            // idw肳ĂƂɂ́AXNveBOϐƂėpł
            // 悤Ƀy[WXR[vɃZbgB
            pageContext.setAttribute(id, output);
        } else {
            // idw肳ĂȂƂɂ́AvpeB̒lC^Ƀvg
            // BK؂ɃtB^B
            if (filter) {
                TagUtil.write(pageContext, TagUtil.filter(output));
            } else {
                TagUtil.write(pageContext, output);
            }
        }

        return SKIP_BODY;
    }

    /**
     * ׂẴAP[gꂽB
     *
     */
    @Override
    public void release() {
        super.release();
        id = null;
        filter = true;
        ignore = false;
        name = null;
        property = null;
        scope = null;
        pattern = null;
        value = null;
        scale = -1;
    }

}
