/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassLoaderUtils;

public class ClassLoaderAnalyzerInterceptor
implements MethodInterceptor,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)ClassLoaderAnalyzerInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (logger.isInfoEnabled()) {
            logger.info((Object)ClassLoaderUtils.showClassLoaderHierarchy(invocation.getThis(), invocation.getThis().getClass().getName(), "\n", "-"));
        }
        return invocation.proceed();
    }
}

