/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.io.BufferedReader;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import junit.framework.TestCase;

import com.mockrunner.mock.web.MockHttpServletRequest;

/**
 * BodyTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class BodyTagTest extends TestCase {

    //eXgΏ
    BodyTag tag = null;

    /**
     * Constructor for BodyTagTest.
     * @param arg0
     */
    public BodyTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (BodyTag) TagUTUtil.create(BodyTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * onLoadBody=Null<br>
     * onload=Null<br>
     * onunload=Null<br>
     * styleClass=Null<br>
     * bgcolor=Null<br>
     * background=Null<br>
     * text=Null<br>
     * link=Null<br>
     * vlink=Null<br>
     * alink=Null<br>
     * out=Not Null<br>
     * ContextPath=*<br>
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=u"<body>"vщs<br>
     * 
     * onLoadBody,onload,onunload,styleClass,bgcolor,
     * background,text,link,vlink,alinkׂ̂Ă
     * NULL̏ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag01() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // NGXgON_LOADݒ
        req.setAttribute(BodyTag.ON_LOAD_KEY, null);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "onload", null);
        UTUtil.setPrivateField(tag, "onunload", null);
        UTUtil.setPrivateField(tag, "styleClass", null);
        UTUtil.setPrivateField(tag, "bgcolor", null);
        UTUtil.setPrivateField(tag, "background", null);
        UTUtil.setPrivateField(tag, "text", null);
        UTUtil.setPrivateField(tag, "link", null);
        UTUtil.setPrivateField(tag, "vlink", null);
        UTUtil.setPrivateField(tag, "alink", null);

        // JX^^OContextPathݒ
        String contextPath = "contextPath";
        TagUTUtil.setContextPath(tag, contextPath);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("<body>", reader.readLine());

    } /* testDoStartTag01 End */

    /**
     * testDoStartTag02B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l onLoadBody=*<br>
     * onload=*<br>
     * onunload=*<br>
     * styleClass=*<br>
     * bgcolor=*<br>
     * background=*<br>
     * text=*<br>
     * link=*<br>
     * vlink=*<br>
     * alink=*<br>
     * ContextPath=*<br>
     * 
     * Ғl ߂l:int=JspTagException<br>
     * 
     * o͎IOExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag02() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // eXgpJspWriter̐
        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);

        // Eݒ肵eXgpJspWriterPageContextɃZbg
        UTUtil.setPrivateField(pc, "jspWriter", out);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException ex) {
            // eXgʊmF
            assertEquals("javax.servlet.jsp.JspTagException:"
                    + " java.io.IOException", ex.toString());
            return;
        }
    } /* testDoStartTag02 End */

    /**
     * testDoStartTag03B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * onLoadBody="onLoadBody"<br>
     * onload="onload;"<br>
     * onunload="onunload"<br>
     * styleClass="styleClass"<br>
     * bgcolor="bgcolor"<br>
     * background="/background"<br>
     * text="text"<br>
     * link="link"<br>
     * vlink="vlink"<br>
     * alink="alink"<br>
     * out=Not Null<br>
     * ContextPath="/path"<br>
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=
     * u<body onLoad="__onLoad__()" onUnLoad="onunload" class="styleClass" 
     * bgcolor="bgcolor" background="contextPath/background" 
     * text="text" link="link" vlink="vlink" alink="alink">vs
     * u<script type="text/javascript">vs
     * u<!--vs
     * ufunction __onLoad__() {vs
     * u  onload;vs
     * uonLoadBody}vs
     * u//-->vs
     * u</script>vs<br>
     * 
     * onLoadBody,onload,onunload,styleClass,bgcolor,
     * background,text,link,vlink,alinkׂ̂ĂɒlA
     * Abackground̒l̍ŏɁu/vAA
     * onload̍ŌɁu;vꍇ̃eXgP[X<br>
     */
    public void testDoStartTag03() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // NGXgON_LOADݒ
        req.setAttribute(BodyTag.ON_LOAD_KEY, "onLoadBody");

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "onload", "onload;");
        UTUtil.setPrivateField(tag, "onunload", "onunload");
        UTUtil.setPrivateField(tag, "styleClass", "styleClass");
        UTUtil.setPrivateField(tag, "bgcolor", "bgcolor");
        UTUtil.setPrivateField(tag, "background", "/background");
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "link", "link");
        UTUtil.setPrivateField(tag, "vlink", "vlink");
        UTUtil.setPrivateField(tag, "alink", "alink");

        // JX^^OContextPathݒ
        String contextPath = "contextPath";
        TagUTUtil.setContextPath(tag, contextPath);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("<body onLoad=\"__onLoad__()\" onUnLoad=\"onunload\" "
                + "class=\"styleClass\" bgcolor=\"bgcolor\" "
                + "background=\"contextPath/background\" "
                + "text=\"text\" link=\"link\" vlink=\"vlink\" "
                + "alink=\"alink\">", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("function __onLoad__() {", reader.readLine());
        assertEquals("  onload;", reader.readLine());
        assertEquals("onLoadBody}", reader.readLine());
        assertEquals("//-->", reader.readLine());
        assertEquals("</script>", reader.readLine());

    } /* testDoStartTag03 End */

    /**
     * testDoStartTag04B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * onLoadBody="onLoadBody"<br>
     * onload="onload"<br>
     * onunload="onunload"<br>
     * styleClass="styleClass"<br>
     * bgcolor="bgcolor"<br>
     * background="background"<br>
     * text="text"<br>
     * link="link"<br>
     * vlink="vlink"<br>
     * alink="alink"<br>
     * out=Not Null<br>
     * ContextPath="/path"<br>
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=
     * u<body onLoad="__onLoad__()" onUnLoad="onunload" class="styleClass" 
     * bgcolor="bgcolor" background="/contextPath/background" 
     * text="text" link="link" vlink="vlink" alink="alink">vs
     * u<script type="text/javascript">vs
     * u<!--vs
     * ufunction __onLoad__() {vs
     * u  onload;vs
     * uonLoadBody}vs
     * u//-->vs
     * u</script>vs<br>
     * 
     * onLoadBody,onload,onunload,styleClass,bgcolor,
     * background,text,link,vlink,alinkׂ̂ĂɒlA
     * Abackground̒l̍ŏɁu/vȂAA
     * onload̍ŌɁu;vȂꍇ̃eXgP[X<br>
     */
    public void testDoStartTag04() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // NGXgON_LOADݒ
        req.setAttribute(BodyTag.ON_LOAD_KEY, "onLoadBody");

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "onload", "onload");
        UTUtil.setPrivateField(tag, "onunload", "onunload");
        UTUtil.setPrivateField(tag, "styleClass", "styleClass");
        UTUtil.setPrivateField(tag, "bgcolor", "bgcolor");
        UTUtil.setPrivateField(tag, "background", "background");
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "link", "link");
        UTUtil.setPrivateField(tag, "vlink", "vlink");
        UTUtil.setPrivateField(tag, "alink", "alink");

        // JX^^OContextPathݒ
        String contextPath = "contextPath";
        TagUTUtil.setContextPath(tag, contextPath);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("<body onLoad=\"__onLoad__()\" onUnLoad=\"onunload\" "
                + "class=\"styleClass\" bgcolor=\"bgcolor\" "
                + "background=\"contextPath/background\" "
                + "text=\"text\" link=\"link\" vlink=\"vlink\" "
                + "alink=\"alink\">", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("function __onLoad__() {", reader.readLine());
        assertEquals("  onload;", reader.readLine());
        assertEquals("onLoadBody}", reader.readLine());
        assertEquals("//-->", reader.readLine());
        assertEquals("</script>", reader.readLine());

    } /* testDoStartTag04 End */

    /**
     * testDoStartTag05B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * onLoadBody=Null<br>
     * onload="onload"<br>
     * onunload="onunload"<br>
     * styleClass="styleClass"<br>
     * bgcolor="bgcolor"<br>
     * background="background"<br>
     * text="text"<br>
     * link="link"<br>
     * vlink="vlink"<br>
     * alink="alink"<br>
     * out=Not Null<br>
     * ContextPath="/path"<br>
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=
     * u<body onLoad="__onLoad__()" onUnLoad="onunload" class="styleClass" 
     * bgcolor="bgcolor" background="/path/background" 
     * text="text" link="link" vlink="vlink" alink="alink">vs
     * u<script type="text/javascript">vs
     * u<!--vsufunction __onLoad__() {vs
     * u  onload;vs
     * u}vs
     * u//-->vs
     * u</script>vs<br>
     * 
     * onLoadBodyNULLŁAonload,onunload,styleClass,bgcolor,
     * background,text,link,vlink,alinkׂ̂Ăɒlꍇ̃eXgP[X<br>
     */
    public void testDoStartTag05() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // NGXgON_LOADݒ
        req.setAttribute(BodyTag.ON_LOAD_KEY, null);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "onload", "onload");
        UTUtil.setPrivateField(tag, "onunload", "onunload");
        UTUtil.setPrivateField(tag, "styleClass", "styleClass");
        UTUtil.setPrivateField(tag, "bgcolor", "bgcolor");
        UTUtil.setPrivateField(tag, "background", "background");
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "link", "link");
        UTUtil.setPrivateField(tag, "vlink", "vlink");
        UTUtil.setPrivateField(tag, "alink", "alink");

        // JX^^OContextPathݒ
        String contextPath = "contextPath";
        TagUTUtil.setContextPath(tag, contextPath);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("<body onLoad=\"__onLoad__()\" onUnLoad=\"onunload\" "
                + "class=\"styleClass\" bgcolor=\"bgcolor\" "
                + "background=\"contextPath/background\" "
                + "text=\"text\" link=\"link\" vlink=\"vlink\" "
                + "alink=\"alink\">", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("function __onLoad__() {", reader.readLine());
        assertEquals("  onload;", reader.readLine());
        assertEquals("}", reader.readLine());
        assertEquals("//-->", reader.readLine());
        assertEquals("</script>", reader.readLine());

    } /* testDoStartTag05 End */

    /**
     * testDoStartTag06B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * onLoadBody="onLoadBody"<br>
     * onload=Null<br>
     * onunload="onunload"<br>
     * styleClass="styleClass"<br>
     * bgcolor="bgcolor"<br>
     * background="background"<br>
     * text="text"<br>
     * link="link"<br>
     * vlink="vlink"<br>
     * alink="alink"<br>
     * out=Not Null<br>
     * ContextPath="/path"<br>
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=
     * u<body onLoad="__onLoad__()" onUnLoad="onunload" class="styleClass" 
     * bgcolor="bgcolor" background="/path/background" 
     * text="text" link="link" vlink="vlink" alink="alink">vs
     * u<script type="text/javascript">vs
     * u<!--vs
     * ufunction __onLoad__() {vs
     * u  onLoadBody}vs
     * u//-->vs
     * u</script>vs<br>
     * 
     * onloadNULLŁAonLoadBody,onunload,styleClass,bgcolor,
     * background,text,link,vlink,alinkׂ̂Ăɒlꍇ̃eXgP[X<br>
     */
    public void testDoStartTag06() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɊ֘Atꂽ(Mock)HttpServletRequest擾
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();

        // NGXgON_LOADݒ
        req.setAttribute(BodyTag.ON_LOAD_KEY, "onLoadBody");

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "onload", null);
        UTUtil.setPrivateField(tag, "onunload", "onunload");
        UTUtil.setPrivateField(tag, "styleClass", "styleClass");
        UTUtil.setPrivateField(tag, "bgcolor", "bgcolor");
        UTUtil.setPrivateField(tag, "background", "background");
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "link", "link");
        UTUtil.setPrivateField(tag, "vlink", "vlink");
        UTUtil.setPrivateField(tag, "alink", "alink");

        // JX^^OContextPathݒ
        String contextPath = "contextPath";
        TagUTUtil.setContextPath(tag, contextPath);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_BODY_INCLUDE);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("<body onLoad=\"__onLoad__()\" onUnLoad=\"onunload\" "
                + "class=\"styleClass\" bgcolor=\"bgcolor\" "
                + "background=\"contextPath/background\" "
                + "text=\"text\" link=\"link\" vlink=\"vlink\" "
                + "alink=\"alink\">", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals("function __onLoad__() {", reader.readLine());
        assertEquals("onLoadBody}", reader.readLine());
        assertEquals("//-->", reader.readLine());
        assertEquals("</script>", reader.readLine());

    } /* testDoStartTag06 End */

    /**
     * testDoEndTag01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * out=Not Null<br>
     * 
     * Ғl
     * ߂l:int=EVAL_PAGE<br>
     * o͓e=u"</body>"v<br>
     * 
     * HTMLBODY^Oɏo͂ꂽꍇ̃eXgP[X<br>
     */
    public void testDoEndTag01() throws Exception {

        // eXgs
        int result = tag.doEndTag();

        // eXgʊmF
        assertEquals(result, Tag.EVAL_PAGE);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("</body>", reader.readLine());

    } /* testDoEndTag01 End */

    /**
     * testDoEndTag02B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * 
     * Ғl
     * ߂l:int=JspTagException<br>
     * o͓e=-<br>
     * 
     * o͎IOExceptionꍇ̃eXgP[X<br>
     */
    public void testDoEndTag02() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);
        UTUtil.setPrivateField(pc, "jspWriter", out);

        // eXgs
        try {
            tag.doEndTag();
            fail();
        } catch (JspTagException ex) {
            assertEquals("javax.servlet.jsp.JspTagException:"
                    + " java.io.IOException", ex.toString());
            return;
        }
    } /* testDoEndTag02 End */

    /**
     * testRelease01B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * onload=*<br>
     * onunload=*<br>
     * styleClass=*<br>
     * bgcolor=*<br>
     * background=*<br>
     * text=*<br>
     * link=*<br>
     * vlink=*<br>
     * alink=*<br>
     * 
     * Ғl
     * ߂l:void<br>
     * onload=Null<br>
     * onunload=Null<br>
     * styleClass=Null<br>
     * bgcolor=Null<br>
     * background=Null<br>
     * text=Null<br>
     * link=Null<br>
     * vlink=Null<br>
     * alink=Null<br>
     * 
     * OƂĐݒ肵elAsɊel
     * 邱ƂmF<br>
     */
    public void testRelease01() throws Exception {
        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "onload", "onload");
        UTUtil.setPrivateField(tag, "onunload", "onunload");
        UTUtil.setPrivateField(tag, "styleClass", "styleClass");
        UTUtil.setPrivateField(tag, "bgcolor", "bgcolor");
        UTUtil.setPrivateField(tag, "background", "background");
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "link", "link");
        UTUtil.setPrivateField(tag, "vlink", "vlink");
        UTUtil.setPrivateField(tag, "alink", "alink");

        // eXgs
        tag.release();

        // eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "onload"));
        assertNull(UTUtil.getPrivateField(tag, "onunload"));
        assertNull(UTUtil.getPrivateField(tag, "styleClass"));
        assertNull(UTUtil.getPrivateField(tag, "bgcolor"));
        assertNull(UTUtil.getPrivateField(tag, "background"));
        assertNull(UTUtil.getPrivateField(tag, "text"));
        assertNull(UTUtil.getPrivateField(tag, "link"));
        assertNull(UTUtil.getPrivateField(tag, "vlink"));
        assertNull(UTUtil.getPrivateField(tag, "alink"));

    } /* testRelease01 End */

    /**
     * testSetOnload01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l onload="onload"<br>
     * 
     * Ғl ߂l:void<br>
     * onload="onload"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetOnload01() throws Exception {
        // eXgs
        tag.setOnload("onload");

        // eXgʊmF
        assertEquals("onload", UTUtil.getPrivateField(tag, "onload"));

    } /* testSetOnload01 End */

    /**
     * testSetOnunload01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * onunload="onunload"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * onunload="onunload"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetOnunload01() throws Exception {
        // eXgs
        tag.setOnunload("onunload");

        // eXgʊmF
        assertEquals("onunload", UTUtil.getPrivateField(tag, "onunload"));

    } /* testSetOnunload01 End */

    /**
     * testSetStyleClass01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * styleClass="styleClass"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * styleClass="styleClass"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetStyleClass01() throws Exception {
        // eXgs
        tag.setStyleClass("styleClass");

        // eXgʊmF
        assertEquals("styleClass", UTUtil.getPrivateField(tag, "styleClass"));

    } /* testSetStyleClass01 End */

    /**
     * testSetBgcolor01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * bgcolor="bgcolor"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * bgcolor="bgcolor"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetBgcolor01() throws Exception {
        // eXgs
        tag.setBgcolor("bgcolor");

        // eXgʊmF
        assertEquals("bgcolor", UTUtil.getPrivateField(tag, "bgcolor"));

    } /* testSetBgcolor01 End */

    /**
     * testSetBackground01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * background="background"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * background="background"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetBackground01() throws Exception {
        // eXgs
        tag.setBackground("background");

        // eXgʊmF
        assertEquals("background", UTUtil.getPrivateField(tag, "background"));

    } /* testSetBackground01 End */

    /**
     * testSetText01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * text="text"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * text="text"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetText01() throws Exception {
        // eXgs
        tag.setText("text");

        // eXgʊmF
        assertEquals("text", UTUtil.getPrivateField(tag, "text"));

    } /* testSetText01 End */

    /**
     * testSetLink01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * link="link"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * link="link"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetLink01() throws Exception {
        // eXgs
        tag.setLink("link");

        // eXgʊmF
        assertEquals("link", UTUtil.getPrivateField(tag, "link"));

    } /* testSetLink01 End */

    /**
     * testSetVlink01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * vlink="vlink"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * vlink="vlink"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetVlink01() throws Exception {
        // eXgs
        tag.setVlink("vlink");

        // eXgʊmF
        assertEquals("vlink", UTUtil.getPrivateField(tag, "vlink"));

    } /* testSetVlink01 End */

    /**
     * testSetAlink01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * alink="alink"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * alink="alink"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetAlink01() throws Exception {
        // eXgs
        tag.setAlink("alink");

        // eXgʊmF
        assertEquals("alink", UTUtil.getPrivateField(tag, "alink"));

    } /* testSetAlink01 End */

} /* BodyTagTest Class End */
