/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.PropertyTestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.ForwardAction}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * JSPȂǂփtH[hANV
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.ForwardAction
 */
public class ForwardActionTest extends PropertyTestCase {

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * vpeB
     * @see jp.terasoluna.utlib.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        clearProperty();
    }

    /**
     * vpeBNAbv
     * @see jp.terasoluna.utlib.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
        clearProperty();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ForwardActionTest(String name) {
        super(name);
    }

    /**
     * testDoExecute01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         (vpeB) forwardAction.contextRelative:true
     *         
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) res.sendError():ĂяomF<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")null̏ꍇAHttpServletResponse.sendError()ĂяoAnullԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute01() throws Exception {
        // O
        ForwardAction action = new ForwardAction();

        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  true ɐݒ
        addProperty("forwardAction.contextRelative", "true");
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub01 res =
            new ForwardAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertNull(forward);
        assertTrue(res.isSendError);
    }

    /**
     * testDoExecute02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         () res.sendError():IOException<br>
     *         (vpeB) forwardAction.contextRelative:true
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Error page(404) forwarding failed."<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")nullŁAHttpServletResponse.sendError()ďoŗOꍇASystemException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // O
        ForwardAction action = new ForwardAction();

        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  true ɐݒ
        addProperty("forwardAction.contextRelative", "true");
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub02 res =
            new ForwardAction_HttpServletResponseStub02();
        
        @SuppressWarnings("unused") ActionForward forward = null;

        // eXg{
        try {
            forward = action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // IOExceptionbv
            assertEquals(e.getCause().getClass().getName(),
                    IOException.class.getName());
            // G[OmF
            assertTrue(LogUTUtil.checkError(
                    "Error page(404) forwarding failed."));
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         (vpeB) forwardAction.contextRelative:true
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ftrue<br>
     * <br>
     * mappingp[^̎擾ʂnot null̏ꍇAActionForwardpathw肵pathƈv邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute03() throws Exception {
        // O
        ForwardAction action = new ForwardAction();

        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  true ɐݒ
        addProperty("forwardAction.contextRelative", "true");
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals("abc", forward.getPath());
        assertTrue(forward.getContextRelative());
    }

    /**
     * testDoExecute04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         (vpeB) forwardAction.contextRelative:true
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ftrue<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")not null̏ꍇAp[^̎擾ʂJڐƂĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute04() throws Exception {
        // O
        ForwardAction action = new ForwardAction();

        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  true ɐݒ
        addProperty("forwardAction.contextRelative", "true");

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals("abc", forward.getPath());
        assertTrue(forward.getContextRelative());
    }

    /**
     * testDoExecute05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         (vpeB) forwardAction.contextRelative:true
     *         
     * <br>
     * ҒlF(߂l) actionForward:mapping.findForward("success")<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ffalse<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnullmapping.findForward("success")not null̏ꍇAmapping.findForward("success")ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute05() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  true ɐݒ
        addProperty("forwardAction.contextRelative", "true");

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");

        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals(af, forward);
        assertFalse(forward.getContextRelative());
    }
    
    /**
     * testDoExecute06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         (vpeB) forwardAction.contextRelative:false
     *         
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) res.sendError():ĂяomF<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")null̏ꍇAHttpServletResponse.sendError()ĂяoAnullԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute06() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  false ɐݒ
        addProperty("forwardAction.contextRelative", "false");
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub01 res =
            new ForwardAction_HttpServletResponseStub01();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertNull(forward);
        assertTrue(res.isSendError);
    }

    /**
     * testDoExecute07()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         () res.sendError():IOException<br>
     *         (vpeB) forwardAction.contextRelative:false
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Error page(404) forwarding failed."<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")nullŁAHttpServletResponse.sendError()ďoŗOꍇASystemException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute07() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  false ɐݒ
        addProperty("forwardAction.contextRelative", "false");
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub02 res =
            new ForwardAction_HttpServletResponseStub02();
        
        @SuppressWarnings("unused") ActionForward forward = null;
    
        // eXg{
        try {
            forward = action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // IOExceptionbv
            assertEquals(e.getCause().getClass().getName(),
                    IOException.class.getName());
            // G[OmF
            assertTrue(LogUTUtil.checkError(
                    "Error page(404) forwarding failed."));
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         (vpeB) forwardAction.contextRelative:false
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ffalse<br>
     * <br>
     * mappingp[^̎擾ʂnot null̏ꍇAActionForwardpathw肵pathƈv邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute08() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  false ɐݒ
        addProperty("forwardAction.contextRelative", "false");
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertEquals("abc", forward.getPath());
        assertFalse(forward.getContextRelative());
    }

    /**
     * testDoExecute09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         (vpeB) forwardAction.contextRelative:false
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ffalse<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")not null̏ꍇAp[^̎擾ʂJڐƂĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute09() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  false ɐݒ
        addProperty("forwardAction.contextRelative", "false");
    
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertEquals("abc", forward.getPath());
        assertFalse(forward.getContextRelative());
    }

    /**
     * testDoExecute10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         (vpeB) forwardAction.contextRelative:false
     *         
     * <br>
     * ҒlF(߂l) actionForward:mapping.findForward("success")<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ffalse<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnullmapping.findForward("success")not null̏ꍇAmapping.findForward("success")ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute10() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // vpeBNA
        clearProperty();
        
        // vpeB forwardAction.contextRelative  false ɐݒ
        addProperty("forwardAction.contextRelative", "false");
    
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");
    
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertEquals(af, forward);
        assertFalse(forward.getContextRelative());
    }

    /**
     * testDoExecute11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         (vpeB) forwardAction.contextRelative:ݒ
     *         
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) res.sendError():ĂяomF<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")null̏ꍇAHttpServletResponse.sendError()ĂяoAnullԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute11() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
                
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub01 res =
            new ForwardAction_HttpServletResponseStub01();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertNull(forward);
        assertTrue(res.isSendError);
    }

    /**
     * testDoExecute12()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         () res.sendError():IOException<br>
     *         (vpeB) forwardAction.contextRelative:ݒ
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Error page(404) forwarding failed."<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")nullŁAHttpServletResponse.sendError()ďoŗOꍇASystemException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute12() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub02 res =
            new ForwardAction_HttpServletResponseStub02();
        
        @SuppressWarnings("unused") ActionForward forward = null;
    
        // eXg{
        try {
            forward = action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // IOExceptionbv
            assertEquals(e.getCause().getClass().getName(),
                    IOException.class.getName());
            // G[OmF
            assertTrue(LogUTUtil.checkError(
                    "Error page(404) forwarding failed."));
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute13()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         (vpeB) forwardAction.contextRelative:ݒ
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ffalse<br>
     * <br>
     * mappingp[^̎擾ʂnot null̏ꍇAActionForwardpathw肵pathƈv邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute13() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertEquals("abc", forward.getPath());
        assertFalse(forward.getContextRelative());
    }

    /**
     * testDoExecute14()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         (vpeB) forwardAction.contextRelative:ݒ
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ffalse<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")not null̏ꍇAp[^̎擾ʂJڐƂĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute14() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
    
        // vpeBNA
        clearProperty();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertEquals("abc", forward.getPath());
        assertFalse(forward.getContextRelative());
    }

    /**
     * testDoExecute15()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         (vpeB) forwardAction.contextRelative:ݒ
     *         
     * <br>
     * ҒlF(߂l) actionForward:mapping.findForward("success")<br>
     *         (߂l) actionForward:ActionForward.getContextRelative()Ffalse<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnullmapping.findForward("success")not null̏ꍇAmapping.findForward("success")ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoExecute15() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // vpeBNA
        clearProperty();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");
    
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;
    
        // eXg{
        forward = action.doExecute(mapping, form, req, res);
    
        // 
        assertEquals(af, forward);
        assertFalse(forward.getContextRelative());
    }
    
}
