/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import jp.terasoluna.fw.exception.SystemException;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.DownloadByteArray} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * oCgz_E[hf[^Ƃ邽߂̃NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.DownloadByteArray
 */
public class DownloadByteArrayTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DownloadByteArrayTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DownloadByteArrayTest(String name) {
        super(name);
    }

    /**
     * testDownloadByteArray01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *         () byteArray:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.no.download.content"<br>
     *                    bvOF<br>
     *                    IllegalArgumentException<br>
     *         
     * <br>
     * byteArraynull̏ꍇAOX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadByteArray01() throws Exception {
        // O

        // eXg{
        try {
            DownloadByteArray downloadByteArray = new DownloadByteArray(null,
                    null);
            fail("SystemException܂ł");
        } catch (SystemException e) {
            // 
            assertEquals("errors.no.download.content", e.getErrorCode());
            assertEquals(IllegalArgumentException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testDownloadByteArray02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:null<br>
     *         () byteArray:byte[]<br>
     *         
     * <br>
     * ҒlF(ԕω) name:null<br>
     *         (ԕω) byteArray:byte[]<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_FILEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * contentType, charsetɃftHglݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadByteArray02() throws Exception {
        // O
        byte[] byteBs = new byte[0];

        // eXg{
        DownloadByteArray downloadByteArray = new DownloadByteArray(null,
                byteBs);

        // 
        assertNull(downloadByteArray.name);
        assertEquals(byteBs, downloadByteArray.byteArray);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadByteArray.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadByteArray.charset);
    }

    /**
     * testDownloadByteArray03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"  "i󔒁j<br>
     *         () yteArray:byte[]<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"  "i󔒁j<br>
     *         (ԕω) byteArray:byte[]<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_FILEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadByteArray03() throws Exception {
        // O
        byte[] byteBs = new byte[0];

        // eXg{
        DownloadByteArray downloadByteArray = new DownloadByteArray("  ",
                byteBs);

        // 
        assertEquals("  ", downloadByteArray.name);
        assertEquals(byteBs, downloadByteArray.byteArray);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadByteArray.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadByteArray.charset);
    }

    /**
     * testDownloadByteArray04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""i󕶎j<br>
     *         () byteArray:byte[]<br>
     *         
     * <br>
     * ҒlF(ԕω) name:""i󕶎j<br>
     *         (ԕω) byteArray:byte[]<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_FILEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadByteArray04() throws Exception {
        // O
        byte[] byteBs = new byte[0];

        // eXg{
        DownloadByteArray downloadByteArray = new DownloadByteArray("", byteBs);

        // 
        assertEquals("", downloadByteArray.name);
        assertEquals(byteBs, downloadByteArray.byteArray);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadByteArray.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadByteArray.charset);
    }

    /**
     * testDownloadByteArray05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         () byteArray:byte[1, 2]<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"abc"<br>
     *         (ԕω) byteArray:byte[1, 2]<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_FILEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadByteArray05() throws Exception {
        // O
        byte[] byteBs = new byte[] { 1, 2 };

        // eXg{
        DownloadByteArray downloadByteArray = new DownloadByteArray("abc",
                byteBs);

        // 
        assertEquals("abc", downloadByteArray.name);
        assertEquals(byteBs, downloadByteArray.byteArray);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadByteArray.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadByteArray.charset);
    }

    /**
     * testGetLengthOfData01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() byteArray:byte[1, 2]<br>
     *         
     * <br>
     * ҒlF(߂l) int:2<br>
     *         
     * <br>
     * byteArraỹTCYԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLengthOfData01() throws Exception {
        // O
        DownloadByteArray downloadByteArray = new DownloadByteArray("",
                new byte[0]);
        downloadByteArray.byteArray = new byte[] { 1, 2 };

        // eXg{
        int num = downloadByteArray.getLengthOfData();

        // 
        assertEquals(2, num);
    }

    /**
     * testGetStreamInternal01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() byteArray:byte[1, 2]<br>
     *         
     * <br>
     * ҒlF(߂l) InputStream:ByteArrayInputStream(byte[1, 2])<br>
     *         
     * <br>
     * byteArraybvByteArrayInputStreamԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetStreamInternal01() throws Exception {
        // O
        DownloadByteArray downloadByteArray = new DownloadByteArray("",
                new byte[0]);
        downloadByteArray.byteArray = new byte[] { 1, 2 };

        // eXg{
        InputStream stream = downloadByteArray.getStreamInternal();

        // 
        // ByteArrayInputStreamԋpĂ邩mF
        assertNotNull(stream);
        assertEquals(ByteArrayInputStream.class.getName(), stream.getClass()
                .getName());

        // ByteArrayInputStreambyteArraybvĂ邩mF
        assertEquals(1, stream.read());
        assertEquals(2, stream.read());
        assertEquals(-1, stream.read());
    }

}
